/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;

public class FromVTI
extends FromTable
implements VTIEnvironment {
    JBitSet correlationMap;
    JBitSet dependencyMap;
    NewInvocationNode newInvocation;
    TableName exposedName;
    SubqueryList subqueryList;
    boolean implementsVTICosting;
    boolean optimized;
    boolean materializable;
    boolean isTarget;
    ResultSet rs;
    private FormatableHashtable compileTimeConstants;
    protected int numVTICols;
    private PredicateList restrictionList;
    private boolean forUpdatePresent;
    private boolean emptyForUpdate;
    double estimatedCost = 100000.0;
    double estimatedRowCount = 10000.0;
    boolean supportsMultipleInstantiations = true;
    boolean vtiCosted;
    protected boolean version2;
    private boolean implementsPushable;
    private PreparedStatement ps;
    private JavaValueNode[] methodParms;
    private boolean controlsDeferral;
    private boolean isInsensitive;
    private int resultSetType = 1003;

    public void init(Object newInvocation, Object correlationName, Object derivedRCL, Object tableProperties) throws StandardException {
        this.init(newInvocation, correlationName, derivedRCL, tableProperties, this.makeTableName(null, (String)correlationName));
    }

    public void init(Object newInvocation, Object correlationName, Object derivedRCL, Object tableProperties, Object exposedTableName) throws StandardException {
        super.init(correlationName, tableProperties);
        this.newInvocation = (NewInvocationNode)newInvocation;
        this.resultColumns = (ResultColumnList)derivedRCL;
        this.subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.exposedName = (TableName)exposedTableName;
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.costEstimate = this.getCostEstimate(optimizer);
        if (this.implementsVTICosting && !this.vtiCosted) {
            try {
                VTICosting vtic = this.version2 ? (VTICosting)((Object)this.ps) : (VTICosting)((Object)this.rs);
                this.estimatedCost = vtic.getEstimatedCostPerInstantiation(this);
                this.estimatedRowCount = vtic.getEstimatedRowCount(this);
                this.supportsMultipleInstantiations = vtic.supportsMultipleInstantiations(this);
                if (this.ps != null) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (SQLException sqle) {
                throw StandardException.unexpectedUserException(sqle);
            }
            this.vtiCosted = true;
        }
        this.costEstimate.setCost(this.estimatedCost, this.estimatedRowCount, this.estimatedRowCount);
        if (this.getCurrentAccessPath().getJoinStrategy().multiplyBaseCostByOuterRows()) {
            this.costEstimate.multiply(outerCost.rowCount(), this.costEstimate);
        }
        if (!this.optimized) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.costEstimate.rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.costEstimate;
    }

    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        JBitSet tempBitSet = assignedTableMap;
        tempBitSet.or(this.correlationMap);
        return tempBitSet.contains(this.dependencyMap);
    }

    public boolean isMaterializable() {
        return this.materializable;
    }

    public boolean supportsMultipleInstantiations() {
        return this.supportsMultipleInstantiations;
    }

    public void adjustForSortElimination() {
    }

    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        return super.modifyAccessPath(outerTables);
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!this.implementsPushable) {
            return false;
        }
        if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
            return false;
        }
        if (this.restrictionList == null) {
            this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    public String toString() {
        return "materializable: " + this.materializable + "\n" + super.toString();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.newInvocation != null) {
            this.printLabel(depth, "newInvocation: ");
            this.newInvocation.treePrint(depth + 1);
        }
        if (this.exposedName != null) {
            this.printLabel(depth, "exposedName: ");
            this.exposedName.treePrint(depth + 1);
        }
        if (this.subqueryList != null) {
            this.printLabel(depth, "subqueryList: ");
            this.subqueryList.treePrint(depth + 1);
        }
    }

    public NewInvocationNode getNewInvocation() {
        return this.newInvocation;
    }

    public String getExposedName() {
        return this.correlationName;
    }

    public TableName getExposedTableName() {
        return this.exposedName;
    }

    void setTarget() {
        this.isTarget = true;
        this.version2 = true;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    String getVTIName() {
        return this.newInvocation.getJavaClassName();
    }

    public ResultSetNode bindVTITables(FromList fromListParam) throws StandardException {
        ResultColumnList derivedRCL = this.resultColumns;
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        Vector aggregateVector = new Vector();
        this.newInvocation.bindExpression(fromListParam, this.subqueryList, aggregateVector);
        if (!this.newInvocation.assignableTo("java.sql.PreparedStatement")) {
            if (this.version2) {
                throw StandardException.newException("42X08", (Object)this.getVTIName(), (Object)"java.sql.PreparedStatement");
            }
            if (!this.newInvocation.assignableTo("java.sql.ResultSet")) {
                throw StandardException.newException("42X08", (Object)this.getVTIName(), (Object)"java.sql.ResultSet");
            }
        } else {
            this.version2 = true;
        }
        if (this.version2) {
            this.implementsPushable = this.newInvocation.assignableTo("org.apache.derby.vti.IQualifyable");
        }
        this.implementsVTICosting = this.newInvocation.assignableTo("org.apache.derby.vti.VTICosting");
        this.methodParms = this.newInvocation.getMethodParms();
        UUID triggerTableId = this.getSpecialTriggerVTITableName(lcc, this.newInvocation.getJavaClassName());
        if (triggerTableId != null) {
            TableDescriptor td = this.getDataDictionary().getTableDescriptor(triggerTableId);
            this.resultColumns = this.genResultColList(td);
            this.vtiCosted = true;
            this.estimatedCost = 50.0;
            this.estimatedRowCount = 5.0;
            this.supportsMultipleInstantiations = true;
        } else {
            ResultSetMetaData rsmd = this.getResultSetMetaData();
            if (rsmd == null) {
                throw StandardException.newException("42X43", this.getVTIName());
            }
            try {
                this.numVTICols = rsmd.getColumnCount();
            }
            catch (SQLException sqle) {
                this.numVTICols = 0;
            }
            this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            this.resultColumns.createListFromResultSetMetaData(rsmd, this.exposedName, this.newInvocation.getJavaClassName());
        }
        this.numVTICols = this.resultColumns.size();
        if (derivedRCL != null) {
            this.resultColumns.propagateDCLInfo(derivedRCL, this.correlationName);
        }
        return this;
    }

    public ResultSetMetaData getResultSetMetaData() throws StandardException {
        ResultSetMetaData rsmd;
        block10: {
            rsmd = null;
            try {
                if (this.version2) {
                    this.ps = (PreparedStatement)this.getNewInstance();
                    if (this.ps.getResultSetConcurrency() != 1008) {
                        throw StandardException.newException("42Z90", this.getVTIName());
                    }
                    rsmd = this.ps.getMetaData();
                    this.controlsDeferral = this.ps instanceof DeferModification;
                    try {
                        this.resultSetType = this.ps.getResultSetType();
                    }
                    catch (SQLException sqle) {
                    }
                    catch (AbstractMethodError ame) {
                    }
                    catch (NoSuchMethodError nsme) {
                        // empty catch block
                    }
                    boolean bl = this.isInsensitive = this.resultSetType == 1004;
                    if (!this.implementsVTICosting) {
                        this.ps.close();
                        this.ps = null;
                    }
                    break block10;
                }
                this.rs = (ResultSet)this.getNewInstance();
                rsmd = this.rs.getMetaData();
                if (!this.implementsVTICosting) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        return rsmd;
    }

    private Object getNewInstance() throws StandardException {
        Class[] paramTypeClasses = this.newInvocation.getMethodParameterClasses();
        Object[] paramObjects = null;
        if (paramTypeClasses != null) {
            paramObjects = new Object[paramTypeClasses.length];
            for (int index = 0; index < paramTypeClasses.length; ++index) {
                Class paramClass = paramTypeClasses[index];
                paramObjects[index] = this.methodParms[index].getConstantValueAsObject();
                if (paramObjects[index] != null && paramClass.isPrimitive()) {
                    if (paramClass.equals(Short.TYPE)) {
                        paramObjects[index] = new Short(((Integer)paramObjects[index]).shortValue());
                    } else if (paramClass.equals(Byte.TYPE)) {
                        paramObjects[index] = new Byte(((Integer)paramObjects[index]).byteValue());
                    }
                }
                if (paramObjects[index] != null || !paramClass.isPrimitive()) continue;
                if (paramClass.equals(Integer.TYPE)) {
                    paramObjects[index] = new Integer(0);
                    continue;
                }
                if (paramClass.equals(Short.TYPE)) {
                    paramObjects[index] = new Short(0);
                    continue;
                }
                if (paramClass.equals(Byte.TYPE)) {
                    paramObjects[index] = new Byte(0);
                    continue;
                }
                if (paramClass.equals(Long.TYPE)) {
                    paramObjects[index] = new Long(0L);
                    continue;
                }
                if (paramClass.equals(Float.TYPE)) {
                    paramObjects[index] = new Float(0.0f);
                    continue;
                }
                if (paramClass.equals(Double.TYPE)) {
                    paramObjects[index] = new Double(0.0);
                    continue;
                }
                if (paramClass.equals(Boolean.TYPE)) {
                    paramObjects[index] = Boolean.FALSE;
                    continue;
                }
                if (!paramClass.equals(Character.TYPE)) continue;
                paramObjects[index] = new Character('\u0000');
            }
        } else {
            paramTypeClasses = new Class[]{};
            paramObjects = new Object[]{};
        }
        try {
            ClassInspector classInspector = this.getClassFactory().getClassInspector();
            String javaClassName = this.newInvocation.getJavaClassName();
            Constructor constructor = classInspector.getClass(javaClassName).getConstructor(paramTypeClasses);
            return constructor.newInstance(paramObjects);
        }
        catch (Throwable t) {
            InvocationTargetException ite;
            Throwable wrappedThrowable;
            if (t instanceof InvocationTargetException && (wrappedThrowable = (ite = (InvocationTargetException)t).getTargetException()) instanceof StandardException) {
                throw (StandardException)wrappedThrowable;
            }
            throw StandardException.unexpectedUserException(t);
        }
    }

    public DeferModification getDeferralControl() throws StandardException {
        if (!this.controlsDeferral) {
            return null;
        }
        try {
            return (DeferModification)this.getNewInstance();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
        ResultColumnList derivedRCL = this.resultColumns;
        this.materializable = this.newInvocation.areParametersQueryInvariant();
        Vector colRefs = this.getNodesFromParameters(ColumnReference.class);
        Vector aggregateVector = null;
        Enumeration e = colRefs.elements();
        while (e.hasMoreElements()) {
            ColumnReference ref = (ColumnReference)e.nextElement();
            if (ref.getTableNumber() != -1) continue;
            if (aggregateVector == null) {
                aggregateVector = new Vector();
            }
            ref.bindExpression(fromListParam, this.subqueryList, aggregateVector);
        }
    }

    Vector getNodesFromParameters(Class nodeClass) throws StandardException {
        CollectNodesVisitor getCRs = new CollectNodesVisitor(nodeClass);
        this.newInvocation.accept(getCRs);
        return getCRs.getList();
    }

    public ResultColumnList getAllResultColumns(TableName allTableName) throws StandardException {
        ResultColumnList rcList = null;
        TableName toCompare = allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int rclSize = this.resultColumns.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(index);
            if (resultColumn.isGenerated()) continue;
            String columnName = resultColumn.getName();
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnName, this.exposedName, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.resultColumns == null) {
            return null;
        }
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getTableNameNode();
        if ((columnsTableName == null || columnsTableName.equals(this.exposedName)) && (resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.newInvocation.preprocess(numTables, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
        this.referencedTableMap = new JBitSet(numTables);
        this.referencedTableMap.set(this.tableNumber);
        this.newInvocation.categorize(this.referencedTableMap, false);
        this.dependencyMap = new JBitSet(numTables);
        for (int index = 0; index < numTables; ++index) {
            if (index == this.tableNumber || !this.referencedTableMap.get(index)) continue;
            this.dependencyMap.set(index);
        }
        this.correlationMap = new JBitSet(numTables);
        this.newInvocation.getCorrelationTables(this.correlationMap);
        return this.genProjectRestrict(numTables);
    }

    protected ResultSetNode genProjectRestrict(int numTables) throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns, false);
        prRCList.doProjection();
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    public boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return outerTables.getFirstSetBit() != -1 && !outerTables.hasSingleBitSet() && !this.getTrulyTheBestAccessPath().getJoinStrategy().doesMaterialization() && this.isMaterializable() && !this.supportsMultipleInstantiations;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        this.newInvocation.accept(rcrv);
        this.assignResultSetNumber();
        acb.pushGetResultSetFactoryExpression(mb);
        int nargs = this.getScanArguments(acb, mb);
        mb.callMethod((short)185, null, "getVTIResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", nargs);
    }

    private int getScanArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int rclSize = this.resultColumns.size();
        FormatableBitSet referencedCols = new FormatableBitSet(rclSize);
        int erdNumber = -1;
        int numSet = 0;
        this.costEstimate = this.getFinalCostEstimate();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (!rc.isReferenced()) continue;
            referencedCols.set(index);
            ++numSet;
        }
        if (numSet != this.numVTICols) {
            erdNumber = acb.addItem(referencedCols);
        }
        int ctcNumber = acb.addItem(this.compileTimeConstants);
        acb.pushThisAsActivation(mb);
        this.resultColumns.generateHolder(acb, mb);
        boolean reuseablePs = this.version2 && this.getNodesFromParameters(ParameterNode.class).size() == 0 && this.getNodesFromParameters(ColumnReference.class).size() == 0;
        mb.push(this.resultSetNumber);
        this.generateConstructor(acb, mb, reuseablePs);
        mb.push(this.newInvocation.getJavaClassName());
        if (this.restrictionList != null) {
            this.restrictionList.generateQualifiers(acb, mb, this, true);
        } else {
            mb.pushNull("org.apache.derby.iapi.store.access.Qualifier[][]");
        }
        mb.push(erdNumber);
        mb.push(this.version2);
        mb.push(reuseablePs);
        mb.push(ctcNumber);
        mb.push(this.isTarget);
        mb.push(this.getCompilerContext().getScanIsolationLevel());
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        return 14;
    }

    private void generateConstructor(ActivationClassBuilder acb, MethodBuilder mb, boolean reuseablePs) throws StandardException {
        LocalField psHolder;
        String vtiType = this.version2 ? "java.sql.PreparedStatement" : "java.sql.ResultSet";
        MethodBuilder userExprFun = acb.newGeneratedFun(vtiType, 1);
        userExprFun.addThrownException("java.lang.Exception");
        LocalField localField = psHolder = reuseablePs ? acb.newFieldDeclaration(2, "java.sql.PreparedStatement") : null;
        if (reuseablePs) {
            userExprFun.getField(psHolder);
            userExprFun.conditionalIfNull();
        }
        this.newInvocation.generateExpression(acb, userExprFun);
        userExprFun.upCast(vtiType);
        if (reuseablePs) {
            userExprFun.putField(psHolder);
            userExprFun.startElseCode();
            userExprFun.getField(psHolder);
            userExprFun.completeConditional();
        }
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushMethodReference(mb, userExprFun);
        if (reuseablePs) {
            MethodBuilder closeActivationMethod = acb.getCloseActivationMethod();
            closeActivationMethod.getField(psHolder);
            closeActivationMethod.conditionalIfNull();
            closeActivationMethod.push(0);
            closeActivationMethod.startElseCode();
            closeActivationMethod.getField(psHolder);
            closeActivationMethod.callMethod((short)185, "java.sql.Statement", "close", "void", 0);
            closeActivationMethod.push(0);
            closeActivationMethod.completeConditional();
            closeActivationMethod.endStatement();
        }
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return !baseTable && name.equals(this.newInvocation.getJavaClassName());
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (!v.stopTraversal()) {
            this.newInvocation = (NewInvocationNode)this.newInvocation.accept(v);
        }
        return returnNode;
    }

    private UUID getSpecialTriggerVTITableName(LanguageConnectionContext lcc, String className) throws StandardException {
        if (className.equals("org.apache.derby.catalog.TriggerNewTransitionRows") || className.equals("org.apache.derby.catalog.TriggerOldTransitionRows")) {
            if (lcc.getTriggerTable() != null) {
                return lcc.getTriggerTable().getUUID();
            }
            if (lcc.getTriggerExecutionContext() != null) {
                return lcc.getTriggerExecutionContext().getTargetTableId();
            }
            throw StandardException.newException("42Y45", className);
        }
        return null;
    }

    private ResultColumnList genResultColList(TableDescriptor td) throws StandardException {
        ResultColumnList rcList = null;
        ColumnDescriptor colDesc = null;
        TableName tableName = this.makeTableName(td.getSchemaName(), td.getName());
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            colDesc = cdl.elementAt(index);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, colDesc.getColumnName(), this.exposedName, colDesc.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, colDesc, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    public boolean needsSpecialRCLBinding() {
        return true;
    }

    boolean isUpdatableCursor() throws StandardException {
        return true;
    }

    protected void markUpdatableByCursor(Vector updateColumns) {
        super.markUpdatableByCursor(updateColumns);
        this.forUpdatePresent = true;
        this.emptyForUpdate = updateColumns == null || updateColumns.size() == 0;
    }

    private int[] getForUpdateColumnList() {
        int[] list;
        int[] tempList = new int[this.getNumColumnsReturned()];
        int offset = 0;
        for (int col = 0; col < tempList.length; ++col) {
            if (!this.resultColumns.updatableByCursor(col)) continue;
            tempList[offset++] = col + 1;
        }
        if (offset == tempList.length) {
            list = tempList;
        } else {
            list = new int[offset];
            System.arraycopy(tempList, 0, list, 0, offset);
        }
        return list;
    }

    public final boolean isCompileTime() {
        return true;
    }

    public String getOriginalSQL() {
        return this.getCompilerContext().getParser().getSQLtext();
    }

    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getCompilerContext().getScanIsolationLevel()];
    }

    public void setSharedState(String key, Serializable value) {
        if (key == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            this.compileTimeConstants = new FormatableHashtable();
        }
        this.compileTimeConstants.put(key, value);
    }

    public Object getSharedState(String key) {
        if (key == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(key);
    }
}

