/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class DropTriggerNode
extends DDLStatementNode {
    private TableDescriptor td;

    public String statementToString() {
        return "DROP TRIGGER";
    }

    public void bindStatement() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        SchemaDescriptor sd = this.getSchemaDescriptor();
        TriggerDescriptor triggerDescriptor = null;
        if (sd.getUUID() != null) {
            triggerDescriptor = dd.getTriggerDescriptor(this.getRelativeName(), sd);
        }
        if (triggerDescriptor == null) {
            throw StandardException.newException("42X94", (Object)"TRIGGER", (Object)this.getFullName());
        }
        this.td = triggerDescriptor.getTableDescriptor();
        cc.createDependency(this.td);
        cc.createDependency(triggerDescriptor);
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropTriggerConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.td.getUUID());
    }
}

