/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class DefaultNode
extends ValueNode {
    private String columnName;
    private String defaultText;
    private ValueNode defaultTree;

    public void init(Object defaultTree, Object defaultText) {
        this.defaultTree = (ValueNode)defaultTree;
        this.defaultText = (String)defaultText;
    }

    public void init(Object columnName) {
        this.columnName = (String)columnName;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    ValueNode getDefaultTree() {
        return this.defaultTree;
    }

    public String toString() {
        return "defaultTree: " + this.defaultTree + "\n" + "defaultText: " + this.defaultText + "\n" + super.toString();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        TableDescriptor td;
        ColumnDescriptor cd;
        SanityManager.ASSERT(fromList.size() != 0, "fromList expected to be non-empty");
        if (!(fromList.elementAt(0) instanceof FromBaseTable)) {
            SanityManager.THROWASSERT("fromList.elementAt(0) expected to be instanceof FromBaseTable, not " + fromList.elementAt(0).getClass().getName());
        }
        SanityManager.ASSERT((cd = (td = ((FromBaseTable)fromList.elementAt(0)).getTableDescriptor()).getColumnDescriptor(this.columnName)) != null, "cd expected to be non-null");
        DefaultInfoImpl defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo();
        if (defaultInfo != null) {
            String defaultText = defaultInfo.getDefaultText();
            ValueNode defaultTree = DefaultNode.parseDefault(defaultText, this.getLanguageConnectionContext(), this.getCompilerContext());
            DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(this.getDataDictionary());
            this.getCompilerContext().createDependency(defaultDescriptor);
            return defaultTree.bindExpression(fromList, subqueryList, aggregateVector);
        }
        ValueNode nullNode = (ValueNode)this.getNodeFactory().getNode(13, this.getContextManager());
        return nullNode;
    }

    public static ValueNode parseDefault(String defaultText, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
        CursorNode cn;
        String values = "VALUES " + defaultText;
        CompilerContext newCC = lcc.pushCompilerContext();
        Parser p = newCC.getParser();
        StatementNode qt = p.parseStatement(values);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT("qt expected to be instanceof CursorNode, not " + qt.getClass().getName());
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT("cn.getResultSetNode() expected to be instanceof RowResultSetNode, not " + cn.getResultSetNode().getClass().getName());
        }
        ValueNode defaultTree = ((ResultColumn)((CursorNode)qt).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        lcc.popCompilerContext(newCC);
        return defaultTree;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT("generateExpression not expected to be called");
    }

    protected boolean isEquivalent(ValueNode other) {
        return false;
    }
}

