/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;

public class CreateViewNode
extends DDLStatementNode {
    ResultColumnList resultColumns;
    ResultSetNode queryExpression;
    String qeText;
    int checkOption;
    ProviderInfo[] providerInfos;
    ColumnInfo[] colInfos;

    public void init(Object newObjectName, Object resultColumns, Object queryExpression, Object checkOption, Object qeText) throws StandardException {
        this.initAndCheck(newObjectName);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.queryExpression = (ResultSetNode)queryExpression;
        this.checkOption = (Integer)checkOption;
        this.qeText = ((String)qeText).trim();
        this.implicitCreateSchema = true;
    }

    public String toString() {
        return super.toString() + "checkOption: " + this.checkOption + "\n" + "qeText: " + this.qeText + "\n";
    }

    public String statementToString() {
        return "CREATE VIEW";
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.resultColumns != null) {
            this.printLabel(depth, "resultColumns: ");
            this.resultColumns.treePrint(depth + 1);
        }
        this.printLabel(depth, "queryExpression: ");
        this.queryExpression.treePrint(depth + 1);
    }

    public int getCheckOption() {
        return this.checkOption;
    }

    public ProviderInfo[] getProviderInfo() {
        return this.providerInfos;
    }

    public ColumnInfo[] getColumnInfo() {
        return this.colInfos;
    }

    public void bindStatement() throws StandardException {
        String duplicateColName;
        CompilerContext cc = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.providerInfos = this.bindViewDefinition(dataDictionary, cc, this.getLanguageConnectionContext(), this.getNodeFactory(), this.queryExpression, this.getContextManager());
        ResultColumnList qeRCL = this.queryExpression.getResultColumns();
        if (this.resultColumns != null) {
            if (this.resultColumns.size() != qeRCL.visibleSize()) {
                throw StandardException.newException("42X56", this.getFullName());
            }
            qeRCL.copyResultColumnNames(this.resultColumns);
        }
        if ((duplicateColName = qeRCL.verifyUniqueNames(this.resultColumns == null)) != null) {
            throw StandardException.newException("42Y13", duplicateColName);
        }
        if (this.queryExpression.getResultColumns().size() > 5000) {
            throw StandardException.newException("54011", (Object)String.valueOf(this.queryExpression.getResultColumns().size()), (Object)this.getRelativeName(), (Object)String.valueOf(5000));
        }
        this.colInfos = new ColumnInfo[this.queryExpression.getResultColumns().size()];
        this.genColumnInfos(this.colInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo[] bindViewDefinition(DataDictionary dataDictionary, CompilerContext compilerContext, LanguageConnectionContext lcc, NodeFactory nodeFactory, ResultSetNode queryExpr, ContextManager cm) throws StandardException {
        FromList fromList = (FromList)nodeFactory.getNode(37, nodeFactory.doJoinOrderOptimization(), cm);
        ProviderList prevAPL = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList apl = new ProviderList();
        try {
            compilerContext.setCurrentAuxiliaryProviderList(apl);
            compilerContext.pushCurrentPrivType(0);
            queryExpr = queryExpr.bindNonVTITables(dataDictionary, fromList);
            queryExpr = queryExpr.bindVTITables(fromList);
            queryExpr.bindExpressions(fromList);
            if (queryExpr instanceof SelectNode && queryExpr.referencesSessionSchema()) {
                throw StandardException.newException("XCL51.S");
            }
            queryExpr.bindResultColumns(fromList);
            queryExpr.bindUntypedNullsToResultColumns(null);
        }
        finally {
            compilerContext.popCurrentPrivType();
            compilerContext.setCurrentAuxiliaryProviderList(prevAPL);
        }
        DependencyManager dm = dataDictionary.getDependencyManager();
        ProviderInfo[] providerInfos = dm.getPersistentProviderInfos(apl);
        dm.clearColumnInfoInProviders(apl);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
        return providerInfos;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.queryExpression.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getCreateViewConstantAction(this.getSchemaDescriptor().getSchemaName(), this.getRelativeName(), 2, this.qeText, this.checkOption, this.colInfos, this.providerInfos, null);
    }

    private void genColumnInfos(ColumnInfo[] colInfos) {
        ResultColumnList rcl = this.queryExpression.getResultColumns();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)rcl.elementAt(index);
            colInfos[index] = new ColumnInfo(rc.getName(), rc.getType(), null, null, null, null, 0, 0L, 0L, 0L);
        }
    }

    ResultSetNode getParsedQueryExpression() {
        return this.queryExpression;
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (!v.stopTraversal()) {
            super.accept(v);
        }
        if (this.queryExpression != null && !v.stopTraversal()) {
            this.queryExpression = (ResultSetNode)this.queryExpression.accept(v);
        }
        return returnNode;
    }
}

