/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;

public class CreateTableNode
extends DDLStatementNode {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private Properties properties;
    private TableElementList tableElementList;
    protected int tableType;
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;

    public void init(Object newObjectName, Object tableElementList, Object properties, Object lockGranularity) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = ((Character)lockGranularity).charValue();
        this.implicitCreateSchema = true;
        if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
            SanityManager.THROWASSERT("Unexpected value for lockGranularity = " + this.lockGranularity);
        }
        this.initAndCheck(newObjectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.properties = (Properties)properties;
    }

    public void init(Object newObjectName, Object tableElementList, Object properties, Object onCommitDeleteRows, Object onRollbackDeleteRows) throws StandardException {
        this.tableType = 3;
        newObjectName = this.tempTableSchemaNameCheck(newObjectName);
        this.onCommitDeleteRows = (Boolean)onCommitDeleteRows;
        this.onRollbackDeleteRows = (Boolean)onRollbackDeleteRows;
        this.initAndCheck(newObjectName);
        this.tableElementList = (TableElementList)tableElementList;
        this.properties = (Properties)properties;
        if (!this.onRollbackDeleteRows) {
            SanityManager.THROWASSERT("Unexpected value for onRollbackDeleteRows = " + this.onRollbackDeleteRows);
        }
    }

    public void init(Object newObjectName, Object resultColumns, Object queryExpression) throws StandardException {
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.initAndCheck(newObjectName);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.queryExpression = (ResultSetNode)queryExpression;
    }

    private Object tempTableSchemaNameCheck(Object objectName) throws StandardException {
        TableName tempTableName = (TableName)objectName;
        if (tempTableName != null) {
            if (tempTableName.getSchemaName() == null) {
                tempTableName.setSchemaName("SESSION");
            } else if (!this.isSessionSchema(tempTableName.getSchemaName())) {
                throw StandardException.newException("428EK");
            }
        }
        return tempTableName;
    }

    public String toString() {
        String tempString = "tableElementList: \n" + this.tableElementList + "\n";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: " + "\n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: " + "\n" + this.onRollbackDeleteRows + "\n";
        } else {
            tempString = tempString + "properties: " + "\n" + this.properties + "\n" + "lockGranularity: " + "\n" + this.lockGranularity + "\n";
        }
        return super.toString() + tempString;
    }

    public String statementToString() {
        if (this.tableType == 3) {
            return "DECLARE GLOBAL TEMPORARY TABLE";
        }
        return "CREATE TABLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindStatement() throws StandardException {
        FromList fromList;
        DataDictionary dataDictionary = this.getDataDictionary();
        int numPrimaryKeys = 0;
        int numCheckConstraints = 0;
        int numReferenceConstraints = 0;
        int numUniqueConstraints = 0;
        if (this.queryExpression != null) {
            fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            CompilerContext cc = this.getCompilerContext();
            ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
            ProviderList apl = new ProviderList();
            try {
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.pushCurrentPrivType(0);
                this.queryExpression = this.queryExpression.bindNonVTITables(dataDictionary, fromList);
                this.queryExpression = this.queryExpression.bindVTITables(fromList);
                this.queryExpression.bindExpressions(fromList);
                this.queryExpression.bindResultColumns(fromList);
                this.queryExpression.bindUntypedNullsToResultColumns(null);
            }
            finally {
                cc.popCurrentPrivType();
                cc.setCurrentAuxiliaryProviderList(prevAPL);
            }
            ResultColumnList qeRCL = this.queryExpression.getResultColumns();
            if (this.resultColumns != null) {
                if (this.resultColumns.size() != qeRCL.visibleSize()) {
                    throw StandardException.newException("42X70", this.getFullName());
                }
                qeRCL.copyResultColumnNames(this.resultColumns);
            }
            SchemaDescriptor sd = this.getSchemaDescriptor();
            int schemaCollationType = sd.getCollationType();
            this.tableElementList = new TableElementList();
            for (int index = 0; index < qeRCL.size(); ++index) {
                ResultColumn rc = (ResultColumn)qeRCL.elementAt(index);
                if (rc.isGenerated()) continue;
                if (rc.isNameGenerated()) {
                    throw StandardException.newException("42909");
                }
                DataTypeDescriptor dtd = rc.getExpressionType();
                if (dtd != null && !dtd.isUserCreatableType()) {
                    throw StandardException.newException("42X71", (Object)dtd.getFullSQLTypeName(), (Object)rc.getName());
                }
                if (dtd.getTypeId().isStringTypeId() && dtd.getCollationType() != schemaCollationType) {
                    String schemaCollationName = schemaCollationType == 0 ? "UCS_BASIC" : "TERRITORY_BASED";
                    throw StandardException.newException("42ZA3", (Object)dtd.getCollationName(), (Object)schemaCollationName);
                }
                ColumnDefinitionNode column = new ColumnDefinitionNode();
                column.init(rc.getName(), null, rc.getType(), null);
                this.tableElementList.addTableElement(column);
            }
        } else {
            this.tableElementList.setCollationTypesOnCharacterStringColumns(this.getSchemaDescriptor());
        }
        this.tableElementList.validate(this, dataDictionary, null);
        if (this.tableElementList.countNumberOfColumns() > 1012) {
            throw StandardException.newException("54011", (Object)String.valueOf(this.tableElementList.countNumberOfColumns()), (Object)this.getRelativeName(), (Object)String.valueOf(1012));
        }
        numPrimaryKeys = this.tableElementList.countConstraints(2);
        if (numPrimaryKeys > 1) {
            throw StandardException.newException("42X90", this.getRelativeName());
        }
        numCheckConstraints = this.tableElementList.countConstraints(4);
        numReferenceConstraints = this.tableElementList.countConstraints(6);
        numUniqueConstraints = this.tableElementList.countConstraints(3);
        if (this.tableType == 3 && (numPrimaryKeys > 0 || numCheckConstraints > 0 || numReferenceConstraints > 0 || numUniqueConstraints > 0)) {
            throw StandardException.newException("42995");
        }
        if (numPrimaryKeys + numReferenceConstraints + numUniqueConstraints > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", (Object)String.valueOf(numPrimaryKeys + numReferenceConstraints + numUniqueConstraints), (Object)this.getRelativeName(), (Object)String.valueOf(Short.MAX_VALUE));
        }
        if (numCheckConstraints > 0) {
            fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            FromBaseTable table = (FromBaseTable)this.getNodeFactory().getNode(135, this.getObjectName(), null, null, null, this.getContextManager());
            table.setTableNumber(0);
            fromList.addFromTable(table);
            table.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
            this.tableElementList.appendNewColumnsToRCL(table);
            this.tableElementList.bindAndValidateCheckConstraints(fromList);
        }
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.getSchemaDescriptor());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        TableElementList coldefs = this.tableElementList;
        ColumnInfo[] colInfos = new ColumnInfo[coldefs.countNumberOfColumns()];
        int numConstraints = coldefs.genColumnInfos(colInfos);
        ConstraintConstantAction[] conActions = null;
        SchemaDescriptor sd = this.getSchemaDescriptor();
        if (numConstraints > 0) {
            conActions = new CreateConstraintConstantAction[numConstraints];
            coldefs.genConstraintActions(conActions, this.getRelativeName(), sd, this.getDataDictionary());
        }
        boolean table_has_long_column = false;
        int approxLength = 0;
        for (int i = 0; i < colInfos.length; ++i) {
            DataTypeDescriptor dts = colInfos[i].dataType;
            if (dts.getTypeId().isLongConcatableTypeId()) {
                table_has_long_column = true;
                break;
            }
            approxLength += dts.getTypeId().getApproximateLengthInBytes(dts);
        }
        if (!(!table_has_long_column && approxLength <= 4096 || this.properties != null && this.properties.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null)) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateTableConstantAction(sd.getSchemaName(), this.getRelativeName(), this.tableType, colInfos, (CreateConstraintConstantAction[])conActions, this.properties, this.lockGranularity, this.onCommitDeleteRows, this.onRollbackDeleteRows);
    }
}

