/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;

public class CreateAliasNode
extends DDLStatementNode {
    private String javaClassName;
    private String methodName;
    private char aliasType;
    private boolean delimitedIdentifier;
    private AliasInfo aliasInfo;

    public void init(Object aliasName, Object targetObject, Object methodName, Object aliasSpecificInfo, Object aliasType, Object delimitedIdentifier) throws StandardException {
        TableName qn = (TableName)aliasName;
        this.aliasType = ((Character)aliasType).charValue();
        this.initAndCheck(qn);
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                Integer drso;
                this.javaClassName = (String)targetObject;
                this.methodName = (String)methodName;
                this.delimitedIdentifier = (Boolean)delimitedIdentifier;
                Object[] routineElements = (Object[])aliasSpecificInfo;
                Object[] parameters = (Object[])routineElements[0];
                int paramCount = ((Vector)parameters[0]).size();
                if (this.methodName.indexOf(40) != -1) {
                    this.getDataDictionary().checkVersion(130, "EXTERNAL NAME 'class.method(<signature>)'");
                }
                Object[] names = null;
                Object[] types = null;
                int[] modes = null;
                if (paramCount > 90) {
                    throw StandardException.newException("54023", (Object)String.valueOf(90), aliasName, (Object)String.valueOf(paramCount));
                }
                if (paramCount != 0) {
                    names = new String[paramCount];
                    ((Vector)parameters[0]).copyInto(names);
                    types = new TypeDescriptor[paramCount];
                    ((Vector)parameters[1]).copyInto(types);
                    modes = new int[paramCount];
                    for (int i = 0; i < paramCount; ++i) {
                        modes[i] = (Integer)((Vector)parameters[2]).elementAt(i);
                        if (!TypeId.getBuiltInTypeId(types[i].getJDBCTypeId()).isLongConcatableTypeId()) continue;
                        throw StandardException.newException("42962", names[i]);
                    }
                    if (paramCount > 1) {
                        Object[] dupNameCheck = new String[paramCount];
                        System.arraycopy(names, 0, dupNameCheck, 0, paramCount);
                        Arrays.sort(dupNameCheck);
                        for (int dnc = 1; dnc < dupNameCheck.length; ++dnc) {
                            if (((String)dupNameCheck[dnc]).equals("") || !((String)dupNameCheck[dnc]).equals(dupNameCheck[dnc - 1])) continue;
                            throw StandardException.newException("42734", dupNameCheck[dnc], (Object)this.getFullName());
                        }
                    }
                }
                int drs = (drso = (Integer)routineElements[2]) == null ? 0 : drso;
                Short sqlAllowedObject = (Short)routineElements[6];
                short sqlAllowed = sqlAllowedObject != null ? sqlAllowedObject : (this.aliasType == 'P' ? (short)0 : 1);
                Boolean calledOnNullInputO = (Boolean)routineElements[7];
                boolean calledOnNullInput = calledOnNullInputO == null ? true : calledOnNullInputO;
                this.aliasInfo = new RoutineAliasInfo(this.methodName, paramCount, (String[])names, (TypeDescriptor[])types, modes, drs, (Short)routineElements[5], sqlAllowed, calledOnNullInput, (TypeDescriptor)routineElements[8]);
                this.implicitCreateSchema = true;
                break;
            }
            case 'S': {
                this.implicitCreateSchema = true;
                TableName t = (TableName)targetObject;
                String targetSchema = t.getSchemaName() != null ? t.getSchemaName() : this.getSchemaDescriptor().getSchemaName();
                this.aliasInfo = new SynonymAliasInfo(targetSchema, t.getTableName());
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected value for aliasType (" + aliasType + ")");
            }
        }
    }

    public String statementToString() {
        switch (this.aliasType) {
            case 'P': {
                return "CREATE PROCEDURE";
            }
            case 'S': {
                return "CREATE SYNONYM";
            }
        }
        return "CREATE FUNCTION";
    }

    private boolean anyStringTypeDescriptor() {
        TypeId compTypeId;
        RoutineAliasInfo rai = (RoutineAliasInfo)this.aliasInfo;
        TypeDescriptor aType = rai.getReturnType();
        if (aType != null && (compTypeId = TypeId.getBuiltInTypeId(aType.getTypeName())) != null && compTypeId.isStringTypeId()) {
            return true;
        }
        if (rai.getParameterCount() != 0) {
            int paramCount = rai.getParameterCount();
            TypeDescriptor[] paramTypes = rai.getParameterTypes();
            for (int i = 0; i < paramCount; ++i) {
                compTypeId = TypeId.getBuiltInTypeId(paramTypes[i].getTypeName());
                if (compTypeId == null || !compTypeId.isStringTypeId()) continue;
                return true;
            }
        }
        return false;
    }

    private TypeDescriptor typeDescriptorWithCorrectCollation(TypeDescriptor changeTD) throws StandardException {
        if (changeTD == null) {
            return changeTD;
        }
        TypeId compTypeId = TypeId.getBuiltInTypeId(changeTD.getTypeName());
        if (compTypeId != null && compTypeId.isStringTypeId()) {
            DataTypeDescriptor newTDWithCorrectCollation = new DataTypeDescriptor(compTypeId, changeTD.isNullable(), changeTD.getMaximumWidth());
            newTDWithCorrectCollation.setCollationType(this.getSchemaDescriptor().getCollationType());
            newTDWithCorrectCollation.setCollationDerivation(1);
            return newTDWithCorrectCollation;
        }
        return changeTD;
    }

    public void bindStatement() throws StandardException {
        if ((this.aliasType == 'F' || this.aliasType == 'P') && this.anyStringTypeDescriptor()) {
            RoutineAliasInfo oldAliasInfo = (RoutineAliasInfo)this.aliasInfo;
            TypeDescriptor[] newParamTypes = null;
            int paramCount = oldAliasInfo.getParameterCount();
            if (paramCount > 0) {
                newParamTypes = new TypeDescriptor[paramCount];
                TypeDescriptor[] oldParamTypes = oldAliasInfo.getParameterTypes();
                for (int i = 0; i < paramCount; ++i) {
                    newParamTypes[i] = this.typeDescriptorWithCorrectCollation(oldParamTypes[i]);
                }
            }
            this.aliasInfo = new RoutineAliasInfo(oldAliasInfo.getMethodName(), oldAliasInfo.getParameterCount(), oldAliasInfo.getParameterNames(), newParamTypes, oldAliasInfo.getParameterModes(), oldAliasInfo.getMaxDynamicResultSets(), oldAliasInfo.getParameterStyle(), oldAliasInfo.getSQLAllowed(), oldAliasInfo.calledOnNullInput(), this.typeDescriptorWithCorrectCollation(oldAliasInfo.getReturnType()));
        }
        if (this.aliasType != 'S') {
            return;
        }
        if (this.isSessionSchema(this.getSchemaDescriptor().getSchemaName())) {
            throw StandardException.newException("XCL51.S");
        }
        String targetSchema = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
        String targetTable = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
        if (this.getObjectName().equals(targetSchema, targetTable)) {
            throw StandardException.newException("42916", (Object)this.getFullName(), (Object)(targetSchema + "." + targetTable));
        }
        SchemaDescriptor targetSD = this.getSchemaDescriptor(targetSchema, false);
        if (targetSD != null && this.isSessionSchema(targetSD)) {
            throw StandardException.newException("XCL51.S");
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        String schemaName;
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                schemaName = this.getSchemaDescriptor().getSchemaName();
                break;
            }
            case 'S': {
                schemaName = this.getSchemaDescriptor().getSchemaName();
                break;
            }
            default: {
                schemaName = null;
            }
        }
        return this.getGenericConstantActionFactory().getCreateAliasConstantAction(this.getRelativeName(), schemaName, this.javaClassName, this.aliasInfo, this.aliasType);
    }
}

