/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.ReuseFactory;

public class CompilerContextImpl
extends ContextImpl
implements CompilerContext {
    private final Parser parser;
    private final LanguageConnectionContext lcc;
    private final LanguageConnectionFactory lcf;
    private TypeCompilerFactory typeCompilerFactory;
    private Dependent currentDependent;
    private DependencyManager dm;
    private boolean firstOnStack;
    private boolean inUse;
    private int reliability = 1024;
    private int nextColumnNumber = 1;
    private int nextTableNumber;
    private int nextSubqueryNumber;
    private int nextResultSetNumber;
    private int entryIsolationLevel;
    private int scanIsolationLevel;
    private int nextEquivalenceClass = -1;
    private long nextClassName;
    private Vector savedObjects;
    private String classPrefix;
    private SchemaDescriptor compilationSchema;
    private ProviderList currentAPL;
    private boolean returnParameterFlag;
    private Vector storeCostControllers = new Vector();
    private Vector storeCostConglomIds = new Vector();
    private SortCostController sortCostController;
    private Vector parameterList;
    private DataTypeDescriptor[] parameterDescriptors;
    private Object cursorInfo;
    private SQLWarning warnings;
    private Stack privTypeStack = new Stack();
    private int currPrivType = -1;
    private HashMap requiredColumnPrivileges;
    private HashMap requiredTablePrivileges;
    private HashMap requiredSchemaPrivileges;
    private HashMap requiredRoutinePrivileges;

    public void cleanupOnError(Throwable error) throws StandardException {
        this.setInUse(false);
        this.resetContext();
        if (error instanceof StandardException) {
            StandardException se = (StandardException)error;
            int severity = se.getSeverity();
            if (severity < 50000) {
                if (this.currentDependent != null) {
                    this.currentDependent.makeInvalid(0, this.lcc);
                }
                this.closeStoreCostControllers();
                this.closeSortCostControllers();
            }
            if (severity >= 40000) {
                this.popMe();
            }
        }
    }

    public void resetContext() {
        this.nextColumnNumber = 1;
        this.nextTableNumber = 0;
        this.nextSubqueryNumber = 0;
        this.resetNextResultSetNumber();
        this.nextEquivalenceClass = -1;
        this.compilationSchema = null;
        this.parameterList = null;
        this.parameterDescriptors = null;
        this.scanIsolationLevel = 0;
        this.warnings = null;
        this.savedObjects = null;
        this.reliability = 1024;
        this.returnParameterFlag = false;
        this.initRequiredPriv();
    }

    public Parser getParser() {
        return this.parser;
    }

    public NodeFactory getNodeFactory() {
        return this.lcf.getNodeFactory();
    }

    public int getNextColumnNumber() {
        return this.nextColumnNumber++;
    }

    public int getNextTableNumber() {
        return this.nextTableNumber++;
    }

    public int getNumTables() {
        return this.nextTableNumber;
    }

    public int getNextSubqueryNumber() {
        return this.nextSubqueryNumber++;
    }

    public int getNumSubquerys() {
        return this.nextSubqueryNumber;
    }

    public int getNextResultSetNumber() {
        return this.nextResultSetNumber++;
    }

    public void resetNextResultSetNumber() {
        this.nextResultSetNumber = 0;
    }

    public int getNumResultSets() {
        return this.nextResultSetNumber;
    }

    public String getUniqueClassName() {
        SanityManager.ASSERT(this.nextClassName <= Long.MAX_VALUE);
        return this.classPrefix.concat(Long.toHexString(this.nextClassName++));
    }

    public int getNextEquivalenceClass() {
        return ++this.nextEquivalenceClass;
    }

    public ClassFactory getClassFactory() {
        return this.lcf.getClassFactory();
    }

    public JavaFactory getJavaFactory() {
        return this.lcf.getJavaFactory();
    }

    public void setCurrentDependent(Dependent d) {
        this.currentDependent = d;
    }

    public ProviderList getCurrentAuxiliaryProviderList() {
        return this.currentAPL;
    }

    public void setCurrentAuxiliaryProviderList(ProviderList apl) {
        this.currentAPL = apl;
    }

    public void createDependency(Provider p) throws StandardException {
        SanityManager.ASSERT(this.currentDependent != null, "no current dependent for compilation");
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(this.currentDependent, p, this.getContextManager());
        this.addProviderToAuxiliaryList(p);
    }

    public void createDependency(Dependent d, Provider p) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(d, p, this.getContextManager());
        this.addProviderToAuxiliaryList(p);
    }

    private void addProviderToAuxiliaryList(Provider p) {
        if (this.currentAPL != null) {
            this.currentAPL.addProvider(p);
        }
    }

    public int addSavedObject(Object obj) {
        if (this.savedObjects == null) {
            this.savedObjects = new Vector();
        }
        this.savedObjects.addElement(obj);
        return this.savedObjects.size() - 1;
    }

    public Object[] getSavedObjects() {
        if (this.savedObjects == null) {
            return null;
        }
        Object[] retVal = new Object[this.savedObjects.size()];
        this.savedObjects.copyInto(retVal);
        this.savedObjects = null;
        return retVal;
    }

    public void setSavedObjects(Object[] objs) {
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            this.addSavedObject(objs[i]);
        }
    }

    public void setCursorInfo(Object cursorInfo) {
        this.cursorInfo = cursorInfo;
    }

    public Object getCursorInfo() {
        return this.cursorInfo;
    }

    public void firstOnStack() {
        this.firstOnStack = true;
    }

    public boolean isFirstOnStack() {
        return this.firstOnStack;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
        if (!inUse) {
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    public boolean getInUse() {
        return this.inUse;
    }

    public void setReliability(int reliability) {
        this.reliability = reliability;
    }

    public int getReliability() {
        return this.reliability;
    }

    public StoreCostController getStoreCostController(long conglomerateNumber) throws StandardException {
        for (int i = 0; i < this.storeCostConglomIds.size(); ++i) {
            Long conglomId = (Long)this.storeCostConglomIds.elementAt(i);
            if (conglomId != conglomerateNumber) continue;
            return (StoreCostController)this.storeCostControllers.elementAt(i);
        }
        StoreCostController retval = this.lcc.getTransactionCompile().openStoreCost(conglomerateNumber);
        this.storeCostControllers.insertElementAt(retval, this.storeCostControllers.size());
        this.storeCostConglomIds.insertElementAt(new Long(conglomerateNumber), this.storeCostConglomIds.size());
        return retval;
    }

    private void closeStoreCostControllers() {
        for (int i = 0; i < this.storeCostControllers.size(); ++i) {
            StoreCostController scc = (StoreCostController)this.storeCostControllers.elementAt(i);
            try {
                scc.close();
                continue;
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.storeCostControllers.removeAllElements();
        this.storeCostConglomIds.removeAllElements();
    }

    public SortCostController getSortCostController() throws StandardException {
        if (this.sortCostController == null) {
            this.sortCostController = this.lcc.getTransactionCompile().openSortCostController(null);
        }
        return this.sortCostController;
    }

    private void closeSortCostControllers() {
        if (this.sortCostController != null) {
            this.sortCostController.close();
            this.sortCostController = null;
        }
    }

    public SchemaDescriptor getCompilationSchema() {
        return this.compilationSchema;
    }

    public SchemaDescriptor setCompilationSchema(SchemaDescriptor newDefault) {
        SchemaDescriptor tmpSchema = this.compilationSchema;
        this.compilationSchema = newDefault;
        return tmpSchema;
    }

    public void setParameterList(Vector parameterList) {
        int numberOfParameters;
        this.parameterList = parameterList;
        int n = numberOfParameters = parameterList == null ? 0 : parameterList.size();
        if (numberOfParameters > 0) {
            this.parameterDescriptors = new DataTypeDescriptor[numberOfParameters];
        }
    }

    public Vector getParameterList() {
        return this.parameterList;
    }

    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    public boolean getReturnParameterFlag() {
        return this.returnParameterFlag;
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.parameterDescriptors;
    }

    public void setScanIsolationLevel(int isolationLevel) {
        this.scanIsolationLevel = isolationLevel;
    }

    public int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    public void setEntryIsolationLevel(int isolationLevel) {
        this.entryIsolationLevel = isolationLevel;
    }

    public int getEntryIsolationLevel() {
        return this.entryIsolationLevel;
    }

    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.typeCompilerFactory;
    }

    public void addWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            this.warnings.setNextWarning(warning);
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public CompilerContextImpl(ContextManager cm, LanguageConnectionContext lcc, TypeCompilerFactory typeCompilerFactory) {
        super(cm, "CompilerContext");
        this.lcc = lcc;
        this.lcf = lcc.getLanguageConnectionFactory();
        this.parser = this.lcf.newParser(this);
        this.typeCompilerFactory = typeCompilerFactory;
        this.classPrefix = "ac" + this.lcf.getUUIDFactory().createUUID().toString().replace('-', 'x');
        this.initRequiredPriv();
    }

    private void initRequiredPriv() {
        this.currPrivType = -1;
        this.privTypeStack.clear();
        this.requiredColumnPrivileges = null;
        this.requiredTablePrivileges = null;
        this.requiredSchemaPrivileges = null;
        this.requiredRoutinePrivileges = null;
        LanguageConnectionContext lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        if (lcc.usesSqlAuthorization()) {
            this.requiredColumnPrivileges = new HashMap();
            this.requiredTablePrivileges = new HashMap();
            this.requiredSchemaPrivileges = new HashMap();
            this.requiredRoutinePrivileges = new HashMap();
        }
    }

    public void pushCurrentPrivType(int privType) {
        this.privTypeStack.push(ReuseFactory.getInteger(this.currPrivType));
        this.currPrivType = privType;
    }

    public void popCurrentPrivType() {
        this.currPrivType = (Integer)this.privTypeStack.pop();
    }

    public void addRequiredColumnPriv(ColumnDescriptor column) {
        if (this.requiredColumnPrivileges == null || this.currPrivType == -1 || this.currPrivType == 4 || this.currPrivType == 3 || this.currPrivType == 5 || this.currPrivType == 6 || column == null) {
            return;
        }
        TableDescriptor td = column.getTableDescriptor();
        if (td == null) {
            return;
        }
        UUID tableUUID = td.getUUID();
        StatementTablePermission key = new StatementTablePermission(tableUUID, this.currPrivType);
        StatementColumnPermission tableColumnPrivileges = (StatementColumnPermission)this.requiredColumnPrivileges.get(key);
        if (tableColumnPrivileges == null) {
            tableColumnPrivileges = new StatementColumnPermission(tableUUID, this.currPrivType, new FormatableBitSet(td.getNumberOfColumns()));
            this.requiredColumnPrivileges.put(key, tableColumnPrivileges);
        }
        tableColumnPrivileges.getColumns().set(column.getPosition() - 1);
    }

    public void addRequiredTablePriv(TableDescriptor table) {
        if (this.requiredTablePrivileges == null || table == null) {
            return;
        }
        StatementTablePermission key = new StatementTablePermission(table.getUUID(), this.currPrivType);
        this.requiredTablePrivileges.put(key, key);
    }

    public void addRequiredRoutinePriv(AliasDescriptor routine) {
        if (this.requiredRoutinePrivileges == null || routine == null) {
            return;
        }
        if (routine.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30")) {
            return;
        }
        if (this.requiredRoutinePrivileges.get(routine.getUUID()) == null) {
            this.requiredRoutinePrivileges.put(routine.getUUID(), ReuseFactory.getInteger(1));
        }
    }

    public void addRequiredSchemaPriv(String schemaName, String aid, int privType) {
        if (this.requiredSchemaPrivileges == null || schemaName == null) {
            return;
        }
        StatementSchemaPermission key = new StatementSchemaPermission(schemaName, aid, privType);
        this.requiredSchemaPrivileges.put(key, key);
    }

    public List getRequiredPermissionsList() {
        Iterator<Object> itr;
        int size = 0;
        if (this.requiredRoutinePrivileges != null) {
            size += this.requiredRoutinePrivileges.size();
        }
        if (this.requiredTablePrivileges != null) {
            size += this.requiredTablePrivileges.size();
        }
        if (this.requiredSchemaPrivileges != null) {
            size += this.requiredSchemaPrivileges.size();
        }
        if (this.requiredColumnPrivileges != null) {
            size += this.requiredColumnPrivileges.size();
        }
        ArrayList<Object> list = new ArrayList<Object>(size);
        if (this.requiredRoutinePrivileges != null) {
            itr = this.requiredRoutinePrivileges.keySet().iterator();
            while (itr.hasNext()) {
                UUID routineUUID = (UUID)itr.next();
                list.add(new StatementRoutinePermission(routineUUID));
            }
        }
        if (this.requiredTablePrivileges != null) {
            itr = this.requiredTablePrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        if (this.requiredSchemaPrivileges != null) {
            itr = this.requiredSchemaPrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        if (this.requiredColumnPrivileges != null) {
            itr = this.requiredColumnPrivileges.values().iterator();
            while (itr.hasNext()) {
                list.add(itr.next());
            }
        }
        return list;
    }
}

