/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public final class CharTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (this.getTypeId().isLongVarcharTypeId()) {
            return otherType.isStringTypeId();
        }
        if (forDataTypeFunction && otherType.isDoubleTypeId()) {
            return this.getTypeId().isStringTypeId();
        }
        return !otherType.isFloatingPointTypeId() && !otherType.isBitTypeId() && !otherType.isBlobTypeId() && !otherType.isXMLTypeId();
    }

    public boolean compatible(TypeId otherType) {
        return otherType.isStringTypeId() || otherType.isDateTimeTimeStampTypeId() && !this.getTypeId().isLongVarcharTypeId();
    }

    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (this.convertible(otherType, false) && !otherType.isBlobTypeId() && !otherType.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), otherType, cf);
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "java.lang.String";
    }

    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    public String getMatchingNationalCharTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 5: 
            case 370: {
                return "NATIONAL CHAR";
            }
            case 230: 
            case 362: {
                return "LONG NVARCHAR";
            }
            case 13: 
            case 369: {
                return "NATIONAL CHAR VARYING";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in getMatchingNationalCharTypeName() - " + formatId);
        return null;
    }

    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 5: {
                return "getNullChar";
            }
            case 230: {
                return "getNullLongvarchar";
            }
            case 370: {
                return "getNullNationalChar";
            }
            case 362: {
                return "getNullNationalLongvarchar";
            }
            case 369: {
                return "getNullNationalVarchar";
            }
            case 13: {
                return "getNullVarchar";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in nullMethodName() - " + formatId);
        return null;
    }

    boolean pushCollationForDataValue(int collationType) {
        return collationType != 0;
    }

    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 5: {
                return "getCharDataValue";
            }
            case 230: {
                return "getLongvarcharDataValue";
            }
            case 370: {
                return "getNationalCharDataValue";
            }
            case 362: {
                return "getNationalLongvarcharDataValue";
            }
            case 369: {
                return "getNationalVarcharDataValue";
            }
            case 13: {
                return "getVarcharDataValue";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in dataValueMethodName() - " + formatId);
        return null;
    }
}

