/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CastNode
extends ValueNode {
    ValueNode castOperand;
    private int targetCharType;
    TypeId sourceCTI = null;
    private boolean forDataTypeFunction = false;
    private boolean externallyGeneratedCastNode = false;

    public void init(Object castOperand, Object castTarget) throws StandardException {
        this.castOperand = (ValueNode)castOperand;
        this.setType((DataTypeDescriptor)castTarget);
    }

    public void init(Object castOperand, Object charType, Object charLength) throws StandardException {
        this.castOperand = (ValueNode)castOperand;
        int charLen = (Integer)charLength;
        this.targetCharType = (Integer)charType;
        if (charLen < 0) {
            return;
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, charLen));
    }

    public String toString() {
        try {
            return "castTarget: " + this.getTypeServices() + "\n" + super.toString();
        }
        catch (StandardException e) {
            return "";
        }
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.castOperand != null) {
            this.printLabel(depth, "castOperand: ");
            this.castOperand.treePrint(depth + 1);
        }
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.castOperand.getOrderableVariantType();
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.castOperand = this.castOperand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.getTypeServices() == null) {
            DataTypeDescriptor opndType = this.castOperand.getTypeServices();
            int length = -1;
            TypeId srcTypeId = opndType.getTypeId();
            if (opndType != null) {
                if (srcTypeId.isNumericTypeId()) {
                    length = opndType.getPrecision() + 1;
                    if (opndType.getScale() > 0) {
                        ++length;
                    }
                } else if (srcTypeId.isStringTypeId()) {
                    length = opndType.getMaximumWidth();
                    if (this.targetCharType == 1) {
                        length = Math.min(length, 254);
                    } else if (this.targetCharType == 12) {
                        length = Math.min(length, 32672);
                    }
                } else {
                    TypeId typeid = opndType.getTypeId();
                    if (length < 0) {
                        length = DataTypeUtilities.getColumnDisplaySize(typeid.getJDBCTypeId(), -1);
                    }
                }
            }
            if (length < 0) {
                length = 1;
            }
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, length));
        }
        if (this.castOperand instanceof UntypedNullConstantNode) {
            this.castOperand.setType(this.getTypeServices());
        }
        this.bindCastNodeOnly();
        if (this.castOperand instanceof ConstantNode && !(this.castOperand instanceof UntypedNullConstantNode)) {
            ValueNode retNode = this;
            int sourceJDBCTypeId = this.sourceCTI.getJDBCTypeId();
            int destJDBCTypeId = this.getTypeId().getJDBCTypeId();
            switch (sourceJDBCTypeId) {
                case -7: 
                case 16: {
                    if (destJDBCTypeId == -7 || destJDBCTypeId == 16) {
                        retNode = this.castOperand;
                        break;
                    }
                    if (destJDBCTypeId != 1) break;
                    BooleanConstantNode bcn = (BooleanConstantNode)this.castOperand;
                    String booleanString = bcn.getValueAsString();
                    retNode = (ValueNode)this.getNodeFactory().getNode(61, booleanString, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 1: {
                    retNode = this.getCastFromCharConstant(destJDBCTypeId);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (destJDBCTypeId != 1) break;
                    String castValue = ((UserTypeConstantNode)this.castOperand).getObjectValue().toString();
                    retNode = (ValueNode)this.getNodeFactory().getNode(61, castValue, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 3: {
                    if (destJDBCTypeId == 3 || destJDBCTypeId == 2) break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    retNode = this.getCastFromNumericType(((ConstantNode)this.castOperand).getValue(), destJDBCTypeId);
                }
            }
            return retNode;
        }
        return this;
    }

    public void bindCastNodeOnly() throws StandardException {
        TypeCompiler tc;
        this.sourceCTI = this.castOperand.getTypeId();
        if (this.externallyGeneratedCastNode && this.getTypeId().isStringTypeId()) {
            this.setCollationUsingCompilationSchema(1);
        }
        if (this.getTypeId().userType()) {
            String className = this.getTypeId().getCorrespondingJavaTypeName();
            this.verifyClassExist(className);
            this.setType(new DataTypeDescriptor(TypeId.getUserDefinedTypeId(className, false), true));
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.castOperand.setType(this.getTypeServices());
        } else if (!(this.castOperand instanceof UntypedNullConstantNode) && !(tc = this.castOperand.getTypeCompiler()).convertible(this.getTypeId(), this.forDataTypeFunction)) {
            throw StandardException.newException("42846", (Object)this.sourceCTI.getSQLTypeName(), (Object)this.getTypeId().getSQLTypeName());
        }
    }

    private ValueNode getCastFromCharConstant(int destJDBCTypeId) throws StandardException {
        String charValue = ((CharConstantNode)this.castOperand).getString();
        String cleanCharValue = StringUtil.SQLToUpperCase(charValue.trim());
        CastNode retNode = this;
        switch (destJDBCTypeId) {
            case -7: 
            case 16: {
                if (cleanCharValue.equals("TRUE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                }
                if (cleanCharValue.equals("FALSE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
                }
                throw StandardException.newException("22018", "boolean");
            }
            case 91: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getDateValue(cleanCharValue, false), this.getContextManager());
            }
            case 93: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimestampValue(cleanCharValue, false), this.getContextManager());
            }
            case 92: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimeValue(cleanCharValue, false), this.getContextManager());
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    return this.getCastFromIntegralType(new Double(cleanCharValue).longValue(), destJDBCTypeId);
                }
                catch (NumberFormatException nfe) {
                    String sqlName = TypeId.getBuiltInTypeId(destJDBCTypeId).getSQLTypeName();
                    throw StandardException.newException("22018", sqlName);
                }
            }
            case 7: {
                Float floatValue;
                try {
                    floatValue = Float.valueOf(cleanCharValue);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "float");
                }
                return (ValueNode)this.getNodeFactory().getNode(69, floatValue, this.getContextManager());
            }
            case 8: {
                Double doubleValue;
                try {
                    doubleValue = new Double(cleanCharValue);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "double");
                }
                return (ValueNode)this.getNodeFactory().getNode(68, doubleValue, this.getContextManager());
            }
        }
        return retNode;
    }

    private ValueNode getCastFromIntegralType(long longValue, int destJDBCTypeId) throws StandardException {
        CastNode retNode = this;
        switch (destJDBCTypeId) {
            case 1: {
                return (ValueNode)this.getNodeFactory().getNode(61, Long.toString(longValue), ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                if (longValue < -128L || longValue > 127L) {
                    throw StandardException.newException("22003", "TINYINT");
                }
                return (ValueNode)this.getNodeFactory().getNode(75, ReuseFactory.getByte((byte)longValue), this.getContextManager());
            }
            case 5: {
                if (longValue < -32768L || longValue > 32767L) {
                    throw StandardException.newException("22003", "SHORT");
                }
                return (ValueNode)this.getNodeFactory().getNode(74, ReuseFactory.getShort((short)longValue), this.getContextManager());
            }
            case 4: {
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    throw StandardException.newException("22003", "INTEGER");
                }
                return (ValueNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger((int)longValue), this.getContextManager());
            }
            case -5: {
                return (ValueNode)this.getNodeFactory().getNode(71, ReuseFactory.getLong(longValue), this.getContextManager());
            }
            case 7: {
                if ((float)Math.abs(longValue) > Float.MAX_VALUE) {
                    throw StandardException.newException("22003", "REAL");
                }
                return (ValueNode)this.getNodeFactory().getNode(69, new Float(longValue), this.getContextManager());
            }
            case 8: {
                return (ValueNode)this.getNodeFactory().getNode(68, new Double(longValue), this.getContextManager());
            }
        }
        return retNode;
    }

    private ValueNode getCastFromNumericType(DataValueDescriptor constantValue, int destJDBCTypeId) throws StandardException {
        int nodeType = -1;
        Object constantObject = null;
        switch (destJDBCTypeId) {
            case 1: {
                nodeType = 61;
                constantObject = constantValue.getString();
                return (ValueNode)this.getNodeFactory().getNode(nodeType, constantObject, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                nodeType = 75;
                constantObject = new Byte(constantValue.getByte());
                break;
            }
            case 5: {
                nodeType = 74;
                constantObject = ReuseFactory.getShort(constantValue.getShort());
                break;
            }
            case 4: {
                nodeType = 70;
                constantObject = ReuseFactory.getInteger(constantValue.getInt());
                break;
            }
            case -5: {
                nodeType = 71;
                constantObject = ReuseFactory.getLong(constantValue.getLong());
                break;
            }
            case 7: {
                nodeType = 69;
                constantObject = new Float(NumberDataType.normalizeREAL(constantValue.getDouble()));
                break;
            }
            case 8: {
                nodeType = 68;
                constantObject = new Double(constantValue.getDouble());
            }
        }
        if (nodeType == -1) {
            return this;
        }
        return (ValueNode)this.getNodeFactory().getNode(nodeType, constantObject, this.getContextManager());
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.castOperand = this.castOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.castOperand.categorize(referencedTabs, simplePredsOnly);
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.castOperand = this.castOperand.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.castOperand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList whereClause) {
        return this.castOperand.constantExpression(whereClause);
    }

    Object getConstantValueAsObject() throws StandardException {
        Object sourceObject = this.castOperand.getConstantValueAsObject();
        if (sourceObject == null) {
            return null;
        }
        if (this.sourceCTI.getCorrespondingJavaTypeName().equals(this.getTypeId().getCorrespondingJavaTypeName())) {
            return sourceObject;
        }
        return null;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.castOperand.generateExpression(acb, mb);
        if (this.castOperand instanceof UntypedNullConstantNode) {
            return;
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.sourceCTI = this.getTypeId();
        }
        this.genDataValueConversion(acb, mb);
    }

    private void genDataValueConversion(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        MethodBuilder acbConstructor = acb.getConstructor();
        String resultTypeName = this.getTypeCompiler().interfaceName();
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        acb.generateNull(acbConstructor, this.getTypeCompiler(this.getTypeId()), this.getTypeServices().getCollationType());
        acbConstructor.setField(field);
        if (!this.sourceCTI.userType() && !this.getTypeId().userType()) {
            mb.getField(field);
            mb.swap();
            mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setValue", "void", 1);
        } else {
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            mb.getField(field);
            mb.swap();
            String destinationType = this.getTypeId().getCorrespondingJavaTypeName();
            mb.dup();
            mb.isInstanceOf(destinationType);
            mb.push(destinationType);
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setObjectForCast", "void", 3);
        }
        mb.getField(field);
        if (this.getTypeId().variableLength()) {
            boolean isNumber = this.getTypeId().isNumericTypeId();
            mb.dup();
            mb.push(isNumber ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            mb.push(this.getTypeServices().getScale());
            mb.push(!this.sourceCTI.variableLength() || isNumber);
            mb.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.castOperand != null && !v.stopTraversal()) {
            this.castOperand = (ValueNode)this.castOperand.accept(v);
        }
        return returnNode;
    }

    void setForExternallyGeneratedCASTnode() {
        this.externallyGeneratedCastNode = true;
    }

    void setForDataTypeFunction(boolean b) {
        this.forDataTypeFunction = b;
    }

    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            CastNode other = (CastNode)o;
            return this.getTypeServices().equals(other.getTypeServices()) && this.castOperand.isEquivalent(other.castOperand);
        }
        return false;
    }
}

