/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;

public class CallStatementNode
extends DMLStatementNode {
    private JavaToSQLValueNode methodCall;

    public void init(Object methodCall) {
        super.init(null);
        this.methodCall = (JavaToSQLValueNode)methodCall;
        this.methodCall.getJavaValueNode().markForCallStatement();
    }

    public String toString() {
        return "CALL " + this.methodCall.toString() + "\n" + super.toString();
    }

    public String statementToString() {
        return "CALL";
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodCall != null) {
            this.printLabel(depth, "methodCall: ");
            this.methodCall.treePrint(depth + 1);
        }
    }

    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        SanityManager.ASSERT(dd != null, "Failed to get data dictionary");
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.methodCall = (JavaToSQLValueNode)this.methodCall.bindExpression((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
        this.checkReliability();
        this.getCompilerContext().popCurrentPrivType();
    }

    public void optimizeStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        SanityManager.ASSERT(dd != null, "Failed to get data dictionary");
        this.methodCall = (JavaToSQLValueNode)this.methodCall.preprocess(this.getCompilerContext().getNumTables(), (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateParameterValueSet(acb);
        JavaValueNode methodCallBody = this.methodCall.getJavaValueNode();
        methodCallBody.markReturnValueDiscarded();
        MethodBuilder userExprFun = acb.newGeneratedFun("void", 1);
        userExprFun.addThrownException("java.lang.Exception");
        methodCallBody.generate(acb, userExprFun);
        userExprFun.endStatement();
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushMethodReference(mb, userExprFun);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getCallStatementResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
    }

    public ResultDescription makeResultDescription() {
        return null;
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (!v.stopTraversal()) {
            this.methodCall = (JavaToSQLValueNode)this.methodCall.accept(v);
        }
        return returnNode;
    }

    int getPrivType() {
        return 6;
    }

    private void checkReliability() throws StandardException {
        if (this.getSQLAllowedInProcedure() == 0 && this.getCompilerContext().getReliability() == 2048) {
            throw StandardException.newException("42Z9D.S.1");
        }
    }

    private short getSQLAllowedInProcedure() {
        RoutineAliasInfo routineInfo = ((MethodCallNode)this.methodCall.getJavaValueNode()).routineInfo;
        SanityManager.ASSERT(routineInfo != null, "Failed to get routineInfo");
        return routineInfo.getSQLAllowed();
    }
}

