/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class CLOBTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isStringTypeId();
    }

    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    public boolean storable(TypeId otherType, ClassFactory cf) {
        return otherType.isStringTypeId();
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 444: {
                return "java.sql.Clob";
            }
            case 448: {
                return "java.sql.Clob";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId);
        return null;
    }

    public String getMatchingNationalCharTypeName() {
        return "NCLOB";
    }

    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 444: {
                return "getNullClob";
            }
            case 448: {
                return "getNullNClob";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in nullMethodName() - " + formatId);
        return null;
    }

    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 444: {
                return "getClobDataValue";
            }
            case 448: {
                return "getNClobDataValue";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in dataValueMethodName() - " + formatId);
        return null;
    }

    boolean pushCollationForDataValue(int collationType) {
        return collationType != 0;
    }
}

