/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public class BitConstantNode
extends ConstantNode {
    private int bitLength;

    public void init(Object arg1) throws StandardException {
        super.init(arg1, Boolean.TRUE, ReuseFactory.getInteger(0));
    }

    public void init(Object arg1, Object arg2) throws StandardException {
        String a1 = (String)arg1;
        byte[] nv = StringUtil.fromHexString(a1, 0, a1.length());
        Integer bitLengthO = (Integer)arg2;
        this.bitLength = bitLengthO;
        this.init(TypeId.getBuiltInTypeId(-2), Boolean.FALSE, bitLengthO);
        BitDataValue dvd = this.getDataValueFactory().getBitDataValue(nv);
        dvd.setWidth(this.bitLength, 0, false);
        this.setValue(dvd);
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getBytes();
    }

    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        byte[] bytes = this.value.getBytes();
        String hexLiteral = StringUtil.toHexString(bytes, 0, bytes.length);
        mb.push(hexLiteral);
        mb.push(0);
        mb.push(hexLiteral.length());
        mb.callMethod((short)184, "org.apache.derby.iapi.util.StringUtil", "fromHexString", "byte[]", 3);
    }
}

