/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class BinaryRelationalOperatorNode
extends BinaryComparisonOperatorNode
implements RelationalOperator {
    private int operatorType;
    private BaseTableNumbersVisitor btnVis;
    JBitSet optBaseTables;
    JBitSet valNodeBaseTables;
    InListOperatorNode inListProbeSource = null;
    protected static final int LEFT = -1;
    protected static final int NEITHER = 0;
    protected static final int RIGHT = 1;

    public void init(Object leftOperand, Object rightOperand) {
        String methodName = "";
        String operatorName = "";
        switch (this.getNodeType()) {
            case 41: {
                methodName = "equals";
                operatorName = "=";
                this.operatorType = 1;
                break;
            }
            case 42: {
                methodName = "greaterOrEquals";
                operatorName = ">=";
                this.operatorType = 4;
                break;
            }
            case 43: {
                methodName = "greaterThan";
                operatorName = ">";
                this.operatorType = 3;
                break;
            }
            case 44: {
                methodName = "lessOrEquals";
                operatorName = "<=";
                this.operatorType = 6;
                break;
            }
            case 45: {
                methodName = "lessThan";
                operatorName = "<";
                this.operatorType = 5;
                break;
            }
            case 47: {
                methodName = "notEquals";
                operatorName = "<>";
                this.operatorType = 2;
                break;
            }
            default: {
                SanityManager.THROWASSERT("init for BinaryRelationalOperator called with wrong nodeType = " + this.getNodeType());
            }
        }
        super.init(leftOperand, rightOperand, operatorName, methodName);
        this.btnVis = null;
    }

    public void init(Object leftOperand, Object rightOperand, Object inListOp) {
        this.init(leftOperand, rightOperand);
        this.inListProbeSource = (InListOperatorNode)inListOp;
    }

    protected InListOperatorNode getInListOp() {
        return this.inListProbeSource;
    }

    public ColumnReference getColumnOperand(Optimizable optTable, int columnPosition) {
        ColumnReference cr;
        FromTable ft = (FromTable)optTable;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
                return cr;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
            return cr;
        }
        return null;
    }

    public ColumnReference getColumnOperand(Optimizable optTable) {
        ColumnReference cr;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, (FromTable)optTable, false, walkSubtree)) {
                return cr;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, (FromTable)optTable, false, walkSubtree)) {
            return cr;
        }
        return null;
    }

    public ValueNode getExpressionOperand(int tableNumber, int columnPosition, FromTable ft) {
        ColumnReference cr;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
                return this.rightOperand;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, ft, false, walkSubtree) && cr.getSource().getColumnPosition() == columnPosition) {
            return this.leftOperand;
        }
        return null;
    }

    public ValueNode getOperand(ColumnReference cRef, int refSetSize, boolean otherSide) {
        this.initBaseTableVisitor(refSetSize, true);
        try {
            ColumnReference cr;
            this.btnVis.setTableMap(this.optBaseTables);
            cRef.accept(this.btnVis);
            this.btnVis.setTableMap(this.valNodeBaseTables);
            if (this.leftOperand instanceof ColumnReference) {
                cr = (ColumnReference)this.leftOperand;
                cr.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && cr.getSource().getColumnPosition() == cRef.getColumnNumber()) {
                    if (otherSide) {
                        return this.rightOperand;
                    }
                    return this.leftOperand;
                }
            }
            if (this.rightOperand instanceof ColumnReference) {
                this.valNodeBaseTables.clearAll();
                cr = (ColumnReference)this.rightOperand;
                cr.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && cr.getSource().getColumnPosition() == cRef.getColumnNumber()) {
                    if (otherSide) {
                        return this.leftOperand;
                    }
                    return this.rightOperand;
                }
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Failed when trying to find base table number for column reference check:", se);
        }
        return null;
    }

    public void generateExpressionOperand(Optimizable optTable, int columnPosition, ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(optTable instanceof FromBaseTable);
        FromBaseTable ft = (FromBaseTable)optTable;
        ValueNode exprOp = this.getExpressionOperand(ft.getTableNumber(), columnPosition, ft);
        if (exprOp == null) {
            SanityManager.THROWASSERT("ColumnReference for correct column (columnPosition = " + columnPosition + ", exposed table name = " + ft.getExposedName() + ") not found on either side of BinaryRelationalOperator");
        }
        exprOp.generateExpression(acb, mb);
    }

    public boolean selfComparison(ColumnReference cr) throws StandardException {
        ValueNode otherSide;
        if (this.leftOperand == cr) {
            otherSide = this.rightOperand;
        } else if (this.rightOperand == cr) {
            otherSide = this.leftOperand;
        } else {
            otherSide = null;
            SanityManager.THROWASSERT("ColumnReference not found on either side of binary comparison.");
        }
        JBitSet tablesReferenced = otherSide.getTablesReferenced();
        return tablesReferenced.get(cr.getTableNumber());
    }

    public boolean usefulStartKey(Optimizable optTable) {
        int columnSide = this.columnOnOneSide(optTable);
        if (columnSide == 0) {
            return false;
        }
        return this.usefulStartKey(columnSide == -1);
    }

    protected boolean keyColumnOnLeft(Optimizable optTable) {
        ColumnReference cr;
        boolean left = false;
        if (this.leftOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.leftOperand, (FromTable)optTable, false, true)) {
            left = true;
        }
        if (!left) {
            SanityManager.ASSERT(this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable((ColumnReference)this.rightOperand, (FromTable)optTable, false, true), "Key column not found on either side.");
        }
        return left;
    }

    protected int columnOnOneSide(Optimizable optTable) {
        ColumnReference cr;
        boolean left = false;
        boolean walkSubtree = true;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, (FromTable)optTable, false, walkSubtree)) {
                return -1;
            }
            walkSubtree = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, (FromTable)optTable, false, walkSubtree)) {
            return 1;
        }
        return 0;
    }

    public boolean usefulStopKey(Optimizable optTable) {
        int columnSide = this.columnOnOneSide(optTable);
        if (columnSide == 0) {
            return false;
        }
        return this.usefulStopKey(columnSide == -1);
    }

    public void generateAbsoluteColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        mb.push(columnPosition);
    }

    public void generateRelativeColumnId(MethodBuilder mb, Optimizable optTable) {
        int columnPosition = this.getAbsoluteColumnPosition(optTable);
        columnPosition = optTable.convertAbsoluteToRelativeColumnPosition(columnPosition);
        mb.push(columnPosition);
    }

    private int getAbsoluteColumnPosition(Optimizable optTable) {
        ColumnReference cr = this.keyColumnOnLeft(optTable) ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        ConglomerateDescriptor bestCD = optTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        int columnPosition = cr.getSource().getColumnPosition();
        if (bestCD != null && bestCD.isIndex()) {
            columnPosition = bestCD.getIndexDescriptor().getKeyColumnPosition(columnPosition);
            SanityManager.ASSERT(columnPosition > 0, "Base column not found in index");
        }
        return columnPosition - 1;
    }

    public void generateQualMethod(ExpressionClassBuilder acb, MethodBuilder mb, Optimizable optTable) throws StandardException {
        MethodBuilder qualMethod = acb.newUserExprFun();
        if (this.keyColumnOnLeft(optTable)) {
            this.rightOperand.generateExpression(acb, qualMethod);
        } else {
            this.leftOperand.generateExpression(acb, qualMethod);
        }
        qualMethod.methodReturn();
        qualMethod.complete();
        acb.pushMethodReference(mb, qualMethod);
    }

    public void generateOrderedNulls(MethodBuilder mb) {
        mb.push(false);
    }

    public boolean orderedNulls() {
        return false;
    }

    public boolean isQualifier(Optimizable optTable, boolean forPush) throws StandardException {
        if (this.inListProbeSource != null) {
            return false;
        }
        ValueNode otherSide = null;
        ColumnReference cr = null;
        boolean found = false;
        boolean walkSubtree = true;
        FromTable ft = (FromTable)optTable;
        if (this.leftOperand instanceof ColumnReference) {
            cr = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(cr, ft, forPush, walkSubtree)) {
                otherSide = this.rightOperand;
                found = true;
            }
            walkSubtree = false;
        }
        if (!found && this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(cr = (ColumnReference)this.rightOperand, ft, forPush, walkSubtree)) {
            otherSide = this.leftOperand;
            found = true;
        }
        if (!found) {
            return false;
        }
        return !this.valNodeReferencesOptTable(otherSide, ft, forPush, true);
    }

    public int getOrderableVariantType(Optimizable optTable) throws StandardException {
        if (this.keyColumnOnLeft(optTable)) {
            return this.rightOperand.getOrderableVariantType();
        }
        return this.leftOperand.getOrderableVariantType();
    }

    public boolean compareWithKnownConstant(Optimizable optTable, boolean considerParameters) {
        ValueNode node = null;
        ValueNode valueNode = node = this.keyColumnOnLeft(optTable) ? this.rightOperand : this.leftOperand;
        if (considerParameters) {
            return node instanceof ConstantNode || node.requiresTypeFromContext() && ((ParameterNode)node).getDefaultValue() != null;
        }
        return node instanceof ConstantNode;
    }

    public DataValueDescriptor getCompareValue(Optimizable optTable) throws StandardException {
        ValueNode node = null;
        ValueNode valueNode = node = this.keyColumnOnLeft(optTable) ? this.rightOperand : this.leftOperand;
        if (node instanceof ConstantNode) {
            return ((ConstantNode)node).getValue();
        }
        if (node.requiresTypeFromContext()) {
            ParameterNode pn = node instanceof UnaryOperatorNode ? ((UnaryOperatorNode)node).getParameterOperand() : (ParameterNode)node;
            return pn.getDefaultValue();
        }
        return null;
    }

    protected double booleanSelectivity(Optimizable optTable) throws StandardException {
        TypeId typeId = null;
        double retval = -1.0;
        int columnSide = this.columnOnOneSide(optTable);
        if (columnSide == -1) {
            typeId = this.leftOperand.getTypeId();
        } else if (columnSide == 1) {
            typeId = this.rightOperand.getTypeId();
        }
        if (typeId != null && (typeId.getJDBCTypeId() == -7 || typeId.getJDBCTypeId() == 16)) {
            retval = 0.5;
        }
        return retval;
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    BinaryOperatorNode getNegation(ValueNode leftOperand, ValueNode rightOperand) throws StandardException {
        SanityManager.ASSERT(this.getTypeServices() != null, "dataTypeServices is expected to be non-null");
        BinaryOperatorNode negation = (BinaryOperatorNode)this.getNodeFactory().getNode(this.getNegationNode(), leftOperand, rightOperand, this.getContextManager());
        negation.setType(this.getTypeServices());
        return negation;
    }

    private int getNegationNode() {
        switch (this.getNodeType()) {
            case 41: {
                return 47;
            }
            case 42: {
                return 45;
            }
            case 43: {
                return 44;
            }
            case 45: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 47: {
                return 41;
            }
        }
        SanityManager.THROWASSERT("getNegationNode called with invalid nodeType: " + this.getNodeType());
        return -1;
    }

    protected boolean usefulStartKey(boolean columnOnLeft) {
        switch (this.operatorType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return columnOnLeft;
            }
            case 5: 
            case 6: {
                return !columnOnLeft;
            }
        }
        return false;
    }

    protected boolean usefulStopKey(boolean columnOnLeft) {
        switch (this.operatorType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return !columnOnLeft;
            }
            case 5: 
            case 6: {
                return columnOnLeft;
            }
        }
        return false;
    }

    public int getStartOperator(Optimizable optTable) {
        switch (this.operatorType) {
            case 1: 
            case 4: 
            case 6: {
                return 1;
            }
            case 3: 
            case 5: {
                return -1;
            }
            case 2: {
                SanityManager.THROWASSERT("!= cannot be a start operator");
                return 0;
            }
        }
        return 0;
    }

    public int getStopOperator(Optimizable optTable) {
        switch (this.operatorType) {
            case 1: 
            case 4: 
            case 6: {
                return -1;
            }
            case 3: 
            case 5: {
                return 1;
            }
            case 2: {
                SanityManager.THROWASSERT("!= cannot be a stop operator");
                return 0;
            }
        }
        return 0;
    }

    public void generateOperator(MethodBuilder mb, Optimizable optTable) {
        switch (this.operatorType) {
            case 1: {
                mb.push(2);
                break;
            }
            case 2: {
                mb.push(2);
                break;
            }
            case 4: 
            case 5: {
                mb.push(this.keyColumnOnLeft(optTable) ? 1 : 3);
                break;
            }
            case 3: 
            case 6: {
                mb.push(this.keyColumnOnLeft(optTable) ? 3 : 1);
            }
        }
    }

    public void generateNegate(MethodBuilder mb, Optimizable optTable) {
        switch (this.operatorType) {
            case 1: {
                mb.push(false);
                break;
            }
            case 2: {
                mb.push(true);
                break;
            }
            case 5: 
            case 6: {
                mb.push(!this.keyColumnOnLeft(optTable));
                break;
            }
            case 3: 
            case 4: {
                mb.push(this.keyColumnOnLeft(optTable));
            }
        }
    }

    public int getOperator() {
        return this.operatorType;
    }

    public double selectivity(Optimizable optTable) throws StandardException {
        double retval = this.booleanSelectivity(optTable);
        if (retval >= 0.0) {
            return retval;
        }
        switch (this.operatorType) {
            case 1: {
                return 0.1;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (this.getBetweenSelectivity()) {
                    return 0.5;
                }
            }
            case 3: {
                return 0.33;
            }
        }
        return 0.0;
    }

    public RelationalOperator getTransitiveSearchClause(ColumnReference otherCR) throws StandardException {
        return (RelationalOperator)((Object)this.getNodeFactory().getNode(this.getNodeType(), otherCR, this.rightOperand, this.getContextManager()));
    }

    public boolean equalsComparisonWithConstantExpression(Optimizable optTable) {
        if (this.operatorType != 1) {
            return false;
        }
        boolean retval = false;
        Object comparand = null;
        int side = this.columnOnOneSide(optTable);
        if (side == -1) {
            retval = this.rightOperand.isConstantExpression();
        } else if (side == 1) {
            retval = this.leftOperand.isConstantExpression();
        }
        return retval;
    }

    public boolean isRelationalOperator() {
        return this.inListProbeSource == null;
    }

    public boolean isBinaryEqualsOperatorNode() {
        return this.inListProbeSource == null && this.operatorType == 1;
    }

    public boolean isInListProbeNode() {
        return this.inListProbeSource != null;
    }

    public boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) throws StandardException {
        if (this.operatorType != 1) {
            return false;
        }
        if (this.inListProbeSource != null) {
            return false;
        }
        ColumnReference cr = this.getColumnOperand(optTable, columnNumber);
        if (cr == null) {
            return false;
        }
        if (this.selfComparison(cr)) {
            return false;
        }
        return !this.implicitVarcharComparison();
    }

    private boolean implicitVarcharComparison() throws StandardException {
        TypeId leftType = this.leftOperand.getTypeId();
        TypeId rightType = this.rightOperand.getTypeId();
        if (leftType.isStringTypeId() && !rightType.isStringTypeId()) {
            return true;
        }
        return rightType.isStringTypeId() && !leftType.isStringTypeId();
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        if (this.operatorType == 1) {
            return this;
        }
        return super.genSQLJavaSQLTree();
    }

    public ValueNode getScopedOperand(int whichSide, JBitSet parentRSNsTables, ResultSetNode childRSN, int[] whichRC) throws StandardException {
        ResultColumn rc = null;
        ColumnReference cr = whichSide == -1 ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        JBitSet crTables = new JBitSet(parentRSNsTables.size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(crTables);
        cr.accept(btnVis);
        if (!parentRSNsTables.contains(crTables)) {
            return (ColumnReference)cr.getClone();
        }
        if (whichRC[0] == -1) {
            int[] sourceColPos = new int[]{-1};
            ResultSetNode sourceRSN = cr.getSourceResultSet(sourceColPos);
            SanityManager.ASSERT(sourceRSN != null, "Failed to find source result set when trying to scope column reference '" + cr.getTableName() + "." + cr.getColumnName());
            rc = childRSN.getResultColumns().getResultColumn(sourceColPos[0], sourceRSN, whichRC);
        } else {
            rc = childRSN.getResultColumns().getResultColumn(whichRC[0]);
        }
        SanityManager.ASSERT(rc != null, "Failed to locate scope target result column when trying to scope operand '" + cr.getTableName() + "." + cr.getColumnName() + "'.");
        if (rc.getExpression() instanceof ColumnReference) {
            ColumnReference cRef = (ColumnReference)((ColumnReference)rc.getExpression()).getClone();
            cRef.markAsScoped();
            return cRef;
        }
        return rc.getExpression();
    }

    private boolean valNodeReferencesOptTable(ValueNode valNode, FromTable optTable, boolean forPush, boolean walkOptTableSubtree) {
        this.initBaseTableVisitor(optTable.getReferencedTableMap().size(), walkOptTableSubtree);
        boolean found = false;
        try {
            if (walkOptTableSubtree) {
                this.buildTableNumList(optTable, forPush);
            }
            this.btnVis.setTableMap(this.valNodeBaseTables);
            valNode.accept(this.btnVis);
            this.valNodeBaseTables.and(this.optBaseTables);
            found = this.valNodeBaseTables.getFirstSetBit() != -1;
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Failed when trying to find base table numbers for reference check:", se);
        }
        return found;
    }

    private void initBaseTableVisitor(int numTablesInQuery, boolean initOptBaseTables) {
        if (this.valNodeBaseTables == null) {
            this.valNodeBaseTables = new JBitSet(numTablesInQuery);
        } else {
            this.valNodeBaseTables.clearAll();
        }
        if (initOptBaseTables) {
            if (this.optBaseTables == null) {
                this.optBaseTables = new JBitSet(numTablesInQuery);
            } else {
                this.optBaseTables.clearAll();
            }
        }
        if (this.btnVis == null) {
            this.btnVis = new BaseTableNumbersVisitor(this.valNodeBaseTables);
        }
    }

    private void buildTableNumList(FromTable ft, boolean forPush) throws StandardException {
        if (ft.getTableNumber() >= 0) {
            this.optBaseTables.set(ft.getTableNumber());
        }
        if (forPush) {
            return;
        }
        this.optBaseTables.or(ft.getReferencedTableMap());
        this.btnVis.setTableMap(this.optBaseTables);
        ft.accept(this.btnVis);
    }
}

