/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

class AccessPathImpl
implements AccessPath {
    ConglomerateDescriptor cd = null;
    private CostEstimate costEstimate = null;
    boolean coveringIndexScan = false;
    boolean nonMatchingIndexScan = false;
    JoinStrategy joinStrategy = null;
    int lockMode;
    Optimizer optimizer;
    private String accessPathName = "";

    AccessPathImpl(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    public void setConglomerateDescriptor(ConglomerateDescriptor cd) {
        this.cd = cd;
    }

    public ConglomerateDescriptor getConglomerateDescriptor() {
        return this.cd;
    }

    public void setCostEstimate(CostEstimate costEstimate) {
        if (this.costEstimate == null) {
            if (costEstimate != null) {
                this.costEstimate = costEstimate.cloneMe();
            }
        } else if (costEstimate == null) {
            this.costEstimate = null;
        } else {
            this.costEstimate.setCost(costEstimate);
        }
    }

    public CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    public void setCoveringIndexScan(boolean coveringIndexScan) {
        this.coveringIndexScan = coveringIndexScan;
    }

    public boolean getCoveringIndexScan() {
        return this.coveringIndexScan;
    }

    public void setNonMatchingIndexScan(boolean nonMatchingIndexScan) {
        this.nonMatchingIndexScan = nonMatchingIndexScan;
    }

    public boolean getNonMatchingIndexScan() {
        return this.nonMatchingIndexScan;
    }

    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }

    public JoinStrategy getJoinStrategy() {
        return this.joinStrategy;
    }

    public void setLockMode(int lockMode) {
        this.lockMode = lockMode;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public void copy(AccessPath copyFrom) {
        this.setConglomerateDescriptor(copyFrom.getConglomerateDescriptor());
        this.setCostEstimate(copyFrom.getCostEstimate());
        this.setCoveringIndexScan(copyFrom.getCoveringIndexScan());
        this.setNonMatchingIndexScan(copyFrom.getNonMatchingIndexScan());
        this.setJoinStrategy(copyFrom.getJoinStrategy());
        this.setLockMode(copyFrom.getLockMode());
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public String toString() {
        return "cd == " + this.cd + ", costEstimate == " + this.costEstimate + ", coveringIndexScan == " + this.coveringIndexScan + ", nonMatchingIndexScan == " + this.nonMatchingIndexScan + ", joinStrategy == " + this.joinStrategy + ", lockMode == " + this.lockMode + ", optimizer level == " + this.optimizer.getLevel();
    }

    public void initializeAccessPathName(DataDictionary dd, TableDescriptor td) throws StandardException {
        if (this.cd == null) {
            return;
        }
        if (this.cd.isConstraint()) {
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(td, this.cd.getUUID());
            if (constraintDesc == null) {
                throw StandardException.newException("42X94", (Object)"CONSTRAINT on TABLE", (Object)td.getName());
            }
            this.accessPathName = constraintDesc.getConstraintName();
        } else {
            this.accessPathName = this.cd.isIndex() ? this.cd.getConglomerateName() : "";
        }
    }
}

