/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

class SYSTABLESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSTABLES";
    protected static final int SYSTABLES_COLUMN_COUNT = 5;
    protected static final int SYSTABLES_TABLEID = 1;
    protected static final int SYSTABLES_TABLENAME = 2;
    protected static final int SYSTABLES_TABLETYPE = 3;
    protected static final int SYSTABLES_SCHEMAID = 4;
    protected static final int SYSTABLES_LOCKGRANULARITY = 5;
    protected static final int SYSTABLES_INDEX1_ID = 0;
    protected static final int SYSTABLES_INDEX1_TABLENAME = 1;
    protected static final int SYSTABLES_INDEX1_SCHEMAID = 2;
    protected static final int SYSTABLES_INDEX2_ID = 1;
    protected static final int SYSTABLES_INDEX2_TABLEID = 1;
    private static final String[] uuids = new String[]{"80000018-00d0-fd77-3ed8-000a0a0b1900", "80000028-00d0-fd77-3ed8-000a0a0b1900", "8000001a-00d0-fd77-3ed8-000a0a0b1900", "8000001c-00d0-fd77-3ed8-000a0a0b1900"};
    private static final int[][] indexColumnPositions = new int[][]{{2, 4}, {1}};

    SYSTABLESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(5, TABLENAME_STRING, indexColumnPositions, null, uuids);
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String tabSType = null;
        String lockGranularity = null;
        String tableID = null;
        String schemaID = null;
        String tableName = null;
        if (td != null) {
            TableDescriptor descriptor = (TableDescriptor)td;
            SchemaDescriptor schema = (SchemaDescriptor)parent;
            UUID oid = descriptor.getUUID();
            if (oid == null) {
                oid = this.getUUIDFactory().createUUID();
                descriptor.setUUID(oid);
            }
            tableID = oid.toString();
            SanityManager.ASSERT(schema != null, "Schema should not be null unless empty row is true");
            if (schema.getUUID() == null) {
                SanityManager.THROWASSERT("schema " + schema + " has a null OID");
            }
            schemaID = schema.getUUID().toString();
            tableName = descriptor.getName();
            int tabIType = descriptor.getTableType();
            switch (tabIType) {
                case 0: {
                    tabSType = "T";
                    break;
                }
                case 1: {
                    tabSType = "S";
                    break;
                }
                case 2: {
                    tabSType = "V";
                    break;
                }
                case 4: {
                    tabSType = "A";
                    break;
                }
                default: {
                    SanityManager.THROWASSERT("invalid table type");
                }
            }
            char[] lockGChar = new char[]{descriptor.getLockGranularity()};
            lockGranularity = new String(lockGChar);
        }
        ExecRow row = this.getExecutionFactory().getValueRow(5);
        row.setColumn(1, new SQLChar(tableID));
        row.setColumn(2, new SQLVarchar(tableName));
        row.setColumn(3, new SQLChar(tabSType));
        row.setColumn(4, new SQLChar(schemaID));
        row.setColumn(5, new SQLChar(lockGranularity));
        return row;
    }

    ExecIndexRow buildEmptyIndexRow(int indexNumber, RowLocation rowLocation) throws StandardException {
        int ncols = this.getIndexColumnCount(indexNumber);
        ExecIndexRow row = this.getExecutionFactory().getIndexableRow(ncols + 1);
        row.setColumn(ncols + 1, rowLocation);
        switch (indexNumber) {
            case 0: {
                row.setColumn(1, new SQLVarchar());
                row.setColumn(2, new SQLChar());
                break;
            }
            case 1: {
                row.setColumn(1, new SQLChar());
            }
        }
        return row;
    }

    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        int tableTypeEnum;
        SanityManager.ASSERT(row.nColumns() == 5, "Wrong number of columns for a SYSTABLES row");
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String tableUUIDString = col.getString();
        UUID tableUUID = this.getUUIDFactory().recreateUUID(tableUUIDString);
        col = row.getColumn(2);
        String tableName = col.getString();
        col = row.getColumn(3);
        String tableType = col.getString();
        SanityManager.ASSERT(tableType.length() == 1, "Fourth column type incorrect");
        switch (tableType.charAt(0)) {
            case 'T': {
                tableTypeEnum = 0;
                break;
            }
            case 'S': {
                tableTypeEnum = 1;
                break;
            }
            case 'V': {
                tableTypeEnum = 2;
                break;
            }
            case 'A': {
                tableTypeEnum = 4;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Fourth column value invalid");
                tableTypeEnum = -1;
            }
        }
        col = row.getColumn(4);
        String schemaUUIDString = col.getString();
        UUID schemaUUID = this.getUUIDFactory().recreateUUID(schemaUUIDString);
        SchemaDescriptor schema = dd.getSchemaDescriptor(schemaUUID, null);
        col = row.getColumn(5);
        String lockGranularity = col.getString();
        SanityManager.ASSERT(lockGranularity.length() == 1, "Fifth column type incorrect");
        TableDescriptor tabDesc = ddg.newTableDescriptor(tableName, schema, tableTypeEnum, lockGranularity.charAt(0));
        tabDesc.setUUID(tableUUID);
        return tabDesc;
    }

    protected String getTableName(ExecRow row) throws StandardException {
        DataValueDescriptor col = row.getColumn(2);
        return col.getString();
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getIdentifierColumn("TABLENAME", false), SystemColumnImpl.getIndicatorColumn("TABLETYPE"), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIndicatorColumn("LOCKGRANULARITY")};
    }
}

