/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.catalog.types.TypeDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSCOLUMNSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLUMNS";
    protected static final int SYSCOLUMNS_COLUMN_COUNT = 9;
    protected static final int SYSCOLUMNS_TABLEID = 1;
    protected static final int SYSCOLUMNS_REFERENCEID = 1;
    protected static final int SYSCOLUMNS_COLUMNNAME = 2;
    protected static final int SYSCOLUMNS_COLUMNNUMBER = 3;
    protected static final int SYSCOLUMNS_COLUMNDATATYPE = 4;
    protected static final int SYSCOLUMNS_COLUMNDEFAULT = 5;
    protected static final int SYSCOLUMNS_COLUMNDEFAULTID = 6;
    protected static final int SYSCOLUMNS_AUTOINCREMENTVALUE = 7;
    protected static final int SYSCOLUMNS_AUTOINCREMENTSTART = 8;
    protected static final int SYSCOLUMNS_AUTOINCREMENTINC = 9;
    protected static final int SYSCOLUMNS_INDEX1_ID = 0;
    protected static final int SYSCOLUMNS_INDEX2_ID = 1;
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000001e-00d0-fd77-3ed8-000a0a0b1900", "80000029-00d0-fd77-3ed8-000a0a0b1900", "80000020-00d0-fd77-3ed8-000a0a0b1900", "6839c016-00d9-2829-dfcd-000a0a411400"};
    private static final int[][] indexColumnPositions = new int[][]{{1, 2}, {6}};

    SYSCOLUMNSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        this(uuidf, ef, dvf, TABLENAME_STRING);
    }

    SYSCOLUMNSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf, String myName) {
        super(uuidf, ef, dvf);
        this.initInfo(9, myName, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        ColumnDescriptor column;
        String colName = null;
        String defaultID = null;
        String tabID = null;
        Integer colID = null;
        TypeDescriptorImpl typeDesc = null;
        Object defaultSerializable = null;
        long autoincStart = 0L;
        long autoincInc = 0L;
        long autoincValue = 0L;
        long autoinc_create_or_modify_Start_Increment = -1L;
        if (td != null) {
            column = (ColumnDescriptor)td;
            typeDesc = column.getType().getCatalogType();
            tabID = column.getReferencingUUID().toString();
            colName = column.getColumnName();
            colID = new Integer(column.getPosition());
            autoincStart = column.getAutoincStart();
            autoincInc = column.getAutoincInc();
            autoincValue = column.getAutoincValue();
            autoinc_create_or_modify_Start_Increment = column.getAutoinc_create_or_modify_Start_Increment();
            defaultSerializable = column.getDefaultInfo() != null ? column.getDefaultInfo() : column.getDefaultValue();
            if (column.getDefaultUUID() != null) {
                defaultID = column.getDefaultUUID().toString();
            }
        }
        ExecRow row = this.getExecutionFactory().getValueRow(9);
        row.setColumn(1, new SQLChar(tabID));
        row.setColumn(2, new SQLVarchar(colName));
        row.setColumn(3, new SQLInteger(colID));
        row.setColumn(4, this.dvf.getDataValue(typeDesc));
        row.setColumn(5, this.dvf.getDataValue(defaultSerializable));
        row.setColumn(6, new SQLChar(defaultID));
        if (autoinc_create_or_modify_Start_Increment == 0L || autoinc_create_or_modify_Start_Increment == 2L) {
            row.setColumn(7, new SQLLongint(autoincValue));
            row.setColumn(8, new SQLLongint(autoincStart));
            row.setColumn(9, new SQLLongint(autoincInc));
        } else if (autoinc_create_or_modify_Start_Increment == 1L) {
            column = (ColumnDescriptor)td;
            row.setColumn(7, new SQLLongint(autoincStart));
            row.setColumn(8, new SQLLongint(autoincStart));
            row.setColumn(9, new SQLLongint(column.getTableDescriptor().getColumnDescriptor(colName).getAutoincInc()));
        } else {
            row.setColumn(7, new SQLLongint());
            row.setColumn(8, new SQLLongint());
            row.setColumn(9, new SQLLongint());
        }
        return row;
    }

    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    public Properties getCreateIndexProperties(int indexNumber) {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        return properties;
    }

    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT(row.nColumns() == 9, "Wrong number of columns for a SYSCOLUMNS row");
        DefaultInfoImpl defaultInfo = null;
        DataValueDescriptor defaultValue = null;
        UUID defaultUUID = null;
        UUID uuid = null;
        UUIDFactory uuidFactory = this.getUUIDFactory();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (parentTupleDescriptor != null) {
            if (!(parentTupleDescriptor instanceof UniqueTupleDescriptor)) {
                SanityManager.THROWASSERT(parentTupleDescriptor.getClass().getName() + " not instanceof UniqueTupleDescriptor");
            }
            uuid = ((UniqueTupleDescriptor)((Object)parentTupleDescriptor)).getUUID();
        } else {
            uuid = uuidFactory.recreateUUID(row.getColumn(1).getString());
        }
        Object object = row.getColumn(5).getObject();
        if (object instanceof DataValueDescriptor) {
            defaultValue = (DataValueDescriptor)object;
        } else if (object instanceof DefaultInfoImpl) {
            defaultInfo = (DefaultInfoImpl)object;
            defaultValue = defaultInfo.getDefaultValue();
        }
        String defaultID = row.getColumn(6).getString();
        if (defaultID != null) {
            defaultUUID = uuidFactory.recreateUUID(defaultID);
        }
        String columnName = row.getColumn(2).getString();
        int columnNumber = row.getColumn(3).getInt();
        TypeDescriptorImpl typeDescriptor = (TypeDescriptorImpl)row.getColumn(4).getObject();
        BaseTypeIdImpl typeId = typeDescriptor.getTypeId();
        TypeId wrapperTypeId = (TypeId)Monitor.newInstanceFromIdentifier(typeId.wrapperTypeFormatId());
        wrapperTypeId.setNestedTypeId(typeId);
        DataTypeDescriptor dataTypeServices = new DataTypeDescriptor(typeDescriptor, wrapperTypeId);
        long autoincValue = row.getColumn(7).getLong();
        long autoincStart = row.getColumn(8).getLong();
        long autoincInc = row.getColumn(9).getLong();
        DataValueDescriptor col = row.getColumn(8);
        autoincStart = col.getLong();
        col = row.getColumn(9);
        autoincInc = col.getLong();
        ColumnDescriptor colDesc = new ColumnDescriptor(columnName, columnNumber, dataTypeServices, defaultValue, (DefaultInfo)defaultInfo, uuid, defaultUUID, autoincStart, autoincInc, autoincValue);
        return colDesc;
    }

    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("REFERENCEID", false), SystemColumnImpl.getIdentifierColumn("COLUMNNAME", false), SystemColumnImpl.getColumn("COLUMNNUMBER", 4, false), SystemColumnImpl.getJavaColumn("COLUMNDATATYPE", "org.apache.derby.catalog.TypeDescriptor", false), SystemColumnImpl.getJavaColumn("COLUMNDEFAULT", "java.io.Serializable", true), SystemColumnImpl.getUUIDColumn("COLUMNDEFAULTID", true), SystemColumnImpl.getColumn("AUTOINCREMENTVALUE", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTSTART", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTINC", -5, true)};
    }
}

