/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Dependable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.catalog.DDdependableFinder;

public class DDColumnDependableFinder
extends DDdependableFinder {
    private byte[] columnBitMap;

    public DDColumnDependableFinder(int formatId) {
        super(formatId);
    }

    public DDColumnDependableFinder(int formatId, byte[] columnBitMap) {
        super(formatId);
        this.columnBitMap = columnBitMap;
    }

    public byte[] getColumnBitMap() {
        return this.columnBitMap;
    }

    public void setColumnBitMap(byte[] columnBitMap) {
        this.columnBitMap = columnBitMap;
    }

    Dependable findDependable(DataDictionary dd, UUID dependableObjectID) throws StandardException {
        TableDescriptor td = dd.getTableDescriptor(dependableObjectID);
        if (td != null) {
            td.setReferencedColumnMap(new FormatableBitSet(this.columnBitMap));
        }
        return td;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.columnBitMap = (byte[])fh.get("columnBitMap");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        FormatableHashtable fh = new FormatableHashtable();
        fh.put("columnBitMap", this.columnBitMap);
        out.writeObject(fh);
    }
}

