/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericActivationHolder;
import org.apache.derby.impl.sql.compile.StatementNode;

public class GenericPreparedStatement
implements ExecPreparedStatement {
    public Statement statement;
    protected GeneratedClass activationClass;
    protected ResultDescription resultDesc;
    protected DataTypeDescriptor[] paramTypeDescriptors;
    private String spsName;
    private SQLWarning warnings;
    private boolean referencesSessionSchema;
    protected ExecCursorTableReference targetTable;
    protected ResultColumnDescriptor[] targetColumns;
    protected String[] updateColumns;
    protected int updateMode;
    protected ConstantAction executionConstants;
    protected Object[] savedObjects;
    protected List requiredPermissionsList;
    protected String UUIDString;
    protected UUID UUIDValue;
    private boolean needsSavepoint;
    private String execStmtName;
    private String execSchemaName;
    protected boolean isAtomic;
    protected String sourceTxt;
    private int inUseCount;
    boolean compilingStatement;
    protected long parseTime;
    protected long bindTime;
    protected long optimizeTime;
    protected long generateTime;
    protected long compileTime;
    protected Timestamp beginCompileTimestamp;
    protected Timestamp endCompileTimestamp;
    protected boolean isValid;
    protected boolean spsAction;
    private Cacheable cacheHolder;

    GenericPreparedStatement() {
        UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.UUIDValue = uuidFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
        this.spsAction = false;
    }

    public GenericPreparedStatement(Statement st) {
        this();
        this.statement = st;
    }

    public synchronized boolean upToDate() throws StandardException {
        return this.isValid && this.activationClass != null && !this.compilingStatement;
    }

    public void rePrepare(LanguageConnectionContext lcc) throws StandardException {
        if (!this.upToDate()) {
            PreparedStatement ps = this.statement.prepare(lcc);
            SanityManager.ASSERT(ps == this, "ps != this");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activation getActivation(LanguageConnectionContext lcc, boolean scrollable) throws StandardException {
        GenericActivationHolder ac;
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            GeneratedClass gc = this.getActivationClass();
            if (gc == null) {
                this.rePrepare(lcc);
                gc = this.getActivationClass();
            }
            ac = new GenericActivationHolder(lcc, gc, this, scrollable);
            ++this.inUseCount;
        }
        lcc.closeUnusedActivations();
        return ac;
    }

    public ResultSet execute(LanguageConnectionContext lcc, boolean rollbackParentContext, long timeoutMillis) throws StandardException {
        Activation a = this.getActivation(lcc, false);
        a.setSingleExecution();
        return this.execute(a, rollbackParentContext, timeoutMillis);
    }

    public ResultSet execute(Activation activation, boolean rollbackParentContext, long timeoutMillis) throws StandardException {
        ResultSet resultSet;
        StatementContext statementContext;
        LanguageConnectionContext lccToUse;
        boolean needToClearSavePoint = false;
        if (activation == null || activation.getPreparedStatement() != this) {
            throw StandardException.newException("XCL09.S", "execute");
        }
        while (true) {
            if ((lccToUse = activation.getLanguageConnectionContext()).getLogStatementText()) {
                HeaderPrintWriter istream = Monitor.getStream();
                String xactId = lccToUse.getTransactionExecute().getActiveStateTxIdString();
                String pvsString = "";
                ParameterValueSet pvs = activation.getParameterValueSet();
                if (pvs != null && pvs.getParameterCount() > 0) {
                    pvsString = " with " + pvs.getParameterCount() + " parameters " + pvs.toString();
                }
                istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lccToUse.getInstanceNumber() + "), " + "(DATABASE = " + lccToUse.getDbname() + "), " + "(DRDAID = " + lccToUse.getDrdaID() + "), Executing prepared statement: " + this.getSource() + " :End prepared statement" + pvsString);
            }
            ParameterValueSet pvs = activation.getParameterValueSet();
            if (!this.spsAction) {
                this.rePrepare(lccToUse);
            }
            statementContext = lccToUse.pushStatementContext(this.isAtomic, this.updateMode == 1, this.getSource(), pvs, rollbackParentContext, timeoutMillis);
            if (this.needsSavepoint()) {
                statementContext.setSavePoint();
                needToClearSavePoint = true;
            }
            if (this.executionConstants != null) {
                lccToUse.validateStmtExecution(this.executionConstants);
            }
            resultSet = null;
            try {
                resultSet = activation.execute();
                resultSet.open();
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("XCL32.S") || this.spsAction) {
                    throw se;
                }
                statementContext.cleanupOnError(se);
                continue;
            }
            break;
        }
        if (needToClearSavePoint) {
            statementContext.clearSavePoint();
        }
        lccToUse.popStatementContext(statementContext, null);
        if (activation.isSingleExecution() && resultSet.isClosed()) {
            activation.close();
        }
        return resultSet;
    }

    public ResultDescription getResultDescription() {
        return this.resultDesc;
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.paramTypeDescriptors;
    }

    public String getSource() {
        return this.sourceTxt != null ? this.sourceTxt : (this.statement == null ? "null" : this.statement.getSource());
    }

    public void setSource(String text) {
        this.sourceTxt = text;
    }

    public final void setSPSName(String name) {
        this.spsName = name;
    }

    public String getSPSName() {
        return this.spsName;
    }

    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    public Timestamp getBeginCompileTimestamp() {
        return this.beginCompileTimestamp;
    }

    public Timestamp getEndCompileTimestamp() {
        return this.endCompileTimestamp;
    }

    void setCompileTimeWarnings(SQLWarning warnings) {
        this.warnings = warnings;
    }

    public final SQLWarning getCompileTimeWarnings() {
        return this.warnings;
    }

    protected void setCompileTimeMillis(long parseTime, long bindTime, long optimizeTime, long generateTime, long compileTime, Timestamp beginCompileTimestamp, Timestamp endCompileTimestamp) {
        this.parseTime = parseTime;
        this.bindTime = bindTime;
        this.optimizeTime = optimizeTime;
        this.generateTime = generateTime;
        this.compileTime = compileTime;
        this.beginCompileTimestamp = beginCompileTimestamp;
        this.endCompileTimestamp = endCompileTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(LanguageConnectionContext lcc) {
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            --this.inUseCount;
            if (this.cacheHolder != null) {
                return;
            }
            if (this.inUseCount != 0) {
                return;
            }
        }
        try {
            this.makeInvalid(11, lcc);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
        }
    }

    final void setConstantAction(ConstantAction constantAction) {
        this.executionConstants = constantAction;
    }

    public final ConstantAction getConstantAction() {
        return this.executionConstants;
    }

    final void setSavedObjects(Object[] objects) {
        this.savedObjects = objects;
    }

    public final Object getSavedObject(int objectNum) {
        if (objectNum < 0 || objectNum >= this.savedObjects.length) {
            SanityManager.THROWASSERT("request for savedObject entry " + objectNum + " invalid; " + "savedObjects has " + this.savedObjects.length + " entries");
        }
        return this.savedObjects[objectNum];
    }

    public final Object[] getSavedObjects() {
        return this.savedObjects;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid() {
        this.isValid = true;
    }

    public void setSPSAction() {
        this.spsAction = true;
    }

    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 3: 
            case 5: {
                return;
            }
        }
        lcc.verifyNoOpenResultSets(this, p, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            if (this.compilingStatement) {
                return;
            }
            boolean alreadyInvalid = !this.isValid;
            this.isValid = false;
            this.compilingStatement = true;
        }
        try {
            DependencyManager dm = lcc.getDataDictionary().getDependencyManager();
            dm.clearDependencies(lcc, this);
            if (this.execStmtName == null) return;
            switch (action) {
                case 5: 
                case 23: {
                    DataDictionary dd = lcc.getDataDictionary();
                    SchemaDescriptor sd = dd.getSchemaDescriptor(this.execSchemaName, lcc.getTransactionCompile(), true);
                    SPSDescriptor spsd = dd.getSPSDescriptor(this.execStmtName, sd);
                    spsd.makeInvalid(action, lcc);
                    return;
                }
            }
            return;
        }
        finally {
            genericPreparedStatement = this;
            synchronized (genericPreparedStatement) {
                this.compilingStatement = false;
                this.notifyAll();
            }
        }
    }

    public boolean isPersistent() {
        return false;
    }

    public DependableFinder getDependableFinder() {
        return null;
    }

    public String getObjectName() {
        return this.UUIDString;
    }

    public UUID getObjectID() {
        return this.UUIDValue;
    }

    public String getClassType() {
        return "PreparedStatement";
    }

    public boolean referencesSessionSchema() {
        return this.referencesSessionSchema;
    }

    public boolean referencesSessionSchema(StatementNode qt) throws StandardException {
        this.referencesSessionSchema = qt.referencesSessionSchema();
        return this.referencesSessionSchema;
    }

    void completeCompile(StatementNode qt) throws StandardException {
        CursorInfo cursorInfo;
        this.paramTypeDescriptors = qt.getParameterTypes();
        if (this.targetTable != null) {
            this.targetTable = null;
            this.updateMode = 0;
            this.updateColumns = null;
            this.targetColumns = null;
        }
        this.resultDesc = qt.makeResultDescription();
        if (this.resultDesc != null && (cursorInfo = (CursorInfo)qt.getCursorInfo()) != null) {
            this.targetTable = cursorInfo.targetTable;
            this.targetColumns = cursorInfo.targetColumns;
            this.updateColumns = cursorInfo.updateColumns;
            this.updateMode = cursorInfo.updateMode;
        }
        this.isValid = true;
    }

    public GeneratedClass getActivationClass() throws StandardException {
        return this.activationClass;
    }

    void setActivationClass(GeneratedClass ac) {
        this.activationClass = ac;
    }

    public int getUpdateMode() {
        return this.updateMode;
    }

    public ExecCursorTableReference getTargetTable() {
        SanityManager.ASSERT(this.targetTable != null, "Not a cursor, no target table");
        return this.targetTable;
    }

    public ResultColumnDescriptor[] getTargetColumns() {
        return this.targetColumns;
    }

    public String[] getUpdateColumns() {
        return this.updateColumns;
    }

    public Object getCursorInfo() {
        return new CursorInfo(this.updateMode, this.targetTable, this.targetColumns, this.updateColumns);
    }

    void setCursorInfo(CursorInfo cursorInfo) {
        if (cursorInfo != null) {
            this.updateMode = cursorInfo.updateMode;
            this.targetTable = cursorInfo.targetTable;
            this.targetColumns = cursorInfo.targetColumns;
            this.updateColumns = cursorInfo.updateColumns;
        }
    }

    ByteArray getByteCodeSaver() {
        return null;
    }

    public boolean needsSavepoint() {
        return this.needsSavepoint;
    }

    void setNeedsSavepoint(boolean needsSavepoint) {
        this.needsSavepoint = needsSavepoint;
    }

    void setIsAtomic(boolean isAtomic) {
        this.isAtomic = isAtomic;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    void setExecuteStatementNameAndSchema(String execStmtName, String execSchemaName) {
        this.execStmtName = execStmtName;
        this.execSchemaName = execSchemaName;
    }

    public ExecPreparedStatement getClone() throws StandardException {
        GenericPreparedStatement clone = new GenericPreparedStatement(this.statement);
        clone.activationClass = this.getActivationClass();
        clone.resultDesc = this.resultDesc;
        clone.paramTypeDescriptors = this.paramTypeDescriptors;
        clone.executionConstants = this.executionConstants;
        clone.UUIDString = this.UUIDString;
        clone.UUIDValue = this.UUIDValue;
        clone.savedObjects = this.savedObjects;
        clone.execStmtName = this.execStmtName;
        clone.execSchemaName = this.execSchemaName;
        clone.isAtomic = this.isAtomic;
        clone.sourceTxt = this.sourceTxt;
        clone.targetTable = this.targetTable;
        clone.targetColumns = this.targetColumns;
        clone.updateColumns = this.updateColumns;
        clone.updateMode = this.updateMode;
        clone.needsSavepoint = this.needsSavepoint;
        return clone;
    }

    public void setCacheHolder(Cacheable cacheHolder) {
        this.cacheHolder = cacheHolder;
        if (cacheHolder == null) {
            if (!this.isValid || this.inUseCount != 0) {
                return;
            }
            ContextManager cm = ContextService.getFactory().getCurrentContextManager();
            LanguageConnectionContext lcc = (LanguageConnectionContext)cm.getContext("LanguageConnectionContext");
            try {
                this.makeInvalid(11, lcc);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Unexpected exception", se);
            }
        }
    }

    public String toString() {
        return this.getObjectName();
    }

    public boolean isStorable() {
        return false;
    }

    public void setRequiredPermissionsList(List requiredPermissionsList) {
        this.requiredPermissionsList = requiredPermissionsList;
    }

    public List getRequiredPermissionsList() {
        return this.requiredPermissionsList;
    }
}

