/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.sql.GenericParameter;

final class GenericParameterValueSet
implements ParameterValueSet {
    private final GenericParameter[] parms;
    final ClassInspector ci;
    private final boolean hasReturnOutputParam;

    GenericParameterValueSet(ClassInspector ci, int numParms, boolean hasReturnOutputParam) {
        this.ci = ci;
        this.hasReturnOutputParam = hasReturnOutputParam;
        this.parms = new GenericParameter[numParms];
        for (int i = 0; i < numParms; ++i) {
            this.parms[i] = new GenericParameter(this, hasReturnOutputParam && i == 0);
        }
    }

    private GenericParameterValueSet(int numParms, GenericParameterValueSet pvs) {
        this.hasReturnOutputParam = pvs.hasReturnOutputParam;
        this.ci = pvs.ci;
        this.parms = new GenericParameter[numParms];
        for (int i = 0; i < numParms; ++i) {
            this.parms[i] = pvs.getGenericParameter(i).getClone(this);
        }
    }

    public void initialize(DataTypeDescriptor[] types) throws StandardException {
        for (int i = 0; i < this.parms.length; ++i) {
            DataTypeDescriptor dtd = types[i];
            this.parms[i].initialize(dtd.getNull(), dtd.getJDBCTypeId(), dtd.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    public void setParameterMode(int position, int mode) {
        this.parms[position].parameterMode = (short)mode;
    }

    public void clearParameters() {
        for (int i = 0; i < this.parms.length; ++i) {
            this.parms[i].clear();
        }
    }

    public int getParameterCount() {
        return this.parms.length;
    }

    public DataValueDescriptor getParameter(int position) throws StandardException {
        try {
            return this.parms[position].getValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.checkPosition(position);
            return null;
        }
    }

    public DataValueDescriptor getParameterForSet(int position) throws StandardException {
        try {
            GenericParameter gp = this.parms[position];
            if (gp.parameterMode == 4) {
                throw StandardException.newException("XCL27.S");
            }
            gp.isSet = true;
            return gp.getValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.checkPosition(position);
            return null;
        }
    }

    public DataValueDescriptor getParameterForGet(int position) throws StandardException {
        try {
            GenericParameter gp = this.parms[position];
            switch (gp.parameterMode) {
                case 0: 
                case 1: {
                    throw StandardException.newException("XCL26.S", Integer.toString(position + 1));
                }
            }
            return gp.getValue();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.checkPosition(position);
            return null;
        }
    }

    public void setParameterAsObject(int position, Object value) throws StandardException {
        UserDataValue dvd = (UserDataValue)this.getParameterForSet(position);
        GenericParameter gp = this.parms[position];
        if (value != null) {
            boolean throwError;
            ClassNotFoundException t = null;
            try {
                throwError = !this.ci.instanceOf(gp.declaredClassName, value);
            }
            catch (ClassNotFoundException cnfe) {
                t = cnfe;
                throwError = true;
            }
            if (throwError) {
                throw StandardException.newException("XCL12.S", t, (Object)ClassInspector.readableClassName(value.getClass()), (Object)gp.declaredClassName);
            }
        }
        dvd.setValue(value);
    }

    public boolean allAreSet() {
        block4: for (int i = 0; i < this.parms.length; ++i) {
            GenericParameter gp = this.parms[i];
            if (gp.isSet) continue;
            switch (gp.parameterMode) {
                case 4: {
                    continue block4;
                }
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    public void transferDataValues(ParameterValueSet pvstarget) throws StandardException {
        int firstParam;
        for (int i = firstParam = pvstarget.hasReturnOutputParameter() ? 1 : 0; i < this.parms.length; ++i) {
            GenericParameter oldp = this.parms[i];
            if (oldp.registerOutType != 0) {
                pvstarget.registerOutParameter(i, oldp.registerOutType, oldp.registerOutScale);
            }
            if (!oldp.isSet) continue;
            pvstarget.getParameterForSet(i).setValue(oldp.getValue());
        }
    }

    GenericParameter getGenericParameter(int position) {
        return this.parms[position];
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        for (int ctr = 0; ctr < this.parms.length; ++ctr) {
            strbuf.append("begin parameter #" + (ctr + 1) + ": ");
            strbuf.append(this.parms[ctr].toString());
            strbuf.append(" :end parameter ");
        }
        return strbuf.toString();
    }

    private void checkPosition(int position) throws StandardException {
        if (position < 0 || position >= this.parms.length) {
            if (this.parms.length == 0) {
                throw StandardException.newException("07009");
            }
            throw StandardException.newException("XCL13.S", (Object)String.valueOf(position + 1), (Object)String.valueOf(this.parms.length));
        }
    }

    public ParameterValueSet getClone() {
        return new GenericParameterValueSet(this.parms.length, this);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws StandardException {
        this.checkPosition(parameterIndex);
        this.parms[parameterIndex].setOutParameter(sqlType, scale);
    }

    public void validate() throws StandardException {
        for (int i = 0; i < this.parms.length; ++i) {
            this.parms[i].validate();
        }
    }

    public int getParameterNumber(GenericParameter theParam) {
        for (int i = 0; i < this.parms.length; ++i) {
            if (this.parms[i] != theParam) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean checkNoDeclaredOutputParameters() {
        boolean hasDeclaredOutputParameter = false;
        block5: for (int i = 0; i < this.parms.length; ++i) {
            GenericParameter gp = this.parms[i];
            switch (gp.parameterMode) {
                case 1: {
                    continue block5;
                }
                case 2: 
                case 4: {
                    hasDeclaredOutputParameter = true;
                    continue block5;
                }
                case 0: {
                    gp.parameterMode = 1;
                }
            }
        }
        return hasDeclaredOutputParameter;
    }

    public short getParameterMode(int parameterIndex) {
        short mode = this.parms[parameterIndex - 1].parameterMode;
        return mode;
    }

    public boolean hasReturnOutputParameter() {
        return this.hasReturnOutputParam;
    }

    public DataValueDescriptor getReturnValueForSet() throws StandardException {
        this.checkPosition(0);
        if (!this.hasReturnOutputParam) {
            SanityManager.THROWASSERT("getReturnValueForSet called on non-return parameter");
        }
        return this.parms[0].getValue();
    }

    public int getScale(int parameterIndex) {
        return this.parms[parameterIndex - 1].getScale();
    }

    public int getPrecision(int parameterIndex) {
        return this.parms[parameterIndex - 1].getPrecision();
    }
}

