/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;

public class CursorInfo
implements Formatable {
    ExecCursorTableReference targetTable;
    ResultColumnDescriptor[] targetColumns;
    String[] updateColumns;
    int updateMode;

    public CursorInfo() {
    }

    public CursorInfo(int updateMode, ExecCursorTableReference targetTable, ResultColumnDescriptor[] targetColumns, String[] updateColumns) {
        this.updateMode = updateMode;
        this.targetTable = targetTable;
        this.targetColumns = targetColumns;
        this.updateColumns = updateColumns;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.updateMode);
        out.writeObject(this.targetTable);
        ArrayUtil.writeArray(out, this.targetColumns);
        ArrayUtil.writeArray(out, this.updateColumns);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.updateMode = in.readInt();
        this.targetTable = (ExecCursorTableReference)in.readObject();
        int len = ArrayUtil.readArrayLength(in);
        if (len != 0) {
            this.targetColumns = new ResultColumnDescriptor[len];
            ArrayUtil.readArrayItems(in, this.targetColumns);
        }
        if ((len = ArrayUtil.readArrayLength(in)) != 0) {
            this.updateColumns = new String[len];
            ArrayUtil.readArrayItems(in, this.updateColumns);
        }
    }

    public int getTypeFormatId() {
        return 297;
    }

    public String toString() {
        int i;
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("CursorInfo\n\tupdateMode: " + this.updateMode + "\n\ttargetTable: " + this.targetTable + "\n\tupdateColumns: ");
        if (this.updateColumns == null) {
            strbuf.append("NULL\n");
        } else {
            strbuf.append("{");
            for (i = 0; i < this.updateColumns.length; ++i) {
                if (i > 0) {
                    strbuf.append(",");
                }
                strbuf.append(this.updateColumns[i]);
            }
            strbuf.append(")\n");
        }
        strbuf.append("\tTargetColumnDescriptors: \n");
        if (this.targetColumns == null) {
            strbuf.append("NULL");
        } else {
            for (i = 0; i < this.targetColumns.length; ++i) {
                strbuf.append(this.targetColumns[i]);
            }
            strbuf.append("\n");
        }
        return strbuf.toString();
    }
}

