/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockList;
import org.apache.derby.impl.services.locks.LockTable;

final class LockSpace
implements CompatibilitySpace {
    private final HashMap groups;
    private final Object owner;
    private HashMap[] spareGroups = new HashMap[3];
    private Object callbackGroup;
    private int limit;
    private int nextLimitCall;
    private Limit callback;
    private boolean inLimit;

    LockSpace(Object owner) {
        this.groups = new HashMap();
        this.owner = owner;
    }

    public Object getOwner() {
        return this.owner;
    }

    protected synchronized void addLock(Object group, Lock lock) throws StandardException {
        Lock lockInGroup = null;
        HashMap dl = (HashMap)this.groups.get(group);
        if (dl == null) {
            dl = this.getGroupMap(group);
        } else if (lock.getCount() != 1) {
            lockInGroup = (Lock)dl.get(lock);
        }
        if (lockInGroup == null) {
            lockInGroup = lock.copy();
            dl.put(lockInGroup, lockInGroup);
        }
        ++lockInGroup.count;
        if (this.inLimit) {
            return;
        }
        if (!group.equals(this.callbackGroup)) {
            return;
        }
        int groupSize = dl.size();
        if (groupSize > this.nextLimitCall) {
            this.inLimit = true;
            this.callback.reached(this, group, this.limit, new LockList(Collections.enumeration(dl.keySet())), groupSize);
            this.inLimit = false;
            int newGroupSize = dl.size();
            this.nextLimitCall = newGroupSize < this.limit / 2 ? this.limit : (newGroupSize < this.nextLimitCall / 2 ? (this.nextLimitCall -= this.limit) : (this.nextLimitCall += this.limit));
        }
    }

    synchronized void unlockGroup(LockTable lset, Object group) {
        HashMap dl = (HashMap)this.groups.remove(group);
        if (dl == null) {
            return;
        }
        Iterator list = dl.keySet().iterator();
        while (list.hasNext()) {
            lset.unlock((Lock)list.next(), 0);
        }
        if (this.callbackGroup != null && group.equals(this.callbackGroup)) {
            this.nextLimitCall = this.limit;
        }
        this.saveGroup(dl);
    }

    private HashMap getGroupMap(Object group) {
        HashMap[] sg = this.spareGroups;
        HashMap dl = null;
        for (int i = 0; i < 3; ++i) {
            dl = sg[i];
            if (dl == null) continue;
            sg[i] = null;
            break;
        }
        if (dl == null) {
            dl = new HashMap(5, 0.8f);
        }
        this.groups.put(group, dl);
        return dl;
    }

    private void saveGroup(HashMap dl) {
        HashMap[] sg = this.spareGroups;
        for (int i = 0; i < 3; ++i) {
            if (sg[i] != null) continue;
            sg[i] = dl;
            dl.clear();
            break;
        }
    }

    synchronized void unlockGroup(LockTable lset, Object group, Matchable key) {
        HashMap dl = (HashMap)this.groups.get(group);
        if (dl == null) {
            return;
        }
        boolean allUnlocked = true;
        Iterator e = dl.keySet().iterator();
        while (e.hasNext()) {
            Lock lock = (Lock)e.next();
            if (!key.match(lock.getLockable())) {
                allUnlocked = false;
                continue;
            }
            lset.unlock(lock, 0);
            e.remove();
        }
        if (allUnlocked) {
            this.groups.remove(group);
            this.saveGroup(dl);
            if (this.callbackGroup != null && group.equals(this.callbackGroup)) {
                this.nextLimitCall = this.limit;
            }
        }
    }

    synchronized void transfer(Object oldGroup, Object newGroup) {
        HashMap from = (HashMap)this.groups.get(oldGroup);
        if (from == null) {
            return;
        }
        HashMap to = (HashMap)this.groups.get(newGroup);
        if (to == null) {
            this.groups.put(newGroup, from);
            this.clearLimit(oldGroup);
            this.groups.remove(oldGroup);
            return;
        }
        if (to.size() < from.size()) {
            this.mergeGroups(to, from);
            HashMap oldTo = this.groups.put(newGroup, from);
            SanityManager.ASSERT(oldTo == to, "inconsistent state in LockSpace");
        } else {
            this.mergeGroups(from, to);
        }
        this.clearLimit(oldGroup);
        this.groups.remove(oldGroup);
    }

    private void mergeGroups(HashMap from, HashMap into) {
        Iterator e = from.keySet().iterator();
        while (e.hasNext()) {
            Object lock = e.next();
            Object lockI = into.get(lock);
            if (lockI == null) {
                into.put(lock, lock);
                continue;
            }
            Lock fromL = (Lock)lock;
            Lock intoL = (Lock)lockI;
            intoL.count += fromL.getCount();
        }
    }

    synchronized int unlockReference(LockTable lset, Lockable ref, Object qualifier, Object group) {
        HashMap dl = (HashMap)this.groups.get(group);
        if (dl == null) {
            return 0;
        }
        Lock lockInGroup = lset.unlockReference(this, ref, qualifier, dl);
        if (lockInGroup == null) {
            return 0;
        }
        if (lockInGroup.getCount() == 1) {
            if (dl.isEmpty()) {
                this.groups.remove(group);
                this.saveGroup(dl);
                if (this.callbackGroup != null && group.equals(this.callbackGroup)) {
                    this.nextLimitCall = this.limit;
                }
            }
            return 1;
        }
        --lockInGroup.count;
        dl.put(lockInGroup, lockInGroup);
        return 1;
    }

    synchronized boolean areLocksHeld(Object group) {
        return this.groups.containsKey(group);
    }

    synchronized boolean areLocksHeld() {
        return !this.groups.isEmpty();
    }

    synchronized boolean isLockHeld(Object group, Lockable ref, Object qualifier) {
        HashMap dl = (HashMap)this.groups.get(group);
        if (dl == null) {
            return false;
        }
        Object heldLock = dl.get(new Lock(this, ref, qualifier));
        return heldLock != null;
    }

    synchronized void setLimit(Object group, int limit, Limit callback) {
        this.callbackGroup = group;
        this.nextLimitCall = this.limit = limit;
        this.callback = callback;
    }

    synchronized void clearLimit(Object group) {
        if (group.equals(this.callbackGroup)) {
            this.callbackGroup = null;
            this.limit = Integer.MAX_VALUE;
            this.nextLimitCall = Integer.MAX_VALUE;
            this.callback = null;
        }
    }

    synchronized int deadlockCount(int bail) {
        int count = 0;
        Iterator it = this.groups.values().iterator();
        while (it.hasNext()) {
            HashMap group = (HashMap)it.next();
            Iterator locks = group.keySet().iterator();
            while (locks.hasNext()) {
                Lock lock = (Lock)locks.next();
                if ((count += lock.getCount()) <= bail) continue;
                return count;
            }
        }
        return count;
    }
}

