/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.diag.DiagnosticUtil;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.D_LockControl;
import org.apache.derby.impl.services.locks.Deadlock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.SinglePool;
import org.apache.derby.impl.services.locks.Timeout;

final class LockSet
implements LockTable {
    private final SinglePool factory;
    private final HashMap locks;
    private int deadlockTimeout = 20000;
    private int waitTimeout = 60000;
    private boolean deadlockTrace;
    private int blockCount;

    protected LockSet(SinglePool factory) {
        this.factory = factory;
        this.locks = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lockObject(CompatibilitySpace compatibilitySpace, Lockable ref, Object qualifier, int timeout) throws StandardException {
        int actualTimeout;
        Lock lockItem;
        LockControl control;
        if (SanityManager.DEBUG_ON("memoryLeakTrace") && this.locks.size() > 1000) {
            System.out.println("memoryLeakTrace:LockSet: " + this.locks.size());
        }
        String lockDebug = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control gc = this.getControl(ref);
            if (gc == null) {
                Lock gl = new Lock(compatibilitySpace, ref, qualifier);
                gl.grant();
                this.locks.put(ref, gl);
                return gl;
            }
            control = gc.getLockControl();
            if (control != gc) {
                this.locks.put(ref, control);
            }
            SanityManager.ASSERT(ref.equals(control.getLockable()));
            if (this.getControl(control.getLockable()) != control) {
                SanityManager.THROWASSERT("lockObject mismatched lock items " + this.getControl(control.getLockable()) + " " + control);
            }
            if ((lockItem = control.addLock(this, compatibilitySpace, qualifier)).getCount() != 0) {
                return lockItem;
            }
            if (timeout == 0) {
                control.giveUpWait(lockItem, this);
                if (SanityManager.DEBUG_ON("DeadlockTrace")) {
                    SanityManager.showTrace(new Throwable());
                    lockDebug = DiagnosticUtil.toDiagString(lockItem) + "\nCould not grant lock with zero timeout, here's the table" + this.toDebugString();
                }
                return null;
            }
        }
        boolean deadlockWait = false;
        if (timeout == -1) {
            deadlockWait = true;
            actualTimeout = this.deadlockTimeout;
            if (actualTimeout == -1) {
                actualTimeout = 20000;
            }
        } else {
            if (timeout == -2) {
                timeout = actualTimeout = this.waitTimeout;
            } else {
                actualTimeout = timeout;
            }
            if (this.deadlockTimeout >= 0) {
                if (actualTimeout < 0) {
                    deadlockWait = true;
                    actualTimeout = this.deadlockTimeout;
                } else if (this.deadlockTimeout < actualTimeout) {
                    deadlockWait = true;
                    actualTimeout = this.deadlockTimeout;
                    timeout -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock waitingLock = (ActiveLock)lockItem;
        lockItem = null;
        int earlyWakeupCount = 0;
        long startWaitTime = 0L;
        while (true) {
            byte wakeupReason = waitingLock.waitForGrant(actualTimeout);
            ActiveLock nextWaitingLock = null;
            Object[] deadlockData = null;
            try {
                boolean willQuitWait;
                Enumeration timeoutLockTable = null;
                long currentTime = 0L;
                LockSet lockSet2 = this;
                synchronized (lockSet2) {
                    block41: {
                        if (!control.isGrantable(control.firstWaiter() == waitingLock, compatibilitySpace, qualifier)) break block41;
                        control.grant(waitingLock);
                        nextWaitingLock = control.getNextWaiter(waitingLock, true, this);
                        ActiveLock activeLock = waitingLock;
                        return activeLock;
                    }
                    waitingLock.clearPotentiallyGranted();
                    boolean bl = willQuitWait = wakeupReason != 1;
                    if (wakeupReason == 0 && deadlockWait || wakeupReason == 2) {
                        deadlockData = Deadlock.look(this.factory, this, control, waitingLock, wakeupReason);
                        if (deadlockData == null) {
                            deadlockWait = false;
                            actualTimeout = timeout;
                            startWaitTime = 0L;
                            willQuitWait = false;
                        } else {
                            willQuitWait = true;
                        }
                    }
                    nextWaitingLock = control.getNextWaiter(waitingLock, willQuitWait, this);
                    if (willQuitWait) {
                        if (SanityManager.DEBUG_ON("DeadlockTrace")) {
                            SanityManager.showTrace(new Throwable());
                            lockDebug = DiagnosticUtil.toDiagString(waitingLock) + "\nGot deadlock/timeout, here's the table" + this.toDebugString();
                        }
                        if (this.deadlockTrace && deadlockData == null) {
                            currentTime = System.currentTimeMillis();
                            timeoutLockTable = this.factory.makeVirtualLockTable();
                        }
                    }
                }
                if (willQuitWait) {
                    if (lockDebug != null) {
                        String type = deadlockData != null ? "deadlock:" : "timeout:";
                        SanityManager.DEBUG_PRINT(type, "wait on lockitem caused " + type + lockDebug);
                    }
                    if (deadlockData == null) {
                        if (this.deadlockTrace) {
                            throw Timeout.buildException(waitingLock, timeoutLockTable, currentTime);
                        }
                        StandardException se = StandardException.newException("40XL1");
                        throw se;
                    }
                    throw Deadlock.buildException(this.factory, deadlockData);
                }
            }
            finally {
                if (nextWaitingLock != null) {
                    nextWaitingLock.wakeUp((byte)1);
                    nextWaitingLock = null;
                }
            }
            if (actualTimeout == -1) continue;
            if (wakeupReason != 0) {
                ++earlyWakeupCount;
            }
            if (earlyWakeupCount <= 5) continue;
            long now = System.currentTimeMillis();
            if (startWaitTime != 0L) {
                long sleepTime = now - startWaitTime;
                actualTimeout = (int)((long)actualTimeout - sleepTime);
            }
            startWaitTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Latch item, int unlockCount) {
        if (SanityManager.DEBUG_ON("LockTrace")) {
            SanityManager.DEBUG("LockTrace", "Release lock: " + DiagnosticUtil.toDiagString(item));
        }
        boolean tryGrant = false;
        ActiveLock nextGrant = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control control = this.getControl(item.getLockable());
            if (item.getLockable() == null) {
                SanityManager.THROWASSERT("item.getLockable() = null.unlockCount " + unlockCount + "item = " + DiagnosticUtil.toDiagString(item));
            }
            if (control == null) {
                SanityManager.THROWASSERT("control = null.unlockCount " + unlockCount + "item = " + DiagnosticUtil.toDiagString(item));
            }
            if (this.getControl(control.getLockable()) != control) {
                SanityManager.THROWASSERT("unlock mismatched lock items " + this.getControl(control.getLockable()) + " " + control);
            }
            if (unlockCount != 0 && unlockCount > item.getCount()) {
                SanityManager.THROWASSERT("unlockCount " + unlockCount + " larger than actual lock count " + item.getCount() + " item " + item);
            }
            tryGrant = control.unlock(item, unlockCount);
            item = null;
            boolean mayBeEmpty = true;
            if (tryGrant && (nextGrant = control.firstWaiter()) != null) {
                mayBeEmpty = false;
                if (!nextGrant.setPotentiallyGranted()) {
                    nextGrant = null;
                }
            }
            if (mayBeEmpty) {
                if (control.isEmpty()) {
                    this.locks.remove(control.getLockable());
                }
                return;
            }
        }
        if (tryGrant && nextGrant != null) {
            nextGrant.wakeUp((byte)1);
        }
    }

    public synchronized Lock unlockReference(CompatibilitySpace space, Lockable ref, Object qualifier, Map group) {
        Control control = this.getControl(ref);
        if (control == null) {
            return null;
        }
        Lock setLock = control.getLock(space, qualifier);
        if (setLock == null) {
            return null;
        }
        Lock lockInGroup = (Lock)group.remove(setLock);
        if (lockInGroup != null) {
            this.unlock(lockInGroup, 1);
        }
        return lockInGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zeroDurationLockObject(CompatibilitySpace space, Lockable ref, Object qualifier, int timeout) throws StandardException {
        Object t;
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Zero Duration Lock Request before Grant: ", space, null, ref, qualifier, timeout);
            if (SanityManager.DEBUG_ON("LockStackTrace")) {
                t = new Throwable();
                PrintWriter istream = SanityManager.GET_DEBUG_STREAM();
                istream.println("Stack trace of lock request:");
                ((Throwable)t).printStackTrace(istream);
            }
        }
        t = this;
        synchronized (t) {
            Control control = this.getControl(ref);
            if (control == null) {
                return true;
            }
            if (control.isGrantable(true, space, qualifier)) {
                return true;
            }
            if (timeout == 0) {
                return false;
            }
        }
        Lock lock = this.lockObject(space, ref, qualifier, timeout);
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Zero Lock Request Granted: ", space, null, ref, qualifier, timeout);
        }
        this.unlock(lock, 1);
        return true;
    }

    public void setDeadlockTimeout(int timeout) {
        this.deadlockTimeout = timeout;
    }

    public void setWaitTimeout(int timeout) {
        this.waitTimeout = timeout;
    }

    public void setDeadlockTrace(boolean val) {
        this.deadlockTrace = val;
    }

    public String toDebugString() {
        String str = new String();
        int i = 0;
        Iterator it = this.locks.values().iterator();
        while (it.hasNext()) {
            str = str + "\n  lock[" + i + "]: " + DiagnosticUtil.toDiagString(it.next());
        }
        return str;
    }

    public void addWaiters(Map waiters) {
        Iterator it = this.locks.values().iterator();
        while (it.hasNext()) {
            Control control = (Control)it.next();
            control.addWaiters(waiters);
        }
    }

    public synchronized Map shallowClone() {
        HashMap<Lockable, Control> clone = new HashMap<Lockable, Control>();
        Iterator it = this.locks.keySet().iterator();
        while (it.hasNext()) {
            Lockable lockable = (Lockable)it.next();
            Control control = this.getControl(lockable);
            clone.put(lockable, control.shallowClone());
        }
        return clone;
    }

    public void oneMoreWaiter() {
        ++this.blockCount;
    }

    public void oneLessWaiter() {
        --this.blockCount;
    }

    public synchronized boolean anyoneBlocked() {
        SanityManager.ASSERT(this.blockCount >= 0, "blockCount should not be negative");
        return this.blockCount != 0;
    }

    private final Control getControl(Lockable ref) {
        return (Control)this.locks.get(ref);
    }
}

