/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.D_LockControl;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.LockTableVTI;

abstract class AbstractPool
implements LockFactory {
    protected final LockTable lockTable = this.createLockTable();
    int deadlockMonitor;

    protected AbstractPool() {
    }

    protected abstract LockTable createLockTable();

    public boolean lockObject(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier, int timeout) throws StandardException {
        Lock lock;
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Lock Request before Grant: ", compatibilitySpace, group, ref, qualifier, timeout);
            if (SanityManager.DEBUG_ON("LockStackTrace")) {
                Throwable t = new Throwable();
                PrintWriter istream = SanityManager.GET_DEBUG_STREAM();
                istream.println("Stack trace of lock request:");
                t.printStackTrace(istream);
            }
        }
        if ((lock = this.lockTable.lockObject(compatibilitySpace, ref, qualifier, timeout)) == null) {
            SanityManager.ASSERT(timeout == 0, "timeout not NO_WAIT");
            return false;
        }
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Lock Request Granted: ", compatibilitySpace, group, ref, qualifier, timeout);
        }
        ((LockSpace)compatibilitySpace).addLock(group, lock);
        return true;
    }

    public CompatibilitySpace createCompatibilitySpace(Object owner) {
        return new LockSpace(owner);
    }

    public int unlock(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier) {
        int count;
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Lock Unlock: ", compatibilitySpace, group, ref, qualifier, -1);
        }
        SanityManager.ASSERT((count = ((LockSpace)compatibilitySpace).unlockReference(this.lockTable, ref, qualifier, group)) == 0 || count == 1, "count = " + count);
        return count;
    }

    public void unlockGroup(CompatibilitySpace compatibilitySpace, Object group) {
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Lock Unlock Group: ", compatibilitySpace, group);
        }
        ((LockSpace)compatibilitySpace).unlockGroup(this.lockTable, group);
    }

    public void unlockGroup(CompatibilitySpace compatibilitySpace, Object group, Matchable key) {
        if (SanityManager.DEBUG_ON("LockTrace")) {
            D_LockControl.debugLock("Lock Unlock Group: ", compatibilitySpace, group);
        }
        ((LockSpace)compatibilitySpace).unlockGroup(this.lockTable, group, key);
    }

    public void transfer(CompatibilitySpace compatibilitySpace, Object oldGroup, Object newGroup) {
        if (SanityManager.DEBUG_ON("LockTrace")) {
            StringBuffer sb = new StringBuffer("Lock Transfer:");
            D_LockControl.debugAppendObject(sb, " CompatibilitySpace=", compatibilitySpace);
            D_LockControl.debugAppendObject(sb, " Old Group=", oldGroup);
            D_LockControl.debugAppendObject(sb, " New Group=", newGroup);
            D_LockControl.debugAddThreadInfo(sb);
            SanityManager.DEBUG("LockTrace", sb.toString());
        }
        ((LockSpace)compatibilitySpace).transfer(oldGroup, newGroup);
    }

    public boolean anyoneBlocked() {
        return this.lockTable.anyoneBlocked();
    }

    public boolean areLocksHeld(CompatibilitySpace compatibilitySpace, Object group) {
        return ((LockSpace)compatibilitySpace).areLocksHeld(group);
    }

    public boolean areLocksHeld(CompatibilitySpace compatibilitySpace) {
        return ((LockSpace)compatibilitySpace).areLocksHeld();
    }

    public boolean zeroDurationlockObject(CompatibilitySpace compatibilitySpace, Lockable ref, Object qualifier, int timeout) throws StandardException {
        return this.lockTable.zeroDurationLockObject(compatibilitySpace, ref, qualifier, timeout);
    }

    public boolean isLockHeld(CompatibilitySpace compatibilitySpace, Object group, Lockable ref, Object qualifier) {
        return ((LockSpace)compatibilitySpace).isLockHeld(group, ref, qualifier);
    }

    public void setLimit(CompatibilitySpace compatibilitySpace, Object group, int limit, Limit callback) {
        ((LockSpace)compatibilitySpace).setLimit(group, limit, callback);
    }

    public void clearLimit(CompatibilitySpace compatibilitySpace, Object group) {
        ((LockSpace)compatibilitySpace).clearLimit(group);
    }

    public Enumeration makeVirtualLockTable() {
        LockTableVTI myclone = new LockTableVTI(this.lockTable.shallowClone());
        return myclone;
    }

    public void init(boolean dbOnly, Dictionary p) {
        this.getAndApply(dbOnly, p, "derby.locks.deadlockTimeout");
        this.getAndApply(dbOnly, p, "derby.locks.waitTimeout");
        this.getAndApply(dbOnly, p, "derby.locks.monitor");
        this.getAndApply(dbOnly, p, "derby.locks.deadlockTrace");
    }

    private void getAndApply(boolean dbOnly, Dictionary p, String key) {
        try {
            String value = (String)((Object)PropertyUtil.getPropertyFromSet(dbOnly, p, key));
            if (value != null) {
                this.validate(key, (Serializable)((Object)value), p);
                this.apply(key, (Serializable)((Object)value), p);
            }
        }
        catch (StandardException se) {
            // empty catch block
        }
    }

    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.startsWith("derby.locks.")) {
            return false;
        }
        if (value != null) {
            if (key.equals("derby.locks.deadlockTimeout")) {
                AbstractPool.getWaitValue((String)((Object)value), 20);
            } else if (key.equals("derby.locks.waitTimeout")) {
                AbstractPool.getWaitValue((String)((Object)value), 60);
            } else if (key.equals("derby.locks.monitor")) {
                PropertyUtil.booleanProperty("derby.locks.monitor", value, false);
            } else if (key.equals("derby.locks.deadlockTrace")) {
                PropertyUtil.booleanProperty("derby.locks.deadlockTrace", value, false);
            }
        }
        return true;
    }

    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if (value == null) {
            value = PropertyUtil.getPropertyFromSet(p, key);
        }
        String svalue = (String)((Object)value);
        if (key.equals("derby.locks.deadlockTimeout")) {
            this.lockTable.setDeadlockTimeout(AbstractPool.getWaitValue(svalue, 20));
        } else if (key.equals("derby.locks.waitTimeout")) {
            this.lockTable.setWaitTimeout(AbstractPool.getWaitValue(svalue, 60));
        } else if (key.equals("derby.locks.monitor")) {
            this.deadlockMonitor = PropertyUtil.booleanProperty("derby.locks.monitor", (Serializable)((Object)svalue), false) ? 2 : 0;
        } else if (key.equals("derby.locks.deadlockTrace")) {
            this.lockTable.setDeadlockTrace(PropertyUtil.booleanProperty("derby.locks.deadlockTrace", (Serializable)((Object)svalue), false));
        }
        return null;
    }

    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    private static int getWaitValue(String value, int defaultValue) {
        int wait = PropertyUtil.handleInt(value, Integer.MIN_VALUE, 2147483, defaultValue);
        wait = wait < 0 ? -1 : (wait *= 1000);
        return wait;
    }
}

