/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.cache.SizedCacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.iapi.util.Operator;
import org.apache.derby.impl.services.cache.CacheStat;
import org.apache.derby.impl.services.cache.CachedItem;
import org.apache.derby.impl.services.cache.ClockFactory;

final class Clock
implements CacheManager,
Serviceable {
    private final CacheStat stat;
    private final HashMap cache_;
    private DaemonService cleaner;
    private final ArrayList holders;
    private int validItemCount = 0;
    private long maximumSize;
    private boolean useByteCount;
    private long currentByteCount = 0L;
    private static final int ITEM_OVERHEAD = ClassSize.estimateBaseFromCatalog(CachedItem.class) + ClassSize.getRefSize() + ClassSize.estimateHashEntrySize();
    private final CacheableFactory holderFactory;
    private boolean active;
    private String name;
    private int clockHand;
    private int myClientNumber;
    private boolean wokenToClean;
    private boolean cleanerRunning;
    private boolean needService;
    private int trimRequests = 0;

    Clock(CacheableFactory holderFactory, String name, int initialSize, long maximumSize, boolean useByteCount) {
        this.cache_ = new HashMap(initialSize, 0.95f);
        this.maximumSize = maximumSize;
        this.holderFactory = holderFactory;
        this.useByteCount = useByteCount;
        if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
            SanityManager.DEBUG(ClockFactory.CacheTrace, "initializing " + name + " cache to size " + initialSize);
        }
        this.holders = new ArrayList(initialSize);
        this.name = name;
        this.active = true;
        this.stat = new CacheStat();
        this.stat.initialSize = initialSize;
        this.stat.maxSize = maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable find(Object key) throws StandardException {
        Cacheable entry;
        while (true) {
            CachedItem item;
            boolean add = false;
            Clock clock = this;
            synchronized (clock) {
                if (!this.active) {
                    return null;
                }
                item = (CachedItem)this.cache_.get(key);
                if (item != null) {
                    item.keepAfterSearch();
                    ++this.stat.findHit;
                    if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                        SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + ": Found key " + key + " already in cache, item " + item);
                    }
                }
            }
            if (item == null) {
                item = this.findFreeItem();
                ++this.stat.findMiss;
                if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                    SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + ": Find key " + key + " Not in cache, get free item " + item);
                }
                SanityManager.ASSERT(item != null, "found null item");
                clock = this;
                synchronized (clock) {
                    CachedItem inCacheItem = (CachedItem)this.cache_.get(key);
                    if (inCacheItem != null) {
                        item.unkeepForCreate();
                        item = inCacheItem;
                        item.keepAfterSearch();
                    } else {
                        this.cache_.put(key, item);
                        add = true;
                        if (SanityManager.DEBUG_ON("memoryLeakTrace") && (long)this.cache_.size() > 11L * this.maximumSize / 10L) {
                            System.out.println("memoryLeakTrace:Cache:" + this.name + " " + this.cache_.size());
                        }
                    }
                }
            }
            if (add) {
                if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                    SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " Added " + key + " to cache, item " + item);
                }
                ++this.stat.findFault;
                return this.addEntry(item, key, false, null);
            }
            entry = item.use();
            if (entry != null) break;
            Clock clock2 = this;
            synchronized (clock2) {
                item.unkeep();
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable findCached(Object key) throws StandardException {
        CachedItem item;
        Clock clock = this;
        synchronized (clock) {
            if (!this.active) {
                return null;
            }
            item = (CachedItem)this.cache_.get(key);
            if (item == null) {
                ++this.stat.findCachedMiss;
                return null;
            }
            ++this.stat.findCachedHit;
            item.keepAfterSearch();
        }
        Cacheable entry = item.use();
        if (entry == null) {
            Clock clock2 = this;
            synchronized (clock2) {
                item.unkeep();
            }
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsed(Object[] keys) {
        int i = 0;
        while (i < keys.length) {
            Clock clock = this;
            synchronized (clock) {
                if (!this.active) {
                    return;
                }
                int endIdx = i + 32;
                if (endIdx > keys.length) {
                    endIdx = keys.length;
                }
                while (i < endIdx) {
                    if (keys[i] == null) {
                        return;
                    }
                    CachedItem item = (CachedItem)this.cache_.get(keys[i]);
                    if (null != item) {
                        item.setUsed(true);
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable create(Object key, Object createParameter) throws StandardException {
        CachedItem item = this.findFreeItem();
        ++this.stat.create;
        Clock clock = this;
        synchronized (clock) {
            if (!this.active) {
                return null;
            }
            if (this.cache_.get(key) != null) {
                item.unkeepForCreate();
                throw StandardException.newException("XBCA0.S", (Object)this.name, key);
            }
            this.cache_.put(key, item);
            if (SanityManager.DEBUG_ON("memoryLeakTrace") && (long)this.cache_.size() > 11L * this.maximumSize / 10L) {
                System.out.println("memoryLeakTrace:Cache:" + this.name + " " + this.cache_.size());
            }
        }
        Cacheable entry = this.addEntry(item, key, true, createParameter);
        if (entry != null) {
            SanityManager.ASSERT(item.getEntry() == entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Cacheable entry) {
        boolean removeItem;
        CachedItem item;
        long toShrink = 0L;
        Clock clock = this;
        synchronized (clock) {
            item = (CachedItem)this.cache_.get(entry.getIdentity());
            SanityManager.ASSERT(item != null, "item null");
            SanityManager.ASSERT(item.getEntry() == entry, "entry not equals keyed entry");
            SanityManager.ASSERT(item.isKept(), "item is not kept in release(Cachable)");
            removeItem = item.unkeep();
            if (removeItem) {
                this.cache_.remove(entry.getIdentity());
                item.keepForClean();
            }
            if (this.cleaner == null) {
                toShrink = this.shrinkSize(this.getCurrentSizeNoSync());
            }
        }
        if (removeItem) {
            item.notifyRemover();
        }
        if (toShrink > 0L) {
            this.performWork(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(CachedItem item) {
        boolean removeItem;
        Clock clock = this;
        synchronized (clock) {
            SanityManager.ASSERT(item.isKept(), "item is not kept in released(CachedItem)");
            removeItem = item.unkeep();
            if (removeItem) {
                this.cache_.remove(item.getEntry().getIdentity());
                item.keepForClean();
            }
        }
        if (removeItem) {
            item.notifyRemover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Cacheable entry) throws StandardException {
        boolean removeNow;
        CachedItem item;
        long origItemSize = 0L;
        ++this.stat.remove;
        Clock clock = this;
        synchronized (clock) {
            item = (CachedItem)this.cache_.get(entry.getIdentity());
            SanityManager.ASSERT(item != null);
            SanityManager.ASSERT(item.getEntry() == entry);
            SanityManager.ASSERT(item.isKept());
            if (this.useByteCount) {
                origItemSize = this.getItemSize(item);
            }
            item.setRemoveState();
            removeNow = item.unkeep();
            if (removeNow) {
                this.cache_.remove(entry.getIdentity());
                item.keepForClean();
            }
        }
        try {
            item.remove(removeNow);
        }
        finally {
            clock = this;
            synchronized (clock) {
                item.unkeep();
                item.setValidState(false);
                --this.validItemCount;
                item.getEntry().clearIdentity();
                if (this.useByteCount) {
                    this.currentByteCount += (long)this.getItemSize(item) - origItemSize;
                }
            }
        }
    }

    public void cleanAll() throws StandardException {
        ++this.stat.cleanAll;
        this.cleanCache(null);
    }

    public void clean(Matchable partialKey) throws StandardException {
        this.cleanCache(partialKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ageOut() {
        ++this.stat.ageOut;
        Clock clock = this;
        synchronized (clock) {
            int size = this.holders.size();
            long toShrink = this.shrinkSize(this.getCurrentSizeNoSync());
            boolean shrunk = false;
            for (int position = 0; position < size; ++position) {
                CachedItem item = (CachedItem)this.holders.get(position);
                if (item.isKept() || !item.isValid() || item.getEntry().isDirty()) continue;
                long itemSize = this.removeIdentity(item);
                if (toShrink <= 0L) continue;
                if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                    SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " shrinking item " + item + " at position " + position);
                }
                toShrink -= itemSize;
                shrunk = true;
            }
            if (shrunk) {
                this.trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws StandardException {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe(this.myClientNumber);
            this.cleaner = null;
        }
        Clock clock = this;
        synchronized (clock) {
            this.active = false;
        }
        this.ageOut();
        this.cleanAll();
        this.ageOut();
    }

    public void useDaemonService(DaemonService daemon) {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe(this.myClientNumber);
        }
        this.cleaner = daemon;
        this.myClientNumber = this.cleaner.subscribe(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discard(Matchable partialKey) {
        boolean noMisses = true;
        Clock clock = this;
        synchronized (clock) {
            int size = this.holders.size();
            long toShrink = this.shrinkSize(this.getCurrentSizeNoSync());
            boolean shrunk = false;
            for (int position = 0; position < size; ++position) {
                CachedItem item = (CachedItem)this.holders.get(position);
                if (!item.isValid()) continue;
                Object key = item.getEntry().getIdentity();
                if (partialKey != null && !partialKey.match(key)) continue;
                if (item.isKept()) {
                    noMisses = false;
                    continue;
                }
                long itemSize = this.removeIdentity(item);
                if (toShrink <= 0L) continue;
                if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                    SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " shrinking item " + item + " at position " + position);
                }
                toShrink -= itemSize;
                shrunk = true;
            }
            if (shrunk) {
                this.trimToSize();
            }
        }
        return noMisses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cacheable addEntry(CachedItem item, Object key, boolean forCreate, Object createParameter) throws StandardException {
        boolean notifyWaiters2;
        Clock clock;
        Cacheable entry = null;
        long origEntrySize = 0L;
        if (this.useByteCount) {
            origEntrySize = this.getItemSize(item);
        }
        try {
            if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " item " + item + " take on identity " + key);
            }
            entry = item.takeOnIdentity(this, this.holderFactory, key, forCreate, createParameter);
            Object var9_7 = null;
            clock = this;
        }
        catch (Throwable throwable) {
            boolean notifyWaiters2;
            Object var9_8 = null;
            Clock clock2 = this;
            synchronized (clock2) {
                Object removed = this.cache_.remove(key);
                SanityManager.ASSERT(removed == item);
                if (entry != null) {
                    this.cache_.put(entry.getIdentity(), item);
                    if (this.useByteCount) {
                        this.currentByteCount += (long)((SizedCacheable)entry).getSize() - origEntrySize;
                    }
                    item.setValidState(true);
                    ++this.validItemCount;
                    notifyWaiters2 = true;
                } else {
                    item.unkeep();
                    notifyWaiters2 = item.isKept();
                }
            }
            if (notifyWaiters2) {
                item.settingIdentityComplete();
            }
            throw throwable;
        }
        synchronized (clock) {
            Object removed = this.cache_.remove(key);
            SanityManager.ASSERT(removed == item);
            if (entry != null) {
                this.cache_.put(entry.getIdentity(), item);
                if (this.useByteCount) {
                    this.currentByteCount += (long)((SizedCacheable)entry).getSize() - origEntrySize;
                }
                item.setValidState(true);
                ++this.validItemCount;
                notifyWaiters2 = true;
            } else {
                item.unkeep();
                notifyWaiters2 = item.isKept();
            }
        }
        if (notifyWaiters2) {
            item.settingIdentityComplete();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedItem findFreeItem() throws StandardException {
        CachedItem item;
        long currentSize = this.getCurrentSize();
        if (currentSize >= this.maximumSize && (item = this.rotateClock(0.2f)) != null) {
            return item;
        }
        if (this.validItemCount < this.holders.size()) {
            Clock clock = this;
            synchronized (clock) {
                int invalidItems = this.holders.size() - this.validItemCount;
                for (int i = this.holders.size() - 1; invalidItems > 0 && i >= 0; --i) {
                    CachedItem item2 = (CachedItem)this.holders.get(i);
                    if (item2.isKept()) {
                        if (item2.isValid()) continue;
                        --invalidItems;
                        continue;
                    }
                    if (item2.isValid()) continue;
                    item2.keepForCreate();
                    return item2;
                }
            }
        }
        return this.growCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedItem rotateClock(float percentOfClock) throws StandardException {
        CachedItem cachedItem;
        int evictions = 0;
        int cleaned = 0;
        int resetUsed = 0;
        int iskept = 0;
        CachedItem availableItem = null;
        boolean kickCleaner = false;
        try {
            int itemCount = this.holders.size();
            int itemsToCheck = itemCount < 20 ? 2 * itemCount : (int)((float)itemCount * percentOfClock);
            long toShrink = this.shrinkSize(this.getCurrentSize());
            while (itemsToCheck > 0) {
                CachedItem item = null;
                Clock clock = this;
                synchronized (clock) {
                    if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                        SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " rotateClock starting " + this.clockHand + " itemsToCheck " + itemsToCheck);
                    }
                    int size = this.holders.size();
                    while (itemsToCheck > 0) {
                        block48: {
                            if (this.clockHand >= size) {
                                if (size == 0) break;
                                this.clockHand = 0;
                            }
                            if ((item = (CachedItem)this.holders.get(this.clockHand)).isKept()) {
                                ++iskept;
                            } else if (!item.isValid()) {
                                if (null == availableItem) {
                                    if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                        SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " found free item at " + this.clockHand + " item " + item);
                                    }
                                    item.keepForCreate();
                                    if (this.useByteCount && this.getCurrentSizeNoSync() > this.maximumSize) {
                                        availableItem = item;
                                    } else {
                                        this.incrClockHand();
                                        CachedItem cachedItem2 = item;
                                        // MONITOREXIT @DISABLED, blocks:[0, 32, 7, 11, 43, 12, 45, 46] lbl36 : MonitorExitStatement: MONITOREXIT : var13_12
                                        Object var21_17 = null;
                                        if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                            SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evictions " + evictions + ", cleaned " + cleaned + ", resetUsed " + resetUsed + ", isKept " + iskept + ", size " + this.holders.size());
                                        }
                                        if (!kickCleaner) return cachedItem2;
                                        if (this.cleaner == null) return cachedItem2;
                                        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                                            SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + " client # " + this.myClientNumber + " calling cleaner ");
                                        }
                                        this.cleaner.serviceNow(this.myClientNumber);
                                        if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) return cachedItem2;
                                        SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + Thread.currentThread().getName() + " cleaner called");
                                        return cachedItem2;
                                    }
                                }
                            } else if (item.recentlyUsed()) {
                                ++resetUsed;
                                item.setUsed(false);
                            } else {
                                if (toShrink > 0L && !this.cleanerRunning) {
                                    kickCleaner = true;
                                    this.cleanerRunning = true;
                                    this.needService = true;
                                }
                                ++evictions;
                                if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                    SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evicting item at " + this.clockHand + " item " + item);
                                }
                                if (!item.getEntry().isDirty()) {
                                    if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                        SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " Evicting Item " + item + ", not dirty");
                                    }
                                    long itemSize = this.removeIdentity(item);
                                    if (this.useByteCount && this.getCurrentSizeNoSync() > this.maximumSize && 0L < (toShrink -= itemSize)) {
                                        if (null == availableItem) {
                                            item.keepForCreate();
                                            availableItem = item;
                                        }
                                        break block48;
                                    } else {
                                        this.incrClockHand();
                                        if (null != availableItem) {
                                            CachedItem cachedItem3 = availableItem;
                                            // MONITOREXIT @DISABLED, blocks:[0, 38, 7, 40, 41, 26, 11, 44, 12, 46] lbl73 : MonitorExitStatement: MONITOREXIT : var13_12
                                            Object var21_18 = null;
                                            if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                                SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evictions " + evictions + ", cleaned " + cleaned + ", resetUsed " + resetUsed + ", isKept " + iskept + ", size " + this.holders.size());
                                            }
                                            if (!kickCleaner) return cachedItem3;
                                            if (this.cleaner == null) return cachedItem3;
                                            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                                                SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + " client # " + this.myClientNumber + " calling cleaner ");
                                            }
                                            this.cleaner.serviceNow(this.myClientNumber);
                                            if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) return cachedItem3;
                                            SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + Thread.currentThread().getName() + " cleaner called");
                                            return cachedItem3;
                                        }
                                        item.keepForCreate();
                                        CachedItem cachedItem4 = item;
                                        // MONITOREXIT @DISABLED, blocks:[0, 38, 7, 40, 41, 11, 44, 12, 46] lbl88 : MonitorExitStatement: MONITOREXIT : var13_12
                                        Object var21_19 = null;
                                        if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                            SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evictions " + evictions + ", cleaned " + cleaned + ", resetUsed " + resetUsed + ", isKept " + iskept + ", size " + this.holders.size());
                                        }
                                        if (!kickCleaner) return cachedItem4;
                                        if (this.cleaner == null) return cachedItem4;
                                        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                                            SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + " client # " + this.myClientNumber + " calling cleaner ");
                                        }
                                        this.cleaner.serviceNow(this.myClientNumber);
                                        if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) return cachedItem4;
                                        SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + Thread.currentThread().getName() + " cleaner called");
                                        return cachedItem4;
                                    }
                                }
                                if (this.cleaner != null && !this.cleanerRunning) {
                                    kickCleaner = true;
                                    this.wokenToClean = true;
                                    this.cleanerRunning = true;
                                }
                                item.keepForClean();
                                break;
                            }
                        }
                        item = null;
                        --itemsToCheck;
                        this.incrClockHand();
                    }
                    if (item == null) {
                        CachedItem cachedItem5 = availableItem;
                        // MONITOREXIT @DISABLED, blocks:[0, 20, 7, 11] lbl114 : MonitorExitStatement: MONITOREXIT : var13_12
                        Object var21_20 = null;
                        if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                            SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evictions " + evictions + ", cleaned " + cleaned + ", resetUsed " + resetUsed + ", isKept " + iskept + ", size " + this.holders.size());
                        }
                        if (!kickCleaner) return cachedItem5;
                        if (this.cleaner == null) return cachedItem5;
                        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                            SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + " client # " + this.myClientNumber + " calling cleaner ");
                        }
                        this.cleaner.serviceNow(this.myClientNumber);
                        if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) return cachedItem5;
                        SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + Thread.currentThread().getName() + " cleaner called");
                        return cachedItem5;
                    }
                }
                try {
                    if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                        SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " cleaning item " + item);
                    }
                    item.clean(false);
                    ++cleaned;
                }
                finally {
                    this.release(item);
                    item = null;
                }
            }
            cachedItem = availableItem;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evictions " + evictions + ", cleaned " + cleaned + ", resetUsed " + resetUsed + ", isKept " + iskept + ", size " + this.holders.size());
            }
            if (!kickCleaner) throw throwable;
            if (this.cleaner == null) throw throwable;
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + " client # " + this.myClientNumber + " calling cleaner ");
            }
            this.cleaner.serviceNow(this.myClientNumber);
            if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) throw throwable;
            SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + Thread.currentThread().getName() + " cleaner called");
            throw throwable;
        }
        Object var21_21 = null;
        if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
            SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " evictions " + evictions + ", cleaned " + cleaned + ", resetUsed " + resetUsed + ", isKept " + iskept + ", size " + this.holders.size());
        }
        if (!kickCleaner) return cachedItem;
        if (this.cleaner == null) return cachedItem;
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + " client # " + this.myClientNumber + " calling cleaner ");
        }
        this.cleaner.serviceNow(this.myClientNumber);
        if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) return cachedItem;
        SanityManager.DEBUG(DaemonService.DaemonTrace, this.name + Thread.currentThread().getName() + " cleaner called");
        return cachedItem;
    }

    private int incrClockHand() {
        if (++this.clockHand >= this.holders.size()) {
            this.clockHand = 0;
        }
        return this.clockHand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performWork(ContextManager contextMgr) {
        int ret = this.performWork(false);
        Clock clock = this;
        synchronized (clock) {
            this.cleanerRunning = false;
        }
        return ret;
    }

    public boolean serviceASAP() {
        return this.needService;
    }

    public boolean serviceImmediately() {
        return false;
    }

    public synchronized int getNumberInUse() {
        int size = this.holders.size();
        int inUse = 0;
        for (int position = 0; position < size; ++position) {
            CachedItem item = (CachedItem)this.holders.get(position);
            if (!item.isValid()) continue;
            ++inUse;
        }
        return inUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedItem growCache() {
        CachedItem item = new CachedItem();
        item.keepForCreate();
        Clock clock = this;
        synchronized (clock) {
            this.holders.add(item);
        }
        return item;
    }

    private long removeIdentity(CachedItem item) {
        long shrink = 1L;
        SanityManager.ASSERT(!item.isKept(), "item is kept");
        SanityManager.ASSERT(item.isValid(), "item is not valid");
        if (this.useByteCount) {
            shrink = ((SizedCacheable)item.getEntry()).getSize();
        }
        this.cache_.remove(item.getEntry().getIdentity());
        item.setValidState(false);
        --this.validItemCount;
        item.getEntry().clearIdentity();
        if (this.useByteCount) {
            this.currentByteCount -= (shrink -= (long)((SizedCacheable)item.getEntry()).getSize());
        }
        return shrink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCache(Matchable partialKey) throws StandardException {
        int position;
        Clock clock = this;
        synchronized (clock) {
            position = this.holders.size() - 1;
        }
        while (true) {
            CachedItem item = null;
            Clock clock2 = this;
            synchronized (clock2) {
                int size = this.holders.size();
                if (position >= size) {
                    position = size - 1;
                }
                while (position >= 0) {
                    Object key;
                    item = (CachedItem)this.holders.get(position);
                    if (item.isValid() && item.getEntry().isDirty() && (partialKey == null || partialKey.match(key = item.getEntry().getIdentity()))) {
                        item.keepForClean();
                        break;
                    }
                    --position;
                    item = null;
                }
            }
            if (position < 0) {
                return;
            }
            try {
                item.clean(false);
            }
            finally {
                this.release(item);
            }
            --position;
        }
    }

    private long shrinkSize(long currentSize) {
        long maxSize = this.getMaximumSize();
        long toShrink = currentSize - maxSize;
        if (toShrink <= 0L) {
            return 0L;
        }
        long shrinkLimit = maxSize / 10L;
        if (shrinkLimit == 0L) {
            shrinkLimit = 2L;
        }
        if (toShrink < shrinkLimit) {
            return toShrink;
        }
        return shrinkLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performWork(boolean shrinkOnly) {
        int maxLooks;
        long toShrink;
        long target;
        Clock clock = this;
        synchronized (clock) {
            if (!this.active) {
                this.needService = false;
                return 1;
            }
            long currentSize = this.getCurrentSizeNoSync();
            target = currentSize / 20L;
            long l = toShrink = this.wokenToClean ? 0L : this.shrinkSize(currentSize);
            if (target == 0L) {
                this.wokenToClean = false;
                this.needService = false;
                return 1;
            }
            if (!this.wokenToClean && toShrink <= 0L) {
                this.needService = false;
                return 1;
            }
            maxLooks = this.useByteCount ? this.holders.size() / 10 : (int)(target * 2L);
        }
        long clean = 0L;
        int cleaned = 0;
        CachedItem item = null;
        int currentPosition = 0;
        String ThreadName = null;
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            ThreadName = Thread.currentThread().getName();
            SanityManager.DEBUG(DaemonService.DaemonTrace, ThreadName + " Cleaning " + this.name + " clientNumber " + this.myClientNumber);
        }
        Clock clock2 = this;
        synchronized (clock2) {
            int itemCount = this.holders.size();
            currentPosition = this.clockHand;
            boolean shrunk = false;
            long currentSize = this.getCurrentSizeNoSync();
            while (shrinkOnly ? currentSize > this.maximumSize && toShrink > 0L : clean < target) {
                if (++currentPosition >= itemCount) {
                    if (itemCount == 0) break;
                    currentPosition = 0;
                }
                if (maxLooks-- <= 0) {
                    if (!SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) break;
                    SanityManager.DEBUG(DaemonService.DaemonTrace, ThreadName + " done one round of " + this.name);
                    break;
                }
                item = (CachedItem)this.holders.get(currentPosition);
                if (!item.isKept()) {
                    if (!item.isValid()) {
                        if (toShrink > 0L) {
                            if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " shrinking item " + item + " at position " + currentPosition);
                            }
                            toShrink -= currentSize;
                            this.holders.remove(currentPosition);
                            if (this.useByteCount) {
                                this.currentByteCount -= (long)this.getItemSize(item);
                            }
                            currentSize = this.getCurrentSizeNoSync();
                            toShrink += currentSize;
                            --itemCount;
                            --currentPosition;
                            shrunk = true;
                        }
                    } else if (!item.recentlyUsed()) {
                        int itemSize = this.getItemSize(item);
                        clean += (long)itemSize;
                        if (!item.getEntry().isDirty()) {
                            if (toShrink > 0L) {
                                if (SanityManager.DEBUG_ON(ClockFactory.CacheTrace)) {
                                    SanityManager.DEBUG(ClockFactory.CacheTrace, this.name + " shrinking item " + item + " at position " + currentPosition);
                                }
                                toShrink -= currentSize;
                                this.removeIdentity(item);
                                this.holders.remove(currentPosition);
                                if (this.useByteCount) {
                                    this.currentByteCount -= (long)this.getItemSize(item);
                                }
                                currentSize = this.getCurrentSizeNoSync();
                                toShrink += currentSize;
                                --itemCount;
                                shrunk = true;
                                --currentPosition;
                            }
                        } else if (!shrinkOnly) {
                            item.keepForClean();
                            break;
                        }
                    }
                }
                item = null;
            }
            if (shrunk) {
                this.trimToSize();
            }
            if (item == null) {
                this.wokenToClean = false;
                this.needService = false;
                return 1;
            }
        }
        try {
            if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
                SanityManager.DEBUG(DaemonService.DaemonTrace, ThreadName + " cleaning entry  in " + this.name);
            }
            item.clean(false);
            ++cleaned;
        }
        catch (StandardException se) {
        }
        finally {
            this.release(item);
            item = null;
        }
        if (SanityManager.DEBUG_ON(DaemonService.DaemonTrace)) {
            SanityManager.DEBUG(DaemonService.DaemonTrace, ThreadName + " Found " + clean + " clean items, cleaned " + cleaned + " items in " + this.name);
        }
        this.needService = true;
        return 2;
    }

    private int getItemSize(CachedItem item) {
        if (!this.useByteCount) {
            return 1;
        }
        SizedCacheable entry = (SizedCacheable)item.getEntry();
        if (null == entry) {
            return 0;
        }
        return entry.getSize();
    }

    public synchronized long[] getCacheStats() {
        this.stat.currentSize = this.getCurrentSizeNoSync();
        return this.stat.getStats();
    }

    public void resetCacheStats() {
        this.stat.reset();
    }

    public synchronized long getMaximumSize() {
        return this.maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) throws StandardException {
        boolean shrink;
        Clock clock = this;
        synchronized (clock) {
            this.stat.maxSize = this.maximumSize = newSize;
            shrink = this.shrinkSize(this.getCurrentSizeNoSync()) > 0L;
        }
        if (shrink) {
            CachedItem freeItem;
            this.performWork(true);
            if (this.shrinkSize(this.getCurrentSize()) > 0L && (freeItem = this.rotateClock(2.0f)) != null) {
                freeItem.unkeepForCreate();
            }
        }
    }

    private synchronized long getCurrentSize() {
        return this.getCurrentSizeNoSync();
    }

    private long getCurrentSizeNoSync() {
        if (!this.useByteCount) {
            return this.holders.size();
        }
        return this.currentByteCount + (long)(this.holders.size() * ITEM_OVERHEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Matchable filter, Operator operator) {
        boolean itemCount = true;
        Cacheable entry = null;
        CachedItem item = null;
        int position = 0;
        while (true) {
            Clock clock = this;
            synchronized (clock) {
                if (null != item) {
                    this.release(item);
                    item = null;
                }
                while (position < this.holders.size()) {
                    block11: {
                        item = (CachedItem)this.holders.get(position);
                        if (null != item) {
                            try {
                                entry = item.use();
                            }
                            catch (StandardException se) {
                                break block11;
                            }
                            if (null != entry && (null == filter || filter.match(entry))) {
                                item.keepForClean();
                                break;
                            }
                        }
                    }
                    ++position;
                }
                if (position >= this.holders.size()) {
                    return;
                }
            }
            operator.operate(entry);
            ++position;
        }
    }

    private void trimToSize() {
        int size = this.holders.size();
        ++this.trimRequests;
        if (this.trimRequests < size / 8) {
            return;
        }
        this.trimRequests = 0;
        int endPosition = size - 1;
        int invalidCount = 0;
        block0: for (int i = 0; i <= endPosition; ++i) {
            CachedItem item = (CachedItem)this.holders.get(i);
            if (item.isKept() || item.isValid()) continue;
            ++invalidCount;
            while (endPosition > i) {
                CachedItem last = (CachedItem)this.holders.get(endPosition);
                if (last.isValid()) {
                    this.holders.set(i, last);
                    this.holders.set(endPosition, item);
                    --endPosition;
                    continue block0;
                }
                --endPosition;
            }
        }
        if (size < 32) {
            return;
        }
        int validItems = size - invalidCount;
        if (validItems > 3 * size / 4) {
            return;
        }
        int newSize = validItems + validItems / 10;
        if (newSize >= size) {
            return;
        }
        for (int r = size - 1; r > newSize; --r) {
            CachedItem remove = (CachedItem)this.holders.get(r);
            if (remove.isKept() || remove.isValid()) continue;
            if (this.useByteCount) {
                this.currentByteCount -= (long)this.getItemSize(remove);
            }
            this.holders.remove(r);
        }
        this.holders.trimToSize();
        this.clockHand = validItems + 1;
    }

    public synchronized boolean containsKey(Object k) {
        return this.cache_.containsKey(k);
    }

    public synchronized Collection values() {
        ArrayList<Cacheable> al = new ArrayList<Cacheable>();
        Iterator i = this.cache_.values().iterator();
        while (i.hasNext()) {
            al.add(((CachedItem)i.next()).getEntry());
        }
        return al;
    }
}

