/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.io.PrintWriter;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;

public abstract class AuthenticationServiceBase
implements AuthenticationService,
ModuleControl,
ModuleSupportable,
PropertySetCallback {
    protected UserAuthenticator authenticationScheme;
    private AccessFactory store;
    public static final String AuthenticationTrace = "AuthenticationTrace";
    public static final String ID_PATTERN_NEW_SCHEME = "3b60";
    protected static final int SECMEC_USRSSBPWD = 8;
    public static final int MAGICLEN_NEWENCRYPT_SCHEME = 44;

    protected void setAuthenticationService(UserAuthenticator aScheme) {
        this.authenticationScheme = aScheme;
        SanityManager.ASSERT(this.authenticationScheme != null, "There is no authentication scheme for that service!");
        if (SanityManager.DEBUG_ON(AuthenticationTrace)) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println("Authentication Service: [" + this.toString() + "]");
            iDbgStream.println("Authentication Scheme : [" + this.authenticationScheme.toString() + "]");
        }
    }

    public void boot(boolean create, Properties properties) throws StandardException {
        this.store = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        PropertyFactory pf = (PropertyFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        if (pf != null) {
            pf.addPropertySetNotification(this);
        }
    }

    public void stop() {
    }

    public boolean authenticate(String databaseName, Properties userInfo) throws SQLException {
        if (userInfo == (Properties)null) {
            return false;
        }
        String userName = userInfo.getProperty("user");
        if (userName != null && userName.length() > 30) {
            return false;
        }
        if (SanityManager.DEBUG_ON(AuthenticationTrace)) {
            PrintWriter iDbgStream = SanityManager.GET_DEBUG_STREAM();
            iDbgStream.println(" - Authentication request: user [" + userName + "]" + ", database [" + databaseName + "]");
        }
        return this.authenticationScheme.authenticateUser(userName, userInfo.getProperty("password"), databaseName, userInfo);
    }

    public String getProperty(String key) {
        String propertyValue = null;
        TransactionController tc = null;
        try {
            if (this.store != null) {
                tc = this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            }
            propertyValue = PropertyUtil.getServiceProperty(tc, key, null);
            if (tc != null) {
                tc.commit();
                tc = null;
            }
        }
        catch (StandardException se) {
            // empty catch block
        }
        return propertyValue;
    }

    public String getDatabaseProperty(String key) {
        String propertyValue = null;
        TransactionController tc = null;
        try {
            if (this.store != null) {
                tc = this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            }
            propertyValue = PropertyUtil.getDatabaseProperty(tc, key);
            if (tc != null) {
                tc.commit();
                tc = null;
            }
        }
        catch (StandardException se) {
            // empty catch block
        }
        return propertyValue;
    }

    public String getSystemProperty(String key) {
        boolean dbOnly = false;
        dbOnly = Boolean.valueOf(this.getDatabaseProperty("derby.database.propertiesOnly"));
        if (dbOnly) {
            return null;
        }
        return PropertyUtil.getSystemProperty(key);
    }

    public void init(boolean dbOnly, Dictionary p) {
    }

    public boolean validate(String key, Serializable value, Dictionary p) {
        return key.startsWith("derby.user.");
    }

    public Serviceable apply(String key, Serializable value, Dictionary p) {
        return null;
    }

    public Serializable map(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.startsWith("derby.user.")) {
            return null;
        }
        String authService = (String)p.get("derby.authentication.provider");
        if (authService != null && StringUtil.SQLEqualsIgnoreCase(authService, "LDAP")) {
            return null;
        }
        String userPassword = (String)((Object)value);
        if (userPassword != null) {
            userPassword = this.encryptPassword(userPassword);
        }
        return userPassword;
    }

    protected final boolean requireAuthentication(Properties properties) {
        String requireAuthentication = PropertyUtil.getPropertyFromSet(properties, "derby.connection.requireAuthentication");
        return Boolean.valueOf(requireAuthentication);
    }

    protected String encryptPassword(String plainTxtUserPassword) {
        if (plainTxtUserPassword == null) {
            return null;
        }
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            // empty catch block
        }
        algorithm.reset();
        byte[] bytePasswd = null;
        bytePasswd = StringUtil.toHexByte(plainTxtUserPassword, 0, plainTxtUserPassword.length());
        algorithm.update(bytePasswd);
        byte[] encryptVal = algorithm.digest();
        String hexString = ID_PATTERN_NEW_SCHEME + StringUtil.toHexString(encryptVal, 0, encryptVal.length);
        return hexString;
    }

    protected String substitutePassword(String userName, String password, Properties info, boolean databaseUser) {
        MessageDigest messageDigest = null;
        String ID_PATTERN_NEW_SCHEME = ID_PATTERN_NEW_SCHEME;
        byte[] SECMEC_USRSSBPWD_PWDSEQS = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] bytePasswd = null;
        byte[] userBytes = StringUtil.toHexByte(userName, 0, userName.length());
        SanityManager.ASSERT(info.getProperty("drdaSecTokenIn") != null && info.getProperty("drdaSecTokenOut") != null, "Unexpected: Requester or server seed not available");
        String sourceSeedstr = info.getProperty("drdaSecTokenIn");
        String targetSeedstr = info.getProperty("drdaSecTokenOut");
        byte[] sourceSeed_ = StringUtil.fromHexString(sourceSeedstr, 0, sourceSeedstr.length());
        byte[] targetSeed_ = StringUtil.fromHexString(targetSeedstr, 0, targetSeedstr.length());
        String hexString = null;
        if (!databaseUser) {
            bytePasswd = StringUtil.toHexByte(password, 0, password.length());
            messageDigest.update(bytePasswd);
            byte[] encryptVal = messageDigest.digest();
            hexString = ID_PATTERN_NEW_SCHEME + StringUtil.toHexString(encryptVal, 0, encryptVal.length);
        } else {
            hexString = password;
        }
        messageDigest.update(userBytes);
        messageDigest.update(StringUtil.toHexByte(hexString, 0, hexString.length()));
        byte[] passwordToken = messageDigest.digest();
        messageDigest.update(passwordToken);
        messageDigest.update(targetSeed_);
        messageDigest.update(sourceSeed_);
        messageDigest.update(userBytes);
        messageDigest.update(SECMEC_USRSSBPWD_PWDSEQS);
        byte[] passwordSubstitute = messageDigest.digest();
        return StringUtil.toHexString(passwordSubstitute, 0, passwordSubstitute.length);
    }
}

