/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.Util;

public final class UTF8Reader
extends Reader {
    private InputStream in;
    private final PositionedStoreStream positionedIn;
    private long rawStreamPos = 0L;
    private final long utfLen;
    private long utfCount;
    private long readerCharCount;
    private long maxFieldSize;
    private char[] buffer = new char[8192];
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UTF8Reader(InputStream in, long maxFieldSize, ConnectionChild parent, Object synchronization) throws IOException, SQLException {
        super(synchronization);
        this.maxFieldSize = maxFieldSize;
        this.parent = parent;
        parent.setupContextStack();
        try {
            Object object = this.lock;
            synchronized (object) {
                if (in instanceof PositionedStoreStream) {
                    this.positionedIn = (PositionedStoreStream)in;
                    this.in = in;
                    try {
                        this.positionedIn.resetStream();
                    }
                    catch (StandardException se) {
                        IOException ioe = new IOException(se.getMessage());
                        ioe.initCause(se);
                        throw ioe;
                    }
                } else {
                    this.positionedIn = null;
                    this.in = new BufferedInputStream(in);
                }
                this.utfLen = this.readUnsignedShort();
                if (this.positionedIn != null) {
                    this.rawStreamPos = this.positionedIn.getPosition();
                }
            }
        }
        finally {
            parent.restoreContextStack();
        }
    }

    public UTF8Reader(InputStream in, long maxFieldSize, long streamSize, ConnectionChild parent, Object synchronization) throws IOException {
        super(synchronization);
        this.maxFieldSize = maxFieldSize;
        this.parent = parent;
        this.utfLen = streamSize;
        this.positionedIn = null;
        SanityManager.ASSERT(!(in instanceof Resetable));
        this.in = new BufferedInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException();
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            return this.buffer[this.readPositionInBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.noMoreReads) {
                throw new IOException();
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cbuf, off, len);
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long len) throws IOException {
        if (len < 0L) {
            throw new IllegalArgumentException("Number of characters to skip must be positive: " + len);
        }
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.noMoreReads) {
                throw new IOException();
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return 0L;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (long)(remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInto(StringBuffer sb, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            sb.append(this.buffer, this.readPositionInBuffer, len);
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAsciiInto(byte[] abuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int remainingInBuffer;
            if (this.readPositionInBuffer >= this.charactersInBuffer) {
                if (this.fillBuffer()) {
                    return -1;
                }
                this.readPositionInBuffer = 0;
            }
            if (len > (remainingInBuffer = this.charactersInBuffer - this.readPositionInBuffer)) {
                len = remainingInBuffer;
            }
            char[] lbuffer = this.buffer;
            for (int i = 0; i < len; ++i) {
                char c = lbuffer[this.readPositionInBuffer + i];
                int cb = c <= '\u00ff' ? (int)((byte)c) : 63;
                abuf[off + i] = cb;
            }
            this.readPositionInBuffer += len;
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIn() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private IOException utfFormatException(String s) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(s);
    }

    private IOException utfFormatException() {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        try {
            try {
                int c;
                this.parent.setupContextStack();
                if (this.positionedIn != null) {
                    try {
                        this.positionedIn.reposition(this.rawStreamPos);
                    }
                    catch (StandardException se) {
                        throw Util.generateCsSQLException(se);
                    }
                }
                block13: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= this.utfLen && this.utfLen != 0L || this.maxFieldSize != 0L && this.readerCharCount >= this.maxFieldSize)) {
                    int finalChar;
                    c = this.in.read();
                    if (c == -1) {
                        if (this.utfLen != 0L) throw this.utfFormatException();
                        this.closeIn();
                        break;
                    }
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++this.utfCount;
                            finalChar = c;
                            break;
                        }
                        case 12: 
                        case 13: {
                            this.utfCount += 2L;
                            int char2 = this.in.read();
                            if (char2 == -1) {
                                throw this.utfFormatException();
                            }
                            if ((char2 & 0xC0) != 128) {
                                throw this.utfFormatException();
                            }
                            finalChar = (c & 0x1F) << 6 | char2 & 0x3F;
                            break;
                        }
                        case 14: {
                            this.utfCount += 3L;
                            int char2 = this.in.read();
                            int char3 = this.in.read();
                            if (char2 == -1) throw this.utfFormatException();
                            if (char3 == -1) {
                                throw this.utfFormatException();
                            }
                            if (c == 224 && char2 == 0 && char3 == 0) {
                                if (this.utfLen != 0L) throw this.utfFormatException();
                                this.closeIn();
                                break block13;
                            }
                            if ((char2 & 0xC0) != 128) throw this.utfFormatException();
                            if ((char3 & 0xC0) != 128) {
                                throw this.utfFormatException();
                            }
                            finalChar = (c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0;
                            break;
                        }
                        default: {
                            throw this.utfFormatException();
                        }
                    }
                    this.buffer[this.charactersInBuffer++] = (char)finalChar;
                    ++this.readerCharCount;
                }
                if (this.utfLen != 0L && this.utfCount > this.utfLen) {
                    throw this.utfFormatException("utfCount " + this.utfCount + " utfLen " + this.utfLen);
                }
                if (this.charactersInBuffer != 0) {
                    if (this.positionedIn != null) {
                        this.rawStreamPos = this.positionedIn.getPosition();
                    }
                    c = 0;
                    return c != 0;
                }
                this.closeIn();
                c = 1;
                return c != 0;
            }
            finally {
                this.parent.restoreContextStack();
            }
        }
        catch (SQLException sqle) {
            IOException ioe = new IOException(sqle.getSQLState() + ": " + sqle.getMessage());
            ioe.initCause(sqle);
            throw ioe;
        }
    }

    private final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }
}

