/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.UTF8Util;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

final class StoreStreamClob
implements InternalClob {
    private static final long SKIP_BUFFER_SIZE = 8192L;
    private volatile boolean released = false;
    private final PositionedStoreStream positionedStoreStream;
    private final ConnectionChild conChild;
    private final Object synchronizationObject;

    public StoreStreamClob(InputStream stream, ConnectionChild conChild) throws StandardException {
        this.positionedStoreStream = new PositionedStoreStream(stream);
        this.conChild = conChild;
        this.synchronizationObject = conChild.getConnectionSynchronization();
        this.positionedStoreStream.initStream();
    }

    public void release() {
        if (!this.released) {
            this.positionedStoreStream.closeStream();
            this.released = true;
        }
    }

    public long getByteLength() throws IOException, SQLException {
        this.checkIfValid();
        long byteLength = 0L;
        try {
            this.conChild.setupContextStack();
            this.positionedStoreStream.reposition(0L);
            int us1 = this.positionedStoreStream.read();
            int us2 = this.positionedStoreStream.read();
            byteLength = (us1 << 8) + (us2 << 0);
            if (byteLength == 0L) {
                long skipped;
                while ((skipped = this.positionedStoreStream.skip(8192L)) > 0L) {
                    byteLength += skipped;
                }
                byteLength -= 3L;
            }
            long l = byteLength;
            return l;
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        finally {
            this.conChild.restoreContextStack();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCharLength() throws SQLException {
        this.checkIfValid();
        Object object = this.synchronizationObject;
        synchronized (object) {
            this.conChild.setupContextStack();
            try {
                long l = UTF8Util.skipUntilEOF(new BufferedInputStream(this.getRawByteStream()));
                return l;
            }
            catch (Throwable t) {
                throw StoreStreamClob.noStateChangeLOB(t);
            }
            finally {
                this.conChild.restoreContextStack();
            }
        }
    }

    public InputStream getRawByteStream() throws IOException, SQLException {
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(2L);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        return this.positionedStoreStream;
    }

    public Reader getReader(long pos) throws IOException, SQLException {
        long skipped;
        this.checkIfValid();
        try {
            this.positionedStoreStream.reposition(0L);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        UTF8Reader reader = new UTF8Reader(this.positionedStoreStream, Integer.MAX_VALUE, this.conChild, this.synchronizationObject);
        for (long leftToSkip = pos - 1L; leftToSkip > 0L; leftToSkip -= skipped) {
            skipped = ((Reader)reader).skip(leftToSkip);
            if (skipped > 0L) continue;
            throw new EOFException("Reached end-of-stream prematurely");
        }
        return reader;
    }

    public long getBytePosition(long charPos) throws IOException, SQLException {
        return UTF8Util.skipFully(this.getRawByteStream(), charPos - 1L);
    }

    public Writer getWriter(long pos) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    public long insertString(String str, long pos) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    public boolean isWritable() {
        return false;
    }

    public void truncate(long newLength) {
        throw new UnsupportedOperationException("A StoreStreamClob object is not updatable");
    }

    private static SQLException noStateChangeLOB(Throwable t) {
        if (t instanceof StandardException && ((StandardException)t).getMessageId().equals("40XD0")) {
            t = StandardException.newException("XJ073.S");
        }
        return EmbedResultSet.noStateChangeException(t);
    }

    private void checkIfValid() {
        if (this.released) {
            throw new IllegalStateException("The Clob has been released and is not valid");
        }
    }
}

