/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.EmbedSQLException;
import org.apache.derby.impl.jdbc.SQLExceptionFactory;

public class SQLExceptionFactory40
extends SQLExceptionFactory {
    @Override
    public SQLException getSQLException(String message, String messageId, SQLException next, int severity, Throwable t, Object[] args) {
        String sqlState = StandardException.getSQLStateFromIdentifier(messageId);
        t = this.wrapArgsForTransportAcrossDRDA(message, messageId, next, severity, t, args);
        SQLException ex = sqlState.startsWith("08") ? new SQLNonTransientConnectionException(message, sqlState, severity, t) : (sqlState.startsWith("22") ? new SQLDataException(message, sqlState, severity, t) : (sqlState.startsWith("23") ? new SQLIntegrityConstraintViolationException(message, sqlState, severity, t) : (sqlState.startsWith("28") ? new SQLInvalidAuthorizationSpecException(message, sqlState, severity, t) : (sqlState.startsWith("40") ? new SQLTransactionRollbackException(message, sqlState, severity, t) : (sqlState.startsWith("42") ? new SQLSyntaxErrorException(message, sqlState, severity, t) : (sqlState.startsWith("0A") ? new SQLFeatureNotSupportedException(message, sqlState, severity, t) : new SQLException(message, sqlState, severity, t)))))));
        if (next != null) {
            ex.setNextException(next);
        }
        return ex;
    }

    @Override
    public SQLException getArgumentFerry(SQLException se) {
        Throwable cause = se.getCause();
        if (cause == null || !(cause instanceof EmbedSQLException)) {
            return se;
        }
        return (SQLException)cause;
    }

    private SQLException wrapArgsForTransportAcrossDRDA(String message, String messageId, SQLException next, int severity, Throwable t, Object[] args) {
        SQLException e = super.getSQLException(message, messageId, next == null ? null : this.getArgumentFerry(next), severity, t, args);
        return e;
    }
}

