/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.Resetable;

public class PositionedStoreStream
extends InputStream
implements Resetable {
    private final InputStream stream;
    private final Resetable resettable;
    private long pos = 0L;

    public PositionedStoreStream(InputStream in) {
        this.stream = in;
        this.resettable = (Resetable)((Object)in);
    }

    public int read(byte[] b) throws IOException {
        int ret = this.stream.read(b);
        this.pos += (long)ret;
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.stream.read(b, off, len);
        this.pos += (long)ret;
        return ret;
    }

    public int read() throws IOException {
        int ret = this.stream.read();
        if (ret > -1) {
            ++this.pos;
        }
        return ret;
    }

    public long skip(long toSkip) throws IOException {
        long ret = this.stream.skip(toSkip);
        this.pos += ret;
        return ret;
    }

    public void resetStream() throws IOException, StandardException {
        this.resettable.resetStream();
        this.pos = 0L;
    }

    public void initStream() throws StandardException {
        this.resettable.initStream();
        this.pos = 0L;
    }

    public void closeStream() {
        this.resettable.closeStream();
    }

    public void reposition(long requestedPos) throws IOException, StandardException {
        if (this.pos < requestedPos) {
            this.skipFully(requestedPos - this.pos);
            this.pos = requestedPos;
        } else if (this.pos > requestedPos) {
            this.resettable.resetStream();
            this.skipFully(requestedPos);
            this.pos = requestedPos;
        }
    }

    public long getPosition() {
        return this.pos;
    }

    private void skipFully(long toSkip) throws IOException {
        long skippedNow;
        for (long remaining = toSkip; remaining > 0L; remaining -= skippedNow) {
            skippedNow = this.stream.skip(remaining);
            if (skippedNow != 0L) continue;
            if (this.stream.read() == -1) {
                throw new EOFException("Reached end-of-stream prematurely, with " + remaining + " byte(s) to go");
            }
            skippedNow = 1L;
        }
    }
}

