/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.EncryptedLOBFile;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.LOBOutputStream;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.ExceptionUtil;

class LOBStreamControl {
    private LOBFile tmpFile;
    private StorageFile lobFile;
    private byte[] dataBytes = new byte[0];
    private boolean isBytes = true;
    private final int bufferSize;
    private String dbName;
    private long updateCount;
    private static final int DEFAULT_MAX_BUF_SIZE = 4096;

    LOBStreamControl(String dbName) {
        this.dbName = dbName;
        this.updateCount = 0L;
        this.bufferSize = 4096;
    }

    LOBStreamControl(String dbName, byte[] data) throws IOException, SQLException, StandardException {
        this.dbName = dbName;
        this.updateCount = 0L;
        this.bufferSize = Math.max(4096, data.length);
        this.write(data, 0, data.length, 0L);
    }

    private void init(byte[] b, long len) throws IOException, SQLException, StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, StandardException {
                    Object monitor = Monitor.findService("org.apache.derby.database.Database", LOBStreamControl.this.dbName);
                    DataFactory df = (DataFactory)Monitor.findServiceModule(monitor, "org.apache.derby.iapi.store.raw.data.DataFactory");
                    LOBStreamControl.this.lobFile = df.getStorageFactory().createTemporaryFile("lob", null);
                    if (df.databaseEncrypted()) {
                        LOBStreamControl.this.tmpFile = new EncryptedLOBFile(LOBStreamControl.this.lobFile, df);
                    } else {
                        LOBStreamControl.this.tmpFile = new LOBFile(LOBStreamControl.this.lobFile);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof StandardException) {
                throw Util.generateCsSQLException((StandardException)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        this.isBytes = false;
        if (len != 0L) {
            this.write(b, 0, (int)len, 0L);
        }
        this.dataBytes = null;
    }

    private long updateData(byte[] bytes, int offset, int len, long pos) throws SQLException {
        if (this.dataBytes == null) {
            if ((int)pos == 0) {
                this.dataBytes = new byte[len];
                System.arraycopy(bytes, offset, this.dataBytes, (int)pos, len);
                return len;
            }
            throw Util.generateCsSQLException("XJ076.S", new Long(pos));
        }
        if (pos > (long)this.dataBytes.length) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos));
        }
        if (pos + (long)len < (long)this.dataBytes.length) {
            System.arraycopy(bytes, offset, this.dataBytes, (int)pos, len);
        } else {
            byte[] tmpBytes = new byte[len + (int)pos];
            System.arraycopy(this.dataBytes, 0, tmpBytes, 0, (int)pos);
            System.arraycopy(bytes, offset, tmpBytes, (int)pos, len);
            this.dataBytes = tmpBytes;
        }
        return pos + (long)len;
    }

    private void isValidPostion(long pos) throws SQLException, IOException {
        if (pos < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(pos + 1L));
        }
        if (pos > Integer.MAX_VALUE) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos + 1L));
        }
        if (this.isBytes ? (this.dataBytes == null ? pos != 0L : (long)this.dataBytes.length < pos) : pos > this.tmpFile.length()) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos + 1L));
        }
    }

    private void isValidOffset(int off, int length) throws SQLException {
        if (off < 0 || off > length) {
            throw Util.generateCsSQLException("XJ078.S", new Integer(off));
        }
    }

    synchronized long write(int b, long pos) throws IOException, SQLException, StandardException {
        this.isValidPostion(pos);
        ++this.updateCount;
        if (this.isBytes) {
            if (pos < (long)this.bufferSize) {
                byte[] bytes = new byte[]{(byte)b};
                this.updateData(bytes, 0, 1, pos);
                return pos + 1L;
            }
            this.init(this.dataBytes, pos);
        }
        this.tmpFile.seek(pos);
        this.tmpFile.write(b);
        return this.tmpFile.getFilePointer();
    }

    synchronized long write(byte[] b, int off, int len, long pos) throws IOException, SQLException, StandardException {
        try {
            this.isValidPostion(pos);
            this.isValidOffset(off, b.length);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            throw e;
        }
        ++this.updateCount;
        if (this.isBytes) {
            if (pos + (long)len <= (long)this.bufferSize) {
                return this.updateData(b, off, len, pos);
            }
            this.init(this.dataBytes, pos);
        }
        this.tmpFile.seek(pos);
        this.tmpFile.write(b, off, len);
        return this.tmpFile.getFilePointer();
    }

    synchronized int read(long pos) throws IOException, SQLException, StandardException {
        this.isValidPostion(pos);
        if (this.isBytes) {
            if ((long)this.dataBytes.length == pos) {
                return -1;
            }
            return this.dataBytes[(int)pos] & 0xFF;
        }
        if (this.tmpFile.getFilePointer() != pos) {
            this.tmpFile.seek(pos);
        }
        try {
            return this.tmpFile.readByte() & 0xFF;
        }
        catch (EOFException eof) {
            return -1;
        }
    }

    private int readBytes(byte[] b, int off, int len, long pos) {
        if (pos >= (long)this.dataBytes.length) {
            return -1;
        }
        int lengthFromPos = this.dataBytes.length - (int)pos;
        int actualLength = len > lengthFromPos ? lengthFromPos : len;
        byte[] result = new byte[actualLength];
        System.arraycopy(this.dataBytes, (int)pos, b, off, actualLength);
        return actualLength;
    }

    synchronized int read(byte[] buff, int off, int len, long pos) throws IOException, SQLException, StandardException {
        this.isValidPostion(pos);
        this.isValidOffset(off, buff.length);
        if (this.isBytes) {
            return this.readBytes(buff, off, len, pos);
        }
        this.tmpFile.seek(pos);
        return this.tmpFile.read(buff, off, len);
    }

    InputStream getInputStream(long pos) {
        return new LOBInputStream(this, pos);
    }

    OutputStream getOutputStream(long pos) {
        return new LOBOutputStream(this, pos);
    }

    long getLength() throws IOException {
        if (this.isBytes) {
            return this.dataBytes.length;
        }
        return this.tmpFile.length();
    }

    synchronized void truncate(long size) throws IOException, SQLException, StandardException {
        this.isValidPostion(size);
        if (this.isBytes) {
            byte[] tmpByte = new byte[(int)size];
            System.arraycopy(this.dataBytes, 0, tmpByte, 0, (int)size);
            this.dataBytes = tmpByte;
        } else if (size < (long)this.bufferSize) {
            this.dataBytes = new byte[(int)size];
            this.read(this.dataBytes, 0, this.dataBytes.length, 0L);
            this.isBytes = true;
            this.tmpFile.close();
            this.tmpFile = null;
        } else {
            try {
                this.tmpFile.setLength(size);
            }
            catch (StandardException se) {
                Util.generateCsSQLException(se);
            }
        }
    }

    synchronized void copyData(InputStream inStream, long length) throws IOException, SQLException, StandardException {
        int len;
        byte[] data = new byte[this.bufferSize];
        for (long sz = 0L; sz < length; sz += (long)len) {
            len = (int)Math.min(length - sz, (long)this.bufferSize);
            if ((len = inStream.read(data, 0, len)) < 0) {
                throw new EOFException("Reached end-of-stream prematurely at " + sz);
            }
            this.write(data, 0, len, sz);
        }
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    private void deleteFile(StorageFile file) throws IOException {
        try {
            final StorageFile sf = file;
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    sf.delete();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    void free() throws IOException {
        this.dataBytes = null;
        if (this.tmpFile != null) {
            this.tmpFile.close();
            this.deleteFile(this.lobFile);
            this.tmpFile = null;
        }
    }

    synchronized long replaceBytes(byte[] buf, long stPos, long endPos) throws IOException, SQLException, StandardException {
        long length = this.getLength();
        long finalLength = length - endPos + stPos + (long)buf.length;
        if (this.isBytes) {
            if (finalLength > (long)this.bufferSize) {
                byte[] tmpBytes = this.dataBytes;
                this.init(tmpBytes, stPos);
                this.write(buf, 0, buf.length, this.getLength());
                if (endPos < length) {
                    this.write(tmpBytes, (int)endPos, (int)(length - endPos), this.getLength());
                }
            } else {
                byte[] tmpByte = new byte[(int)finalLength];
                System.arraycopy(this.dataBytes, 0, tmpByte, 0, (int)stPos);
                System.arraycopy(buf, 0, tmpByte, (int)stPos, buf.length);
                if (endPos < length) {
                    System.arraycopy(this.dataBytes, (int)endPos, tmpByte, (int)(stPos + (long)buf.length), (int)(length - endPos));
                }
                this.dataBytes = tmpByte;
            }
        } else {
            int readLen;
            int actualLength;
            byte[] tmp = new byte[]{};
            LOBFile oldFile = this.tmpFile;
            StorageFile oldStoreFile = this.lobFile;
            this.init(tmp, 0L);
            byte[] tmpByte = new byte[1024];
            oldFile.seek(0L);
            for (long sz = stPos; sz != 0L && (actualLength = oldFile.read(tmpByte, 0, readLen = (int)Math.min(1024L, sz))) != -1; sz -= (long)actualLength) {
                this.tmpFile.write(tmpByte, 0, actualLength);
            }
            this.tmpFile.write(buf);
            oldFile.seek(endPos);
            if (endPos < length) {
                int rdLen;
                while ((rdLen = oldFile.read(tmpByte, 0, 1024)) != -1) {
                    this.tmpFile.write(tmpByte, 0, rdLen);
                }
                oldFile.close();
                this.deleteFile(oldStoreFile);
            }
        }
        ++this.updateCount;
        return stPos + (long)buf.length;
    }

    long getUpdateCount() {
        return this.updateCount;
    }
}

