/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.shared.common.error.ExceptionUtil;

public class LOBOutputStream
extends OutputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;

    LOBOutputStream(LOBStreamControl control, long position) {
        this.control = control;
        this.pos = position;
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            this.pos = this.control.write(b, this.pos);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        catch (StandardException se) {
            throw new IOException(se.getMessage());
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            this.pos = this.control.write(b, off, len, this.pos);
        }
        catch (SQLException e) {
            if (e.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            throw new IOException(e.getMessage());
        }
        catch (StandardException se) {
            throw new IOException(se.getMessage());
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

