/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.shared.common.error.ExceptionUtil;

public class LOBInputStream
extends InputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;
    private long updateCount;

    LOBInputStream(LOBStreamControl control, long position) {
        this.control = control;
        this.pos = position;
        this.updateCount = control.getUpdateCount();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            int ret = this.control.read(b, off, len, this.pos);
            if (ret != -1) {
                this.pos += (long)ret;
                return ret;
            }
            return -1;
        }
        catch (SQLException e) {
            return this.handleSQLException(e);
        }
        catch (StandardException se) {
            throw new IOException(se.getMessage());
        }
    }

    public void close() throws IOException {
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            int ret = this.control.read(this.pos);
            if (ret != -1) {
                ++this.pos;
            }
            return ret;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        catch (StandardException se) {
            throw new IOException(se.getMessage());
        }
    }

    private int handleSQLException(SQLException e) throws IOException {
        if (e.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ076.S"))) {
            return -1;
        }
        if (e.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
        throw new IOException(e.getMessage());
    }

    boolean isObsolete() {
        return this.updateCount != this.control.getUpdateCount();
    }

    void reInitialize() {
        this.updateCount = this.control.getUpdateCount();
        this.pos = 0L;
    }

    long length() throws IOException {
        return this.control.getLength();
    }
}

