/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public class EmbedResultSetMetaData
implements ResultSetMetaData {
    private final ResultColumnDescriptor[] columnInfo;

    public EmbedResultSetMetaData(ResultColumnDescriptor[] columnInfo) {
        this.columnInfo = columnInfo;
    }

    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    public final boolean isAutoIncrement(int column) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor rcd = this.columnInfo[column - 1];
        return rcd.isAutoincrement();
    }

    public final boolean isCaseSensitive(int column) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(column));
    }

    public final boolean isSearchable(int column) throws SQLException {
        this.validColumnNumber(column);
        return true;
    }

    public final boolean isCurrency(int column) throws SQLException {
        return DataTypeUtilities.isCurrency(this.getColumnTypeDescriptor(column));
    }

    public final int isNullable(int column) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(column));
    }

    public final boolean isSigned(int column) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(column));
    }

    public final int getColumnDisplaySize(int column) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(column));
    }

    public final String getColumnLabel(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getName();
        return s == null ? "Column" + Integer.toString(column) : s;
    }

    public final String getColumnName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getName();
        return s == null ? "" : s;
    }

    public final String getSchemaName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getSourceSchemaName();
        return s == null ? "" : s;
    }

    public final int getPrecision(int column) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(column));
    }

    public final int getScale(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getScale();
    }

    public final String getTableName(int column) throws SQLException {
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        String s = cd.getSourceTableName();
        return s == null ? "" : s;
    }

    public final String getCatalogName(int column) throws SQLException {
        this.validColumnNumber(column);
        return "";
    }

    public final int getColumnType(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getTypeId().getJDBCTypeId();
    }

    public final String getColumnTypeName(int column) throws SQLException {
        DataTypeDescriptor dtd = this.getColumnTypeDescriptor(column);
        return dtd.getTypeId().getSQLTypeName();
    }

    public final boolean isReadOnly(int column) throws SQLException {
        this.validColumnNumber(column);
        return false;
    }

    public final boolean isWritable(int column) throws SQLException {
        this.validColumnNumber(column);
        return this.columnInfo[column - 1].updatableByCursor();
    }

    public final boolean isDefinitelyWritable(int column) throws SQLException {
        this.validColumnNumber(column);
        return false;
    }

    private void validColumnNumber(int column) throws SQLException {
        if (column < 1 || column > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", new Integer(column));
        }
    }

    private DataTypeDescriptor getColumnTypeDescriptor(int column) throws SQLException {
        this.validColumnNumber(column);
        ResultColumnDescriptor cd = this.columnInfo[column - 1];
        return cd.getType();
    }

    public final String getColumnClassName(int column) throws SQLException {
        return this.getColumnTypeDescriptor(column).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, int jdcbTypeId, boolean nullable) {
        return new GenericColumnDescriptor(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdcbTypeId, nullable));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, int jdcbTypeId, boolean nullable, int length) {
        return new GenericColumnDescriptor(name, DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdcbTypeId, nullable, length));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String name, DataTypeDescriptor dtd) {
        return new GenericColumnDescriptor(name, dtd);
    }
}

