/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.EngineParameterMetaData;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedParameterSetMetaData;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedPreparedStatement
extends EmbedStatement
implements EnginePreparedStatement {
    protected ResultSetMetaData rMetaData;
    private String gcDuringGetMetaData;
    protected org.apache.derby.iapi.sql.PreparedStatement preparedStatement;
    private Activation activation;
    private BrokeredConnectionControl bcc = null;

    public EmbedPreparedStatement(EmbedConnection conn, String sql, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        super(conn, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.isPoolable = true;
        if (sql == null) {
            throw this.newSQLException("XJ067.S");
        }
        this.SQLText = sql;
        try {
            this.preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), sql, resultSetConcurrency == 1007, forMetaData);
            this.addWarning(this.preparedStatement.getCompileTimeWarnings());
            this.activation = this.preparedStatement.getActivation(this.lcc, resultSetType == 1004);
            this.checkRequiresCallableStatement(this.activation);
            if (autoGeneratedKeys == 1) {
                this.activation.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
            }
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.activation != null) {
            this.activation.markUnused();
        }
    }

    public final boolean execute(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String)");
    }

    public final boolean execute(String sql, int autoGenKeys) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int)");
    }

    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int[])");
    }

    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, String[])");
    }

    public final ResultSet executeQuery(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeQuery(String)");
    }

    public final int executeUpdate(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String)");
    }

    public final int executeUpdate(String sql, int autoGenKeys) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int)");
    }

    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int[])");
    }

    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, String[])");
    }

    public final void addBatch(String sql) throws SQLException {
        throw this.newSQLException("XJ016.S", "addBatch(String)");
    }

    void closeActions() throws SQLException {
        if (this.bcc != null) {
            PreparedStatement ps_app = (PreparedStatement)((Object)this.applicationStatement);
            this.bcc.onStatementClose(ps_app);
        }
        this.preparedStatement = null;
        try {
            this.setupContextStack();
        }
        catch (SQLException se) {
            return;
        }
        try {
            this.activation.close();
            this.activation = null;
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        finally {
            this.restoreContextStack();
        }
    }

    public final ResultSet executeQuery() throws SQLException {
        try {
            this.executeStatement(this.activation, true, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        if (this.results == null) {
            SanityManager.THROWASSERT("no results returned on executeQuery()");
        }
        return this.results;
    }

    public final int executeUpdate() throws SQLException {
        try {
            this.executeStatement(this.activation, false, true);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        return this.updateCount;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkForSupportedDataType(sqlType);
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(jdbcTypeId, sqlType)) {
            throw this.dataTypeConversion(parameterIndex, Util.typeName(sqlType));
        }
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setToNull();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkAsciiStreamConditions(parameterIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.setCharacterStreamInternal(parameterIndex, r, false, length);
    }

    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Util.notImplemented("setUnicodeStream");
    }

    public final void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkCharacterStreamConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, false, length);
    }

    public final void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    private final void checkCharacterStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.Reader");
        }
    }

    private final void checkAsciiStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.InputStream(ASCII)");
        }
    }

    private void setCharacterStreamInternal(int parameterIndex, Reader reader, boolean lengthLess, long length) throws SQLException {
        if (!lengthLess && length < 0L) {
            throw this.newSQLException("XJ025.S");
        }
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (reader == null) {
            this.setNull(parameterIndex, jdbcTypeId);
            return;
        }
        if (!lengthLess && length > Integer.MAX_VALUE) {
            throw this.newSQLException("22003", this.getParameterSQLType(parameterIndex));
        }
        try {
            ReaderToUTF8Stream utfIn;
            int colWidth;
            ParameterValueSet pvs = this.getParms();
            DataTypeDescriptor[] dtd = this.preparedStatement.getParameterTypes();
            int usableLength = colWidth = dtd[parameterIndex - 1].getMaximumWidth();
            if (!lengthLess) {
                int intLength = (int)length;
                int truncationLength = 0;
                usableLength = intLength;
                if (jdbcTypeId == 2005 && intLength > colWidth) {
                    usableLength = colWidth;
                    truncationLength = intLength - usableLength;
                }
                utfIn = new ReaderToUTF8Stream(reader, usableLength, truncationLength, this.getParameterSQLType(parameterIndex));
            } else {
                utfIn = new ReaderToUTF8Stream(reader, colWidth, this.getParameterSQLType(parameterIndex));
            }
            pvs.getParameterForSet(parameterIndex - 1).setValue(utfIn, usableLength);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkBinaryStreamConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, x, true, -1L);
    }

    public final void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkBinaryStreamConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, x, false, length);
    }

    public final void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    private void setBinaryStreamInternal(int parameterIndex, InputStream x, boolean lengthLess, long length) throws SQLException {
        if (!lengthLess && length < 0L) {
            throw this.newSQLException("XJ025.S");
        }
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, jdbcTypeId);
            return;
        }
        if (!lengthLess && length > Integer.MAX_VALUE) {
            throw this.newSQLException("22003", this.getEmbedParameterSetMetaData().getParameterTypeName(parameterIndex));
        }
        try {
            RawToBinaryFormatStream rawStream;
            if (lengthLess) {
                length = -1L;
                DataTypeDescriptor[] dtd = this.preparedStatement.getParameterTypes();
                rawStream = new RawToBinaryFormatStream(x, dtd[parameterIndex - 1].getMaximumWidth(), dtd[parameterIndex - 1].getTypeName());
            } else {
                rawStream = new RawToBinaryFormatStream(x, (int)length);
            }
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(rawStream, (int)length);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    private final void checkBinaryStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.InputStream");
        }
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.addElement(this.getParms().getClone());
            this.clearParameters();
        }
    }

    boolean executeBatchElement(Object batchElement) throws SQLException, StandardException {
        ParameterValueSet temp = (ParameterValueSet)batchElement;
        int numberOfParameters = temp.getParameterCount();
        for (int j = 0; j < numberOfParameters; ++j) {
            temp.getParameter(j).setInto(this, j + 1);
        }
        return super.executeStatement(this.activation, false, true);
    }

    public void clearParameters() throws SQLException {
        this.checkStatus();
        ParameterValueSet pvs = this.getParms();
        if (pvs != null) {
            pvs.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            ExecPreparedStatement execp = (ExecPreparedStatement)this.preparedStatement;
            this.setupContextStack();
            try {
                ResultDescription resd;
                if (!this.preparedStatement.isValid()) {
                    this.preparedStatement.rePrepare(this.lcc);
                    this.rMetaData = null;
                }
                if (this.gcDuringGetMetaData == null || !this.gcDuringGetMetaData.equals(execp.getActivationClass().getName())) {
                    this.rMetaData = null;
                    this.gcDuringGetMetaData = execp.getActivationClass().getName();
                }
                if (this.rMetaData == null && (resd = this.preparedStatement.getResultDescription()) != null) {
                    String statementType = resd.getStatementType();
                    this.rMetaData = statementType.equals("INSERT") || statementType.equals("UPDATE") || statementType.equals("DELETE") ? null : this.newEmbedResultSetMetaData(resd);
                }
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
        return this.rMetaData;
    }

    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        this.checkForSupportedDataType(targetSqlType);
        int paramJDBCType = this.getParameterJDBCType(parameterIndex);
        if (paramJDBCType != 2000 && !DataTypeDescriptor.isJDBCTypeEquivalent(paramJDBCType, targetSqlType)) {
            throw this.dataTypeConversion(parameterIndex, Util.typeName(targetSqlType));
        }
        this.setObject(parameterIndex, x);
        if (paramJDBCType == 3 || paramJDBCType == 2) {
            this.setScale(parameterIndex, scale);
        }
    }

    public final void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    public final void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkStatus();
        int colType = this.getParameterJDBCType(parameterIndex);
        if (x == null) {
            throw this.dataTypeConversion(parameterIndex, "null");
        }
        if (colType == 2000) {
            try {
                this.getParms().setParameterAsObject(parameterIndex - 1, x);
                return;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
            return;
        }
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        }
        if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
            return;
        }
        if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
            return;
        }
        if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
            return;
        }
        if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
            return;
        }
        if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
            return;
        }
        if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
            return;
        }
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
            return;
        }
        if (this.setObjectConvert(parameterIndex, x)) {
            return;
        }
        throw this.dataTypeConversion(parameterIndex, x.getClass().getName());
    }

    boolean setObjectConvert(int parameterIndex, Object x) throws SQLException {
        return false;
    }

    public final boolean execute() throws SQLException {
        boolean ret = false;
        try {
            ret = this.executeStatement(this.activation, false, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        return ret;
    }

    public final void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public final void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public final void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.checkBlobConditions(i);
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            long streamLength = x.length();
            this.setBinaryStreamInternal(i, x.getBinaryStream(), false, streamLength);
        }
    }

    private final void checkClobConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(parameterIndex) != 2005) {
            throw this.dataTypeConversion(parameterIndex, "java.sql.Clob");
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.checkClobConditions(i);
        if (x == null) {
            this.setNull(i, 2005);
        } else {
            long streamLength = x.length();
            this.setCharacterStreamInternal(i, x.getCharacterStream(), false, streamLength);
        }
    }

    public final ParameterValueSet getParms() {
        return this.activation.getParameterValueSet();
    }

    protected final DataTypeDescriptor[] getTypes(int parameterIndex) throws SQLException {
        DataTypeDescriptor[] types = this.preparedStatement.getParameterTypes();
        if (types == null) {
            throw this.newSQLException("07009");
        }
        if (parameterIndex < 1 || parameterIndex > types.length) {
            throw this.newSQLException("XCL13.S", new Integer(parameterIndex), new Integer(types.length));
        }
        return types;
    }

    protected int getParameterJDBCType(int parameterIndex) throws SQLException {
        DataTypeDescriptor[] types = this.getTypes(parameterIndex);
        int type = types[parameterIndex - 1] == null ? 1111 : types[parameterIndex - 1].getTypeId().getJDBCTypeId();
        return type;
    }

    protected final String getParameterSQLType(int parameterIndex) throws SQLException {
        DataTypeDescriptor[] pTypes = this.getTypes(parameterIndex);
        return pTypes[parameterIndex - 1].getTypeName();
    }

    private void setScale(int parameterIndex, int scale) throws SQLException {
        this.checkStatus();
        if (scale < 0) {
            throw this.newSQLException("XJ044.S", new Integer(scale));
        }
        try {
            ParameterValueSet pvs = this.getParms();
            DataValueDescriptor value = pvs.getParameter(parameterIndex - 1);
            int origvaluelen = value.getLength();
            ((VariableSizeDataValue)((Object)value)).setWidth(-1, scale, false);
            if (value.getLength() < origvaluelen) {
                this.activation.addWarning(StandardException.newWarning("01505", value.getString()));
            }
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    private EngineParameterMetaData getEmbedParameterSetMetaData() throws SQLException {
        this.checkExecStatus();
        return new EmbedParameterSetMetaData(this.getParms(), this.preparedStatement.getParameterTypes());
    }

    public final void setURL(int parameterIndex, URL x) throws SQLException {
        throw Util.notImplemented();
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDesc) {
        return this.factory.newEmbedResultSetMetaData(resultDesc.getColumnInfo());
    }

    public String toString() {
        if (this.activation != null) {
            return this.activation.getPreparedStatement().getObjectName();
        }
        return super.toString();
    }

    public void transferParameters(EmbedPreparedStatement newStatement) throws SQLException {
        try {
            newStatement.activation.setParameters(this.getParms(), this.preparedStatement.getParameterTypes());
        }
        catch (StandardException se) {
            throw EmbedResultSet.noStateChangeException(se);
        }
    }

    boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate) throws SQLException {
        this.checkExecStatus();
        this.checkIfInMiddleOfBatch();
        this.clearResultSets();
        return super.executeStatement(a, executeQuery, executeUpdate);
    }

    final SQLException dataTypeConversion(int column, String sourceType) throws SQLException {
        SQLException se = this.newSQLException("22005", this.getEmbedParameterSetMetaData().getParameterTypeName(column), sourceType);
        return se;
    }

    public void setBrokeredConnectionControl(BrokeredConnectionControl control) {
        this.bcc = control;
    }

    private void checkStatementValidity(SQLException sqle) throws SQLException {
        if (this.bcc != null && this.isClosed()) {
            this.bcc.onStatementErrorOccurred((PreparedStatement)((Object)this.applicationStatement), sqle);
        }
        throw sqle;
    }

    private void checkForSupportedDataType(int dataType) throws SQLException {
        switch (dataType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw this.newSQLException("0A000.S.7", Util.typeName(dataType));
            }
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkAsciiStreamConditions(parameterIndex);
        InputStreamReader asciiStream = null;
        if (x != null) {
            try {
                asciiStream = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.setCharacterStreamInternal(parameterIndex, asciiStream, true, -1L);
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkCharacterStreamConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, true, -1L);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClobConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, true, -1L);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClobConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, false, length);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkBlobConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, inputStream, true, -1L);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkBlobConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, inputStream, false, length);
    }

    private final void checkBlobConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(parameterIndex) != 2004) {
            throw this.dataTypeConversion(parameterIndex, "java.sql.Blob");
        }
    }
}

