/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.memory.LowMemory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnectionContext;
import org.apache.derby.impl.jdbc.EmbedSQLWarning;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import org.apache.derby.jdbc.InternalDriver;

public abstract class EmbedConnection
implements EngineConnection {
    private static final StandardException exceptionClose = StandardException.closeException();
    public static final SQLException NO_MEM = Util.generateCsSQLException("08004", "java.lang.OutOfMemoryError");
    public static final LowMemory memoryState = new LowMemory();
    DatabaseMetaData dbMetadata;
    TransactionResourceImpl tr;
    private HashMap lobHashMap = null;
    private int lobHMKey = 0;
    private boolean active;
    boolean autoCommit = true;
    boolean needCommit;
    private boolean usingNoneAuth;
    private int connectionHoldAbility = 1;
    final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    private InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String connString;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_SHUTDOWN = 1;
    private static final int OP_HARD_UPGRADE = 2;

    public EmbedConnection(InternalDriver driver, String url, Properties info) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = driver;
        this.tr = new TransactionResourceImpl(driver, url, info);
        this.active = true;
        this.setupContextStack();
        try {
            EmbedConnectionContext context = this.pushConnectionContext(this.tr.getContextManager());
            boolean shutdown = Boolean.valueOf(info.getProperty("shutdown"));
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", this.tr.getDBName());
            boolean createBoot = this.createBoot(info);
            boolean isTwoPhaseEncryptionBoot = !createBoot && this.isEncryptionBoot(info);
            boolean isTwoPhaseUpgradeBoot = !createBoot && this.isHardUpgradeBoot(info);
            Properties savedInfo = null;
            if (database != null) {
                this.tr.setDatabase(database);
                isTwoPhaseEncryptionBoot = false;
                isTwoPhaseUpgradeBoot = false;
            } else if (!shutdown) {
                if (isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot) {
                    savedInfo = info;
                    info = this.removePhaseTwoProps((Properties)info.clone());
                }
                if (!this.bootDatabase(info, isTwoPhaseUpgradeBoot)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
            }
            if (createBoot && !shutdown) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(null, info);
                    database = this.createDatabase(this.tr.getDBName(), info);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                String dbname = this.tr.getDBName();
                this.setInactive();
                throw this.newSQLException("XJ004.C", dbname);
            }
            this.checkUserCredentials(this.tr.getDBName(), info);
            this.tr.startTransaction();
            if (isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(isTwoPhaseEncryptionBoot ? 0 : 2);
                }
                info = savedInfo;
                this.handleException(this.tr.shutdownDatabaseException());
                this.restoreContextStack();
                this.tr = new TransactionResourceImpl(driver, url, info);
                this.active = true;
                this.setupContextStack();
                context = this.pushConnectionContext(this.tr.getContextManager());
                if (!this.bootDatabase(info, false)) {
                    SanityManager.THROWASSERT("bootDatabase failed after initial plain boot for (re)encryption or upgrade");
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
                this.tr.startTransaction();
            }
            if (shutdown) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                throw this.tr.shutdownDatabaseException();
            }
            if (this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J14"));
            }
        }
        catch (OutOfMemoryError noMemory) {
            this.restoreContextStack();
            this.tr.lcc = null;
            this.tr.cm = null;
            memoryState.setLowMemory();
            throw NO_MEM;
        }
        catch (Throwable t) {
            StandardException se;
            if (t instanceof StandardException && (se = (StandardException)t).getSeverity() < 40000) {
                se.setSeverity(40000);
            }
            this.tr.cleanupOnError(t);
            throw this.handleException(t);
        }
        finally {
            this.restoreContextStack();
        }
    }

    private boolean createBoot(Properties p) throws SQLException {
        int createCount = 0;
        if (Boolean.valueOf(p.getProperty("create")).booleanValue()) {
            ++createCount;
        }
        int restoreCount = 0;
        if (p.getProperty("createFrom") != null) {
            ++restoreCount;
        }
        if (p.getProperty("restoreFrom") != null) {
            ++restoreCount;
        }
        if (p.getProperty("rollForwardRecoveryFrom") != null) {
            ++restoreCount;
        }
        if (restoreCount > 1) {
            throw this.newSQLException("XJ081.C");
        }
        if (restoreCount != 0 && this.isEncryptionBoot(p)) {
            throw this.newSQLException("XJ081.C");
        }
        if ((createCount += restoreCount) > 1) {
            throw this.newSQLException("XJ049.C");
        }
        return createCount - restoreCount == 1;
    }

    private boolean isEncryptionBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("dataEncryption")) != false || p.getProperty("newBootPassword") != null || p.getProperty("newEncryptionKey") != null;
    }

    private boolean isHardUpgradeBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("upgrade"));
    }

    private Properties removePhaseTwoProps(Properties p) {
        p.remove("dataEncryption");
        p.remove("newBootPassword");
        p.remove("newEncryptionKey");
        p.remove("upgrade");
        return p;
    }

    public EmbedConnection(EmbedConnection inputConnection) {
        SanityManager.ASSERT(inputConnection.active, "trying to create a proxy for an inactive conneciton");
        this.autoCommit = false;
        this.tr = null;
        this.active = true;
        this.rootConnection = inputConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = inputConnection.factory;
        this.connectionHoldAbility = inputConnection.connectionHoldAbility;
    }

    private void checkUserCredentials(String dbname, Properties userInfo) throws SQLException {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        AuthenticationService authenticationService = null;
        authenticationService = dbname == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        if (authenticationService == null) {
            String failedString = MessageService.getTextMessage(dbname == null ? "A001" : "A002");
            throw this.newSQLException("08004", failedString);
        }
        if (!authenticationService.authenticate(dbname, userInfo)) {
            throw this.newSQLException("08004", MessageService.getTextMessage("A020"));
        }
        if (authenticationService instanceof NoneAuthenticationServiceImpl) {
            this.usingNoneAuth = true;
        }
    }

    private void checkIsDBOwner(int operation) throws SQLException {
        String dbOwnerId;
        LanguageConnectionContext lcc = this.getLanguageConnection();
        String actualId = lcc.getAuthorizationId();
        if (!actualId.equals(dbOwnerId = lcc.getDataDictionary().getAuthorizationDatabaseOwner())) {
            switch (operation) {
                case 0: {
                    throw this.newSQLException("08004.C.5", actualId, this.tr.getDBName());
                }
                case 1: {
                    throw this.newSQLException("08004.C.4", actualId, this.tr.getDBName());
                }
                case 2: {
                    throw this.newSQLException("08004.C.6", actualId, this.tr.getDBName());
                }
            }
            SanityManager.THROWASSERT("illegal checkIsDBOwner operation");
            throw this.newSQLException("08004.C.3");
        }
    }

    public int getEngineType() {
        Database db = this.getDatabase();
        if (null == db) {
            return 0;
        }
        return db.getEngineType();
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility);
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability);
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnIndexes == null ? 2 : 1, columnIndexes, null);
    }

    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnNames == null ? 2 : 1, null, columnNames);
    }

    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, autoGeneratedKeys, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            PreparedStatement preparedStatement;
            this.setupContextStack();
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, sql, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return preparedStatement;
        }
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.connectionHoldAbility);
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            CallableStatement callableStatement;
            this.setupContextStack();
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, sql, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkIfClosed();
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && autoCommit) {
            throw this.newSQLException("XJ030.S");
        }
        if (this.autoCommit != autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().rollback();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    public void close() throws SQLException {
        if (!(this.isClosed() || this.rootConnection != this || this.autoCommit || this.transactionIsIdle())) {
            throw this.newSQLException("25000");
        }
        this.close(exceptionClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(StandardException e) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rootConnection == this && this.active) {
                if (this.tr.isActive()) {
                    this.setupContextStack();
                    try {
                        this.tr.rollback();
                        this.tr.clearLcc();
                        this.tr.cleanupOnError(e);
                    }
                    catch (Throwable t) {
                        throw this.handleException(t);
                    }
                    finally {
                        this.restoreContextStack();
                    }
                } else {
                    this.tr.clearLcc();
                    this.tr.cleanupOnError(e);
                }
            }
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
    }

    public final boolean isClosed() {
        return !this.active || !this.getTR().isActive();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    public final int getHoldability() throws SQLException {
        this.checkIfClosed();
        return this.connectionHoldAbility;
    }

    public final void setHoldability(int holdability) throws SQLException {
        this.checkIfClosed();
        this.connectionHoldAbility = holdability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadOnly(boolean readOnly) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setReadOnly(readOnly);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        return this.getLanguageConnection().isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkIfClosed();
    }

    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int level) throws SQLException {
        int iLevel;
        if (level == this.getTransactionIsolation()) {
            return;
        }
        switch (level) {
            case 1: {
                iLevel = 1;
                break;
            }
            case 2: {
                iLevel = 2;
                break;
            }
            case 4: {
                iLevel = 3;
                break;
            }
            case 8: {
                iLevel = 4;
                break;
            }
            default: {
                throw this.newSQLException("XJ045.S", new Integer(level));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setIsolationLevel(iLevel);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getLanguageConnection().getCurrentIsolationLevel()];
    }

    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.topWarning;
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.topWarning = null;
    }

    public Map getTypeMap() throws SQLException {
        this.checkIfClosed();
        return Collections.EMPTY_MAP;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.Connection.setTypeMap");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
    }

    public final synchronized void addWarning(SQLWarning newWarning) {
        if (this.topWarning == null) {
            this.topWarning = newWarning;
            return;
        }
        this.topWarning.setNextWarning(newWarning);
    }

    public String getDBName() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getLcc();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    SQLException handleException(Throwable thrownException) throws SQLException {
        if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(thrownException, this.autoCommit, true);
    }

    final SQLException handleException(Throwable thrownException, boolean rollbackOnAutoCommit) throws SQLException {
        if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(thrownException, this.autoCommit, rollbackOnAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.active = false;
            this.dbMetadata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.rootConnection == this) {
                this.close(exceptionClose);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    protected final void setupContextStack() throws SQLException {
        this.checkIfClosed();
        this.getTR().setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        Util.ASSERT(this, this.active || this.getTR().getCsf() != null, "No context service to do restore");
        TransactionResourceImpl tr = this.getTR();
        if (tr.getCsf() != null) {
            ContextManager cm2;
            ContextManager cm1 = tr.getCsf().getCurrentContextManager();
            Util.ASSERT(this, cm1 == (cm2 = tr.getContextManager()) || cm1 == null, "Current Context Manager not the one was expected: " + cm1 + " " + cm2);
        }
        tr.restoreContextStack();
    }

    private Database createDatabase(String dbname, Properties info) throws SQLException {
        info = this.filterProperties(info);
        try {
            if (Monitor.createPersistentService("org.apache.derby.database.Database", dbname, info) == null) {
                this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J01", dbname));
            }
        }
        catch (StandardException mse) {
            throw Util.seeNextException("XJ041.C", new Object[]{dbname}, this.handleException(mse));
        }
        info.clear();
        return (Database)Monitor.findService("org.apache.derby.database.Database", dbname);
    }

    private boolean bootDatabase(Properties info, boolean softAuthenticationBoot) throws Throwable {
        String dbname = this.tr.getDBName();
        try {
            info = this.filterProperties(info);
            if (softAuthenticationBoot) {
                info.setProperty("softUpgradeNoFeatureCheck", "true");
            } else {
                info.remove("softUpgradeNoFeatureCheck");
            }
            if (!Monitor.startPersistentService(dbname, info)) {
                return false;
            }
            info.clear();
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", dbname);
            this.tr.setDatabase(database);
        }
        catch (StandardException mse) {
            Throwable ne = mse.getCause();
            SQLException nse = ne instanceof StandardException ? Util.generateCsSQLException((StandardException)ne) : (ne != null ? Util.javaException(ne) : Util.generateCsSQLException(mse));
            throw Util.seeNextException("XJ040.C", new Object[]{dbname}, nse);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareMetaDataStatement(String sql) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement s = null;
            try {
                s = this.factory.newEmbedPreparedStatement(this, sql, true, 1003, 1007, this.connectionHoldAbility, 2, null, null);
            }
            finally {
                this.restoreContextStack();
            }
            return s;
        }
    }

    public final InternalDriver getLocalDriver() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties inputSet) {
        Properties limited = new Properties();
        Enumeration<?> e = inputSet.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("derby.")) continue;
            limited.put(key, inputSet.getProperty(key));
        }
        return limited;
    }

    protected Database getDatabase() {
        SanityManager.ASSERT(!this.isClosed(), "connection is closed");
        return this.getTR().getDatabase();
    }

    protected final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager cm) {
        return new EmbedConnectionContext(cm, this);
    }

    public final void setApplicationConnection(Connection applicationConnection) {
        this.applicationConnection = applicationConnection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    public void setDrdaID(String drdaID) {
        this.getLanguageConnection().setDrdaID(drdaID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFromPool() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().resetFromPool();
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                XATransactionController tc = (XATransactionController)this.getLanguageConnection().getTransactionExecute();
                int ret = tc.xa_prepare();
                if (ret == 1) {
                    this.getLanguageConnection().internalCommit(false);
                }
                int n = ret;
                return n;
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean onePhase) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaCommit(onePhase);
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaRollback();
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int resultSetType) {
        if (resultSetType == 1005) {
            this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J02"));
            resultSetType = 1004;
        }
        return resultSetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrepareIsolation(int level) throws SQLException {
        if (level == this.getPrepareIsolation()) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw Util.generateCsSQLException("XJ045.S", new Integer(level));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.getLanguageConnection().setPrepareIsolationLevel(level);
        }
    }

    public int getPrepareIsolation() {
        return this.getLanguageConnection().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    protected SQLException newSQLException(String messageId) {
        return Util.generateCsSQLException(messageId);
    }

    protected SQLException newSQLException(String messageId, Object arg1) {
        return Util.generateCsSQLException(messageId, arg1);
    }

    protected SQLException newSQLException(String messageId, Object arg1, Object arg2) {
        return Util.generateCsSQLException(messageId, arg1, arg2);
    }

    public String toString() {
        if (this.connString == null) {
            LanguageConnectionContext lcc = this.getLanguageConnection();
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "(XID = " + lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + Integer.toString(lcc.getInstanceNumber()) + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + ") ";
        }
        return this.connString;
    }

    public Clob createClob() throws SQLException {
        this.checkIfClosed();
        return new EmbedClob(this);
    }

    public Blob createBlob() throws SQLException {
        this.checkIfClosed();
        return new EmbedBlob(new byte[0], this);
    }

    public int addLOBMapping(Object LOBReference) {
        int loc = this.getIncLOBKey();
        this.getlobHMObj().put(new Integer(loc), LOBReference);
        return loc;
    }

    public void removeLOBMapping(int key) {
        this.getlobHMObj().remove(new Integer(key));
    }

    public Object getLOBMapping(int key) {
        return this.getlobHMObj().get(new Integer(key));
    }

    public void clearLOBMapping() throws SQLException {
        if (this.rootConnection.lobHashMap != null) {
            Iterator e = this.getlobHMObj().values().iterator();
            while (e.hasNext()) {
                ConnectionChild temp;
                Object obj = e.next();
                if (obj instanceof Clob) {
                    temp = (EmbedClob)obj;
                    ((EmbedClob)temp).free();
                }
                if (!(obj instanceof Blob)) continue;
                temp = (EmbedBlob)obj;
                ((EmbedBlob)temp).free();
            }
            this.getlobHMObj().clear();
        }
    }

    private int getIncLOBKey() {
        return ++this.rootConnection.lobHMKey;
    }

    public HashMap getlobHMObj() {
        if (this.rootConnection.lobHashMap == null) {
            this.rootConnection.lobHashMap = new HashMap();
        }
        return this.rootConnection.lobHashMap;
    }

    public void cancelRunningStatement() {
        this.getLanguageConnection().getStatementContext().cancel();
    }
}

