/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.ClobAsciiStream;
import org.apache.derby.impl.jdbc.ClobUpdatableReader;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.StoreStreamClob;
import org.apache.derby.impl.jdbc.TemporaryClob;
import org.apache.derby.impl.jdbc.Util;

final class EmbedClob
extends ConnectionChild
implements Clob {
    private InternalClob clob;
    private boolean isValid = true;

    EmbedClob(EmbedConnection con) throws SQLException {
        super(con);
        this.clob = new TemporaryClob(con.getDBName(), this);
        con.addLOBMapping(this);
    }

    protected EmbedClob(EmbedConnection con, DataValueDescriptor dvd) throws StandardException {
        super(con);
        SanityManager.ASSERT(!dvd.isNull(), "clob is created on top of a null column");
        InputStream storeStream = dvd.getStream();
        if (storeStream == null) {
            try {
                this.clob = new TemporaryClob(con.getDBName(), dvd.getString(), this);
            }
            catch (SQLException sqle) {
                throw StandardException.newException(sqle.getSQLState(), sqle);
            }
            catch (IOException e) {
                throw StandardException.newException("XJ022.S", e);
            }
        }
        SanityManager.ASSERT(storeStream instanceof Resetable);
        try {
            this.clob = new StoreStreamClob(storeStream, this);
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("40XD0")) {
                throw StandardException.newException("XJ073.S");
            }
            throw se;
        }
        con.addLOBMapping(this);
    }

    public long length() throws SQLException {
        this.checkValidity();
        try {
            return this.clob.getCharLength();
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    public String getSubString(long pos, int length) throws SQLException {
        String result;
        this.checkValidity();
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        if (length < 0) {
            throw Util.generateCsSQLException("XJ071.S", new Integer(length));
        }
        try {
            int charsRead;
            int read;
            Reader reader = this.clob.getReader(pos);
            char[] chars = new char[length];
            for (charsRead = 0; charsRead < length && (read = reader.read(chars, charsRead, length - charsRead)) != -1; charsRead += read) {
            }
            reader.close();
            result = charsRead == 0 ? "" : String.copyValueOf(chars, 0, charsRead);
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", eofe);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
        return result;
    }

    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            return new ClobUpdatableReader(this);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        return new ReaderToAscii(this.getCharacterStream());
    }

    /*
     * Exception decompiling
     */
    public long position(String searchStr, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public long position(Clob searchClob, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkValidity();
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            this.clob.insertString(str.substring(offset, offset + len), pos);
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        return str.length();
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            return new ClobAsciiStream(this.clob.getWriter(pos));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone();
            }
            return this.clob.getWriter(pos);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    public void truncate(long len) throws SQLException {
        this.checkValidity();
        if (len < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(len));
        }
        try {
            if (!this.clob.isWritable()) {
                this.makeWritableClobClone(len);
            } else {
                this.clob.truncate(len);
            }
        }
        catch (EOFException eofe) {
            throw Util.generateCsSQLException("XJ076.S", new Long(len));
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
    }

    public void free() throws SQLException {
        if (this.isValid) {
            this.isValid = false;
            try {
                this.clob.release();
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
            finally {
                this.clob = null;
            }
        }
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidity();
        if (pos <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        if (length < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(length));
        }
        if (length > this.length() - pos) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(pos), new Long(length));
        }
        try {
            return new ClobUpdatableReader(this, pos - 1L, length);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    private void checkValidity() throws SQLException {
        this.localConn.checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    private void makeWritableClobClone() throws IOException, SQLException {
        InternalClob toBeAbandoned = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, toBeAbandoned);
        toBeAbandoned.release();
    }

    private void makeWritableClobClone(long len) throws IOException, SQLException {
        InternalClob toBeAbandoned = this.clob;
        this.clob = TemporaryClob.cloneClobContent(this.getEmbedConnection().getDBName(), this, toBeAbandoned, len);
        toBeAbandoned.release();
    }

    InternalClob getInternalClob() {
        return this.clob;
    }
}

