/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.jdbc.AutoPositioningStream;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derby.impl.jdbc.UpdatableBlobStream;
import org.apache.derby.impl.jdbc.Util;

final class EmbedBlob
extends ConnectionChild
implements Blob {
    private boolean materialized;
    private InputStream myStream;
    private long myLength;
    private long pos;
    private BinaryToRawStream biStream;
    private static int BLOB_BUF_SIZE = 4096;
    private byte[] buf;
    private boolean isValid;
    private LOBStreamControl control;

    EmbedBlob(byte[] blobBytes, EmbedConnection con) throws SQLException {
        super(con);
        this.myLength = -1L;
        this.isValid = true;
        try {
            this.control = new LOBStreamControl(con.getDBName(), blobBytes);
            this.materialized = true;
            con.addLOBMapping(this);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    protected EmbedBlob(DataValueDescriptor dvd, EmbedConnection con) throws StandardException {
        block6: {
            super(con);
            this.myLength = -1L;
            this.isValid = true;
            SanityManager.ASSERT(!dvd.isNull(), "blob is created on top of a null column");
            this.myStream = dvd.getStream();
            if (this.myStream == null) {
                this.materialized = true;
                byte[] dvdBytes = dvd.getBytes();
                SanityManager.ASSERT(dvdBytes != null, "blob has a null value underneath");
                try {
                    this.control = new LOBStreamControl(this.getEmbedConnection().getDBName(), dvdBytes);
                }
                catch (SQLException e) {
                    throw StandardException.newException(e.getSQLState());
                }
                catch (IOException e) {
                    throw StandardException.newException("XJ022.S", e);
                }
            }
            this.materialized = false;
            SanityManager.ASSERT(this.myStream instanceof Resetable);
            this.myStream = new PositionedStoreStream(this.myStream);
            try {
                ((Resetable)((Object)this.myStream)).initStream();
            }
            catch (StandardException se) {
                if (!se.getMessageId().equals("40XD0")) break block6;
                throw StandardException.newException("XJ073.S");
            }
        }
        this.buf = new byte[BLOB_BUF_SIZE];
        this.pos = 0L;
        con.addLOBMapping(this);
    }

    private void setPosition(long newPos) throws StandardException, IOException {
        SanityManager.ASSERT(newPos >= 0L);
        if (this.materialized) {
            this.pos = newPos;
        } else {
            ((Resetable)((Object)this.myStream)).resetStream();
            this.biStream = new BinaryToRawStream(this.myStream, this);
            this.pos = 0L;
            while (this.pos < newPos) {
                int size = this.biStream.read(this.buf, 0, (int)Math.min(newPos - this.pos, (long)BLOB_BUF_SIZE));
                if (size <= 0) {
                    throw StandardException.newException("XJ079.S");
                }
                this.pos += (long)size;
            }
        }
    }

    private int read() throws IOException, SQLException {
        int c;
        if (this.materialized) {
            try {
                if (this.pos >= this.control.getLength()) {
                    return -1;
                }
                c = this.control.read(this.pos);
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        } else {
            c = this.biStream.read();
        }
        ++this.pos;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long length() throws SQLException {
        block15: {
            this.checkValidity();
            try {
                if (this.materialized) {
                    return this.control.getLength();
                }
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
            if (this.myLength != -1L) {
                return this.myLength;
            }
            pushStack = false;
            var2_3 = this.getConnectionSynchronization();
            // MONITORENTER : var2_3
            v0 = pushStack = this.getEmbedConnection().isClosed() == false;
            if (pushStack) {
                this.setupContextStack();
            }
            this.setPosition(0L);
            this.myLength = this.biStream.getLength();
            if (this.myLength == -1L) break block15;
            this.biStream.close();
            var3_5 = this.myLength;
            // MONITOREXIT : var2_3
            if (pushStack == false) return var3_5;
            this.restoreContextStack();
            return var3_5;
        }
        while (true) {
            if ((size = this.biStream.read(this.buf)) == -1) {
                this.myLength = this.pos;
                this.biStream.close();
                var3_7 = this.pos;
                // MONITOREXIT : var2_3
                if (pushStack == false) return var3_7;
                ** break;
            }
            this.pos += (long)size;
        }
        {
            catch (Throwable t) {
                throw this.handleMyExceptions(t);
            }
        }
lbl40:
        // 1 sources

        this.restoreContextStack();
        return var3_7;
        catch (Throwable var6_8) {
            if (pushStack == false) throw var6_8;
            this.restoreContextStack();
            throw var6_8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(long startPos, int length) throws SQLException {
        this.checkValidity();
        boolean pushStack = false;
        try {
            byte[] result;
            if (startPos < 1L) {
                throw StandardException.newException("XJ070.S", new Long(startPos));
            }
            if (length < 0) {
                throw StandardException.newException("XJ071.S", new Integer(length));
            }
            if (this.materialized) {
                result = new byte[length];
                int sz = this.control.read(result, 0, result.length, startPos - 1L);
                if (sz == -1) {
                    byte[] byArray = new byte[]{};
                    return byArray;
                }
                if (sz < length) {
                    byte[] tmparray = new byte[sz];
                    System.arraycopy(result, 0, tmparray, 0, sz);
                    result = tmparray;
                }
            } else {
                Object object = this.getConnectionSynchronization();
                synchronized (object) {
                    boolean bl = pushStack = !this.getEmbedConnection().isClosed();
                    if (pushStack) {
                        this.setupContextStack();
                    }
                    this.setPosition(startPos - 1L);
                    result = new byte[length];
                    int n = InputStreamUtil.readLoop(this.biStream, result, 0, length);
                    this.pos += (long)n;
                    if (n < length) {
                        byte[] result2 = new byte[n];
                        System.arraycopy(result, 0, result2, 0, n);
                        byte[] byArray = result2;
                        return byArray;
                    }
                }
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (StandardException e) {
            if (!e.getMessageId().equals("XJ079.S")) throw this.handleMyExceptions(e);
            e = StandardException.newException("XJ076.S", new Long(startPos));
            throw this.handleMyExceptions(e);
        }
        catch (Throwable t) {
            throw this.handleMyExceptions(t);
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        this.checkValidity();
        boolean pushStack = false;
        try {
            if (this.materialized) {
                InputStream inputStream = this.control.getInputStream(0L);
                return inputStream;
            }
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                try {
                    boolean bl = pushStack = !this.getEmbedConnection().isClosed();
                    if (pushStack) {
                        this.setupContextStack();
                    }
                    ((Resetable)((Object)this.myStream)).resetStream();
                    UpdatableBlobStream updatableBlobStream = new UpdatableBlobStream(this, new AutoPositioningStream(this, this.myStream, this));
                    return updatableBlobStream;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw this.handleMyExceptions(t);
                    }
                }
            }
        }
        finally {
            if (pushStack) {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public long position(byte[] pattern, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 13[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(byte[] pattern) throws IOException, SQLException {
        for (int i = 1; i < pattern.length; ++i) {
            int b = this.read();
            if (b >= 0 && b == pattern[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public long position(Blob pattern, long start) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 15[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkMatch(Blob pattern) throws IOException, SQLException {
        int b2;
        InputStream pStream;
        try {
            pStream = pattern.getBinaryStream();
        }
        catch (SQLException e) {
            return false;
        }
        if (pStream == null) {
            return false;
        }
        int b1 = pStream.read();
        if (b1 < 0) {
            return false;
        }
        do {
            if ((b1 = pStream.read()) >= 0) continue;
            return true;
        } while (b1 == (b2 = this.read()) && b2 >= 0);
        return false;
    }

    private SQLException handleMyExceptions(Throwable t) throws SQLException {
        if (t instanceof StandardException && ((StandardException)t).getMessageId().equals("40XD0")) {
            t = StandardException.newException("XJ073.S");
        }
        return this.handleException(t);
    }

    protected void finalize() {
        if (!this.materialized) {
            ((Resetable)((Object)this.myStream)).closeStream();
        }
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkValidity();
        try {
            if (this.materialized) {
                if (pos - 1L > this.length()) {
                    throw Util.generateCsSQLException("XJ076.S", new Long(pos));
                }
                if (pos < 1L) {
                    throw Util.generateCsSQLException("XJ070.S", new Long(pos));
                }
                len = (int)this.control.write(bytes, offset, len, pos - 1L);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
                this.control.copyData(this.myStream, this.length());
                len = (int)this.control.write(bytes, offset, len, pos - 1L);
                this.myStream.close();
                this.materialized = true;
            }
            return len;
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkValidity();
        if (pos - 1L > this.length()) {
            throw Util.generateCsSQLException("XJ076.S", new Long(pos));
        }
        if (pos < 1L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        try {
            if (this.materialized) {
                return this.control.getOutputStream(pos - 1L);
            }
            this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
            this.control.copyData(this.myStream, pos - 1L);
            this.myStream.close();
            this.materialized = true;
            return this.control.getOutputStream(pos - 1L);
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    public void truncate(long len) throws SQLException {
        if (len > this.length()) {
            throw Util.generateCsSQLException("XJ079.S", new Long(this.pos));
        }
        try {
            if (this.materialized) {
                this.control.truncate(len);
            } else {
                this.control = new LOBStreamControl(this.getEmbedConnection().getDBName());
                this.control.copyData(this.myStream, len);
                this.myStream.close();
                this.materialized = true;
            }
        }
        catch (IOException e) {
            throw Util.setStreamFailure(e);
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    public void free() throws SQLException {
        if (!this.isValid) {
            return;
        }
        this.isValid = false;
        this.myLength = -1L;
        if (!this.materialized) {
            ((Resetable)((Object)this.myStream)).closeStream();
        } else {
            try {
                this.control.free();
                this.control = null;
            }
            catch (IOException e) {
                throw Util.setStreamFailure(e);
            }
        }
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkValidity();
        if (pos <= 0L) {
            throw Util.generateCsSQLException("XJ070.S", new Long(pos));
        }
        if (length < 0L) {
            throw Util.generateCsSQLException("XJ071.S", new Long(length));
        }
        if (length > this.length() - pos) {
            throw Util.generateCsSQLException("XJ087.S", (Object)new Long(pos), new Long(length));
        }
        try {
            return new UpdatableBlobStream(this, this.getBinaryStream(), pos - 1L, length);
        }
        catch (IOException ioe) {
            throw Util.setStreamFailure(ioe);
        }
    }

    private void checkValidity() throws SQLException {
        this.getEmbedConnection().checkIfClosed();
        if (!this.isValid) {
            throw this.newSQLException("XJ215.S");
        }
    }

    boolean isMaterialized() {
        return this.materialized;
    }
}

