/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.TemporaryClob;

final class ClobUtf8Writer
extends Writer {
    private TemporaryClob control;
    private long pos;
    private boolean closed;

    ClobUtf8Writer(TemporaryClob control, long pos) {
        this.control = control;
        this.pos = pos;
        this.closed = false;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
    }

    public void close() {
        this.closed = true;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            long ret = this.control.insertString(String.copyValueOf(cbuf, off, len), this.pos);
            if (ret > 0L) {
                this.pos += ret;
            }
        }
        catch (SQLException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

