/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.InternalClob;
import org.apache.derby.impl.jdbc.LOBInputStream;
import org.apache.derby.impl.jdbc.StoreStreamClob;
import org.apache.derby.impl.jdbc.UTF8Reader;

final class ClobUpdatableReader
extends Reader {
    private Reader streamReader;
    private long pos;
    private InputStream stream = null;
    private ConnectionChild conChild;
    private boolean materialized;
    private final EmbedClob clob;
    private final long maxPos;

    ClobUpdatableReader(LOBInputStream stream, ConnectionChild conChild) throws IOException {
        this.clob = null;
        this.materialized = true;
        this.conChild = conChild;
        this.stream = stream;
        this.maxPos = Long.MAX_VALUE;
        this.init(stream, 0L);
    }

    ClobUpdatableReader(EmbedClob clob) throws IOException, SQLException {
        this(clob, 0L, Long.MAX_VALUE);
    }

    ClobUpdatableReader(EmbedClob clob, long pos, long len) throws IOException, SQLException {
        this.clob = clob;
        this.conChild = clob;
        this.maxPos = pos + len;
        InternalClob internalClob = clob.getInternalClob();
        this.materialized = internalClob.isWritable();
        if (this.materialized) {
            long byteLength = internalClob.getByteLength();
            this.stream = internalClob.getRawByteStream();
            this.init((LOBInputStream)this.stream, pos);
        } else {
            SanityManager.ASSERT(internalClob instanceof StoreStreamClob, "Wrong type of internal clob representation: " + internalClob.toString());
            this.streamReader = internalClob.getReader(pos + 1L);
            this.pos = pos;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.updateIfRequired();
        if (this.pos >= this.maxPos) {
            return -1;
        }
        int actualLength = (int)Math.min((long)len, this.maxPos - this.pos);
        int ret = this.streamReader.read(cbuf, off, actualLength);
        if (ret >= 0) {
            this.pos += (long)ret;
        }
        return ret;
    }

    public void close() throws IOException {
        this.streamReader.close();
    }

    private void init(LOBInputStream stream, long skip) throws IOException {
        long skipBy;
        this.streamReader = new UTF8Reader(stream, 0L, stream.length(), this.conChild, this.conChild.getConnectionSynchronization());
        for (long remainToSkip = skip; remainToSkip > 0L; remainToSkip -= skipBy) {
            skipBy = this.streamReader.skip(remainToSkip);
            if (skipBy != 0L) continue;
            if (this.streamReader.read() == -1) {
                throw new EOFException(MessageService.getCompleteMessage("XJ085.S", new Object[0]));
            }
            skipBy = 1L;
        }
        this.pos = skip;
    }

    private void updateIfRequired() throws IOException {
        if (this.materialized) {
            LOBInputStream lobStream = (LOBInputStream)this.stream;
            if (lobStream.isObsolete()) {
                lobStream.reInitialize();
                this.init(lobStream, this.pos);
            }
        } else {
            SanityManager.ASSERT(this.clob != null, "Internal error while updating stream");
            if (this.clob.getInternalClob().isWritable()) {
                try {
                    this.stream = this.clob.getInternalClob().getRawByteStream();
                }
                catch (SQLException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    throw ioe;
                }
                this.init((LOBInputStream)this.stream, this.pos);
                this.materialized = true;
            }
        }
    }
}

