/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.text.Collator;
import java.text.DateFormat;
import java.text.RuleBasedCollator;
import java.util.Dictionary;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.DoubleProperties;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.db.DatabaseContextImpl;
import org.apache.derby.impl.db.StoreClassFactoryContext;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.io.StorageFile;

public class BasicDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    private boolean active;
    private AuthenticationService authenticationService;
    protected AccessFactory af;
    protected PropertyFactory pf;
    protected ClassFactory cfDB;
    private DataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private RuleBasedCollator ruleBasedCollator;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;

    public boolean canSupport(Properties startParams) {
        return Monitor.isDesiredCreateType(startParams, this.getEngineType());
    }

    public void boot(boolean create, Properties startParams) throws StandardException {
        ModuleFactory monitor = Monitor.getMonitor();
        if (create) {
            String localeID;
            if (startParams.getProperty("derby.__rt.storage.createWithNoLog") == null) {
                startParams.put("derby.__rt.storage.createWithNoLog", "true");
            }
            if ((localeID = startParams.getProperty("territory")) == null) {
                localeID = Locale.getDefault().toString();
            }
            this.databaseLocale = monitor.setLocale(startParams, localeID);
        } else {
            this.databaseLocale = monitor.getLocale(this);
        }
        this.setLocale(this.databaseLocale);
        this.bootValidation(create, startParams);
        DataValueFactory dvf = (DataValueFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.types.DataValueFactory", startParams);
        dvf.setLocale(this.databaseLocale);
        this.bootStore(create, startParams);
        this.myUUID = this.makeDatabaseID(create, startParams);
        DoubleProperties allParams = new DoubleProperties(this.getAllDatabaseProperties(), startParams);
        if (this.pf != null) {
            this.pf.addPropertySetNotification(this);
        }
        this.bootClassFactory(create, allParams);
        this.dd = (DataDictionary)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.dictionary.DataDictionary", allParams);
        this.lcf = (LanguageConnectionFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", allParams);
        this.lf = (LanguageFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.sql.LanguageFactory", allParams);
        this.bootResourceAdapter(create, allParams);
        this.authenticationService = this.bootAuthenticationService(create, allParams);
        SanityManager.ASSERT(this.authenticationService != null, "Failed to set the Authentication service for the database");
        if (create && this.lastToBoot && startParams.getProperty("derby.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public int getEngineType() {
        return 2;
    }

    public boolean isReadOnly() {
        return this.af.isReadOnly();
    }

    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        TransactionController tc = this.getConnectionTransaction(cm);
        cm.setLocaleFinder(this);
        this.pushDbContext(cm);
        LanguageConnectionContext lctx = this.lcf.newLanguageConnectionContext(cm, tc, this.lf, this, user, drdaID, dbname);
        this.pushClassFactoryContext(cm, this.lcf.getClassFactory());
        ExecutionFactory ef = this.lcf.getExecutionFactory();
        ef.newExecutionContext(cm);
        lctx.initialize();
        lctx.internalCommitNoSync(5);
        return lctx;
    }

    public final DataDictionary getDataDictionary() {
        return this.dd;
    }

    public void pushDbContext(ContextManager cm) {
        DatabaseContextImpl dc = new DatabaseContextImpl(cm, this);
    }

    public final AuthenticationService getAuthenticationService() {
        SanityManager.ASSERT(this.authenticationService != null, "Unexpected - There is no valid authentication service for the database!");
        return this.authenticationService;
    }

    public void freeze() throws SQLException {
        try {
            this.af.freeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public void unfreeze() throws SQLException {
        try {
            this.af.unfreeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public void backup(String backupDir, boolean wait) throws SQLException {
        try {
            this.af.backup(backupDir, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws SQLException {
        try {
            this.af.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public void checkpoint() throws SQLException {
        try {
            this.af.checkpoint();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public Locale getLocale() {
        return this.databaseLocale;
    }

    public final UUID getId() {
        return this.myUUID;
    }

    public Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw BasicDatabase.noLocale();
    }

    public RuleBasedCollator getCollator() throws StandardException {
        RuleBasedCollator retval = this.ruleBasedCollator;
        if (retval == null) {
            if (this.databaseLocale != null) {
                retval = this.ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.databaseLocale);
            } else {
                throw BasicDatabase.noLocale();
            }
        }
        return retval;
    }

    public DateFormat getDateFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
            }
            return this.dateFormat;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getTimeFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timeFormat == null) {
                this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
            }
            return this.timeFormat;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getTimestampFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timestampFormat == null) {
                this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
            }
            return this.timestampFormat;
        }
        throw BasicDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S");
    }

    public void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = null;
        this.timeFormat = null;
        this.timestampFormat = null;
    }

    public boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean create, Properties startParams) throws StandardException {
        TransactionController tc = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        String upgradeID = null;
        UUID databaseID = (UUID)tc.getProperty("derby.databaseID");
        if (databaseID == null) {
            UUIDFactory uuidFactory = Monitor.getMonitor().getUUIDFactory();
            upgradeID = startParams.getProperty("derby.databaseID");
            databaseID = upgradeID == null ? uuidFactory.createUUID() : uuidFactory.recreateUUID(upgradeID);
            tc.setProperty("derby.databaseID", databaseID, true);
        }
        if (upgradeID != null) {
            startParams.remove("derby.databaseID");
        }
        tc.commit();
        tc.destroy();
        return databaseID;
    }

    public void dropAllJDBCMetaDataSPSes() throws SQLException {
        try {
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            DataDictionary dd = lcc.getDataDictionary();
            TransactionController tc = lcc.getTransactionExecute();
            dd.startWriting(lcc);
            ListIterator li = dd.getAllSPSDescriptors().listIterator();
            while (li.hasNext()) {
                SPSDescriptor spsd = (SPSDescriptor)li.next();
                if (!spsd.getSchemaDescriptor().isSystemSchema() || spsd.getSchemaDescriptor().isSYSIBM()) continue;
                dd.dropSPSDescriptor(spsd, tc);
                dd.dropDependentsStoredDependencies(spsd.getUUID(), tc);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void init(boolean dbOnly, Dictionary p) {
    }

    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("derby.engineType")) {
            throw StandardException.newException("XCY02.S", (Object)key, (Object)value);
        }
        if (!key.equals("derby.database.classpath")) {
            return false;
        }
        String newClasspath = (String)((Object)value);
        String[][] dbcp = null;
        if (newClasspath != null) {
            dbcp = IdUtil.parseDbClassPath(newClasspath);
        }
        if (dbcp != null) {
            for (int ix = 0; ix < dbcp.length; ++ix) {
                SchemaDescriptor sd = this.dd.getSchemaDescriptor(dbcp[ix][0], null, false);
                FileInfoDescriptor fid = null;
                if (sd != null) {
                    fid = this.dd.getFileInfoDescriptor(sd, dbcp[ix][1]);
                }
                if (fid != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(dbcp[ix]));
            }
        }
        return true;
    }

    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.equals("derby.database.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String newClasspath = (String)((Object)value);
            if (newClasspath == null) {
                newClasspath = "";
            }
            this.cfDB.notifyModifyClasspath(newClasspath);
        }
        return null;
    }

    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.af.createFinished();
    }

    protected String getClasspath(Properties startParams) {
        String cp = PropertyUtil.getPropertyFromSet(startParams, "derby.database.classpath");
        if (cp == null) {
            cp = PropertyUtil.getSystemProperty("derby.database.classpath", "");
        }
        return cp;
    }

    protected void bootClassFactory(boolean create, Properties startParams) throws StandardException {
        String classpath = this.getClasspath(startParams);
        IdUtil.parseDbClassPath(classpath);
        startParams.put("derby.__rt.database.classpath", classpath);
        this.cfDB = (ClassFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.services.loader.ClassFactory", startParams);
    }

    protected TransactionController getConnectionTransaction(ContextManager cm) throws StandardException {
        return this.af.getTransaction(cm);
    }

    protected AuthenticationService bootAuthenticationService(boolean create, Properties props) throws StandardException {
        return (AuthenticationService)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.jdbc.AuthenticationService", props);
    }

    protected void bootValidation(boolean create, Properties startParams) throws StandardException {
        this.pf = (PropertyFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.services.property.PropertyFactory", startParams);
    }

    protected void bootStore(boolean create, Properties startParams) throws StandardException {
        this.af = (AccessFactory)Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.store.access.AccessFactory", startParams);
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        TransactionController tc = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        Properties dbProps = tc.getProperties();
        tc.commit();
        tc.destroy();
        return dbProps;
    }

    protected void bootResourceAdapter(boolean create, Properties allParams) {
        try {
            this.resourceAdapter = Monitor.bootServiceModule(create, this, "org.apache.derby.iapi.jdbc.ResourceAdapter", allParams);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager cm, ClassFactory cf) {
        new StoreClassFactoryContext(cm, cf, this.af, this);
    }

    public StorageFile getJarFile(String schemaName, String sqlName) throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(schemaName, null, true);
        FileInfoDescriptor fid = this.dd.getFileInfoDescriptor(sd, sqlName);
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)sqlName, (Object)schemaName);
        }
        long generationId = fid.getGenerationId();
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        FileResource fr = this.af.getTransaction(cm).getFileHandler();
        String externalName = JarUtil.mkExternalName(schemaName, sqlName, fr.getSeparatorChar());
        return fr.getAsFile(externalName, generationId);
    }
}

