/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public final class UTF8Util {
    private static final int CHAR_COUNT = 0;
    private static final int BYTE_COUNT = 1;

    private UTF8Util() {
    }

    public static final long skipUntilEOF(InputStream in) throws IOException {
        return UTF8Util.internalSkip(in, Long.MAX_VALUE)[0];
    }

    public static final long skipFully(InputStream in, long charsToSkip) throws EOFException, IOException {
        long[] counts = UTF8Util.internalSkip(in, charsToSkip);
        if (counts[0] != charsToSkip) {
            throw new EOFException("Reached end-of-stream prematurely at character/byte position " + counts[0] + "/" + counts[1] + ", trying to skip " + charsToSkip);
        }
        return counts[1];
    }

    private static final long[] internalSkip(InputStream in, long charsToSkip) throws IOException {
        int c;
        long charsSkipped = 0L;
        long bytesSkipped = 0L;
        while (charsSkipped < charsToSkip && (c = in.read()) != -1) {
            ++charsSkipped;
            if ((c & 0x80) == 0) {
                ++bytesSkipped;
                continue;
            }
            if ((c & 0x60) == 64) {
                if (UTF8Util.skipPersistent(in, 1L) != 1L) {
                    throw new UTFDataFormatException("Second byte in two byte character missing; byte pos " + bytesSkipped + " ; char pos " + charsSkipped);
                }
                bytesSkipped += 2L;
                continue;
            }
            if ((c & 0x70) == 96) {
                int skipped = 0;
                if (c == 224) {
                    int c1 = in.read();
                    int c2 = in.read();
                    if (c1 == 0 && c2 == 0) break;
                    if (c1 != -1 && c2 != -1) {
                        skipped = 2;
                    }
                } else {
                    skipped = (int)UTF8Util.skipPersistent(in, 2L);
                }
                if (skipped != 2) {
                    throw new UTFDataFormatException("Second or third byte in three byte character missing; byte pos " + bytesSkipped + " ; char pos " + charsSkipped);
                }
                bytesSkipped += 3L;
                continue;
            }
            throw new UTFDataFormatException("Invalid UTF-8 encoding encountered: (decimal) " + c);
        }
        return new long[]{--charsSkipped, bytesSkipped};
    }

    private static final long skipPersistent(InputStream in, long bytesToSkip) throws IOException {
        long skipped;
        long skippedNow;
        for (skipped = 0L; skipped < bytesToSkip; skipped += skippedNow) {
            skippedNow = in.skip(bytesToSkip - skipped);
            if (skippedNow > 0L) continue;
            if (in.read() == -1) break;
            skippedNow = 1L;
        }
        return skipped;
    }
}

