/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Locale;

public class StringUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String formatForPrint(String input) {
        if (input.length() > 60) {
            StringBuffer tmp = new StringBuffer(input.substring(0, 60));
            tmp.append("&");
            input = tmp.toString();
        }
        return input;
    }

    public static String[] toStringArray(Object[] objArray) {
        int len = objArray.length;
        String[] strArray = new String[len];
        for (int idx = 0; idx < len; ++idx) {
            strArray[idx] = objArray[idx].toString();
        }
        return strArray;
    }

    public static byte[] getAsciiBytes(String input) {
        char[] c = input.toCharArray();
        byte[] b = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            b[i] = (byte)(c[i] & 0x7F);
        }
        return b;
    }

    public static String trimTrailing(String str) {
        int len;
        if (str == null) {
            return null;
        }
        for (len = str.length(); len > 0 && Character.isWhitespace(str.charAt(len - 1)); --len) {
        }
        return str.substring(0, len);
    }

    public static String truncate(String value, int length) {
        if (value != null && value.length() > length) {
            value = value.substring(0, length);
        }
        return value;
    }

    public static String slice(String value, int beginOffset, int endOffset, boolean trim) {
        String retval = value.substring(beginOffset, endOffset + 1);
        if (trim) {
            retval = retval.trim();
        }
        return retval;
    }

    public static String toHexString(byte[] data, int offset, int length) {
        StringBuffer s = new StringBuffer(length * 2);
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            int high_nibble = (data[i] & 0xF0) >>> 4;
            int low_nibble = data[i] & 0xF;
            s.append(hex_table[high_nibble]);
            s.append(hex_table[low_nibble]);
        }
        return s.toString();
    }

    public static byte[] toHexByte(String str, int offset, int length) {
        byte[] data = new byte[(length - offset) * 2];
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            char ch = str.charAt(i);
            int high_nibble = (ch & 0xF0) >>> 4;
            int low_nibble = ch & 0xF;
            data[i] = (byte)high_nibble;
            data[i + 1] = (byte)low_nibble;
        }
        return data;
    }

    public static byte[] fromHexString(String s, int offset, int length) {
        if (length % 2 != 0) {
            return null;
        }
        byte[] byteArray = new byte[length / 2];
        int j = 0;
        int end = offset + length;
        for (int i = offset; i < end; i += 2) {
            int high_nibble = Character.digit(s.charAt(i), 16);
            int low_nibble = Character.digit(s.charAt(i + 1), 16);
            if (high_nibble == -1 || low_nibble == -1) {
                return null;
            }
            byteArray[j++] = (byte)(high_nibble << 4 & 0xF0 | low_nibble & 0xF);
        }
        return byteArray;
    }

    public static String hexDump(byte[] data) {
        StringBuffer str = new StringBuffer(data.length * 3);
        str.append("Hex dump:\n");
        for (int i = 0; i < data.length; i += 16) {
            int j;
            String offset = Integer.toHexString(i);
            for (int offlen = offset.length(); offlen < 8; ++offlen) {
                str.append("0");
            }
            str.append(offset);
            str.append(":");
            for (j = 0; j < 16 && i + j < data.length; ++j) {
                byte byte_value = data[i + j];
                if (j % 2 == 0) {
                    str.append(" ");
                }
                byte high_nibble = (byte)((byte_value & 0xF0) >>> 4);
                byte low_nibble = (byte)(byte_value & 0xF);
                str.append(hex_table[high_nibble]);
                str.append(hex_table[low_nibble]);
            }
            str.append("  ");
            for (j = 0; j < 16 && i + j < data.length; ++j) {
                char char_value = (char)data[i + j];
                if (Character.isLetterOrDigit(char_value)) {
                    str.append(String.valueOf(char_value));
                    continue;
                }
                str.append(".");
            }
            str.append("\n");
        }
        return str.toString();
    }

    public static String SQLToUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String s1, String s2) {
        if (s2 == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(s1).equals(StringUtil.SQLToUpperCase(s2));
    }
}

