/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class PrivilegedFileOps {
    public static boolean exists(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Boolean(file.exists());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    public static boolean isDirectory(final File file) throws SecurityException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Boolean(file.isDirectory());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    public static String[] list(final File directory) throws SecurityException {
        if (directory == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        try {
            return (String[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return directory.list();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }
}

