/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.UserDataValue;

public class UserType
extends DataType
implements UserDataValue {
    private Object value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(UserType.class);

    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += ClassSize.estimateAndCatalogBase(this.value.getClass());
        }
        return sz;
    }

    public String getString() {
        if (!this.isNull()) {
            return this.value.toString();
        }
        return null;
    }

    public boolean getBoolean() throws StandardException {
        if (!this.isNull() && this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return super.getBoolean();
    }

    public byte getByte() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return super.getByte();
    }

    public short getShort() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return super.getShort();
    }

    public int getInt() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return super.getInt();
    }

    public long getLong() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return super.getLong();
    }

    public float getFloat() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return super.getFloat();
    }

    public double getDouble() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return super.getDouble();
    }

    public byte[] getBytes() throws StandardException {
        if (!this.isNull() && this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return super.getBytes();
    }

    public Date getDate(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Date) {
                return (Date)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getDate(cal);
            }
        }
        return super.getDate(cal);
    }

    public Time getTime(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Time) {
                return (Time)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getTime(cal);
            }
        }
        return super.getTime(cal);
    }

    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Timestamp) {
                return (Timestamp)this.value;
            }
            if (this.value instanceof Date) {
                return new SQLDate((Date)this.value).getTimestamp(cal);
            }
            if (this.value instanceof Time) {
                return new SQLTime((Time)this.value).getTimestamp(cal);
            }
        }
        return super.getTimestamp(cal);
    }

    public Object getObject() {
        return this.value;
    }

    public int getLength() {
        return -1;
    }

    public String getTypeName() {
        return this.isNull() ? "JAVA_OBJECT" : ClassInspector.readableClassName(this.value.getClass());
    }

    String getTypeName(String className) {
        return className;
    }

    public int getTypeFormatId() {
        return 266;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull(), "writeExternal() is not supposed to be called for null values.");
        out.writeObject(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
    }

    public DataValueDescriptor getClone() {
        return new UserType(this.value);
    }

    public DataValueDescriptor getNewNull() {
        return new UserType();
    }

    public void restoreToNull() {
        this.value = null;
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getObject(colNumber);
    }

    public int compare(DataValueDescriptor other) throws StandardException {
        int comparison;
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        try {
            comparison = ((Comparable)this.value).compareTo(other.getObject());
        }
        catch (ClassCastException cce) {
            throw StandardException.newException("XCL15.S", (Object)this.getTypeName(), (Object)ClassInspector.readableClassName(other.getObject().getClass()));
        }
        if (comparison < 0) {
            comparison = -1;
        } else if (comparison > 0) {
            comparison = 1;
        }
        return comparison;
    }

    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        Object o;
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        if (!(op != 2 || this.isNull() || other.isNull() || (o = this.getObject()) instanceof Comparable)) {
            return o.equals(other.getObject());
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public UserType() {
    }

    public UserType(Object value) {
        this.value = value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getObject());
    }

    public void setBigDecimal(Number theValue) {
        this.setValue(theValue);
    }

    public void setValue(String theValue) {
        this.value = theValue == null ? null : theValue;
    }

    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(2, right, true, false));
    }

    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, !left.compare(2, right, true, false));
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.hashCode();
    }

    public int typePrecedence() {
        return 1000;
    }

    public final boolean isNull() {
        return this.value == null;
    }
}

