/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.DecimalTypeIdImpl;
import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.types.SQLBlob;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongVarbit;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLNClob;
import org.apache.derby.iapi.types.SQLNationalChar;
import org.apache.derby.iapi.types.SQLNationalLongvarchar;
import org.apache.derby.iapi.types.SQLNationalVarchar;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.iapi.types.XML;

public final class TypeId
implements Formatable {
    public static final int LONGINT_PRECISION = 19;
    public static final int LONGINT_SCALE = 0;
    public static final int LONGINT_MAXWIDTH = 8;
    public static final int INT_PRECISION = 10;
    public static final int INT_SCALE = 0;
    public static final int INT_MAXWIDTH = 4;
    public static final int SMALLINT_PRECISION = 5;
    public static final int SMALLINT_SCALE = 0;
    public static final int SMALLINT_MAXWIDTH = 2;
    public static final int TINYINT_PRECISION = 3;
    public static final int TINYINT_SCALE = 0;
    public static final int TINYINT_MAXWIDTH = 1;
    public static final int DOUBLE_PRECISION = 52;
    public static final int DOUBLE_PRECISION_IN_DIGITS = 15;
    public static final int DOUBLE_SCALE = 0;
    public static final int DOUBLE_MAXWIDTH = 8;
    public static final int REAL_PRECISION = 23;
    public static final int REAL_PRECISION_IN_DIGITS = 7;
    public static final int REAL_SCALE = 0;
    public static final int REAL_MAXWIDTH = 4;
    public static final int DECIMAL_PRECISION = 31;
    public static final int DECIMAL_SCALE = 31;
    public static final int DECIMAL_MAXWIDTH = 31;
    public static final int BOOLEAN_MAXWIDTH = 1;
    public static final int CHAR_MAXWIDTH = 254;
    public static final int VARCHAR_MAXWIDTH = 32672;
    public static final int LONGVARCHAR_MAXWIDTH = 32700;
    public static final int NATIONAL_CHAR_MAXWIDTH = Integer.MAX_VALUE;
    public static final int NATIONAL_VARCHAR_MAXWIDTH = Integer.MAX_VALUE;
    public static final int NATIONAL_LONGVARCHAR_MAXWIDTH = 32700;
    public static final int BIT_MAXWIDTH = 254;
    public static final int VARBIT_MAXWIDTH = 32672;
    public static final int LONGVARBIT_MAXWIDTH = 32700;
    public static final int BLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int CLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int NCLOB_MAXWIDTH = Integer.MAX_VALUE;
    public static final int XML_MAXWIDTH = Integer.MAX_VALUE;
    public static final int DATE_MAXWIDTH = 10;
    public static final int TIME_MAXWIDTH = 8;
    public static final int TIMESTAMP_MAXWIDTH = 26;
    public static final int TIME_SCALE = 0;
    public static final int TIMESTAMP_SCALE = 6;
    public static final String BIT_NAME = "CHAR () FOR BIT DATA";
    public static final String VARBIT_NAME = "VARCHAR () FOR BIT DATA";
    public static final String LONGVARBIT_NAME = "LONG VARCHAR FOR BIT DATA";
    public static final String TINYINT_NAME = "TINYINT";
    public static final String SMALLINT_NAME = "SMALLINT";
    public static final String INTEGER_NAME = "INTEGER";
    public static final String LONGINT_NAME = "BIGINT";
    public static final String FLOAT_NAME = "FLOAT";
    public static final String REAL_NAME = "REAL";
    public static final String DOUBLE_NAME = "DOUBLE";
    public static final String NUMERIC_NAME = "NUMERIC";
    public static final String DECIMAL_NAME = "DECIMAL";
    public static final String CHAR_NAME = "CHAR";
    public static final String VARCHAR_NAME = "VARCHAR";
    public static final String LONGVARCHAR_NAME = "LONG VARCHAR";
    public static final String DATE_NAME = "DATE";
    public static final String TIME_NAME = "TIME";
    public static final String TIMESTAMP_NAME = "TIMESTAMP";
    public static final String BINARY_NAME = "BINARY";
    public static final String VARBINARY_NAME = "VARBINARY";
    public static final String LONGVARBINARY_NAME = "LONGVARBINARY";
    public static final String BOOLEAN_NAME = "BOOLEAN";
    public static final String REF_NAME = "REF";
    public static final String NATIONAL_CHAR_NAME = "NATIONAL CHAR";
    public static final String NATIONAL_VARCHAR_NAME = "NATIONAL CHAR VARYING";
    public static final String NATIONAL_LONGVARCHAR_NAME = "LONG NVARCHAR";
    public static final String BLOB_NAME = "BLOB";
    public static final String CLOB_NAME = "CLOB";
    public static final String NCLOB_NAME = "NCLOB";
    public static final String XML_NAME = "XML";
    public static final String ARRAY_NAME = "ARRAY";
    public static final String STRUCT_NAME = "STRUCT";
    public static final String DATALINK_NAME = "DATALINK";
    public static final String ROWID_NAME = "ROWID";
    public static final String SQLXML_NAME = "SQLXML";
    public static final int USER_PRECEDENCE = 1000;
    public static final int XML_PRECEDENCE = 180;
    public static final int BLOB_PRECEDENCE = 170;
    public static final int LONGVARBIT_PRECEDENCE = 160;
    public static final int VARBIT_PRECEDENCE = 150;
    public static final int BIT_PRECEDENCE = 140;
    public static final int BOOLEAN_PRECEDENCE = 130;
    public static final int TIME_PRECEDENCE = 120;
    public static final int TIMESTAMP_PRECEDENCE = 110;
    public static final int DATE_PRECEDENCE = 100;
    public static final int DOUBLE_PRECEDENCE = 90;
    public static final int REAL_PRECEDENCE = 80;
    public static final int DECIMAL_PRECEDENCE = 70;
    public static final int NUMERIC_PRECEDENCE = 69;
    public static final int LONGINT_PRECEDENCE = 60;
    public static final int INT_PRECEDENCE = 50;
    public static final int SMALLINT_PRECEDENCE = 40;
    public static final int TINYINT_PRECEDENCE = 30;
    public static final int REF_PRECEDENCE = 25;
    public static final int NATIONAL_LONGVARCHAR_PRECEDENCE = 18;
    public static final int NATIONAL_VARCHAR_PRECEDENCE = 17;
    public static final int NATIONAL_CHAR_PRECEDENCE = 16;
    public static final int CLOB_PRECEDENCE = 14;
    public static final int NCLOB_PRECEDENCE = 13;
    public static final int LONGVARCHAR_PRECEDENCE = 12;
    public static final int VARCHAR_PRECEDENCE = 10;
    public static final int CHAR_PRECEDENCE = 0;
    public static final TypeId BOOLEAN_ID = new TypeId(4, new BaseTypeIdImpl(16));
    public static final TypeId INTEGER_ID = new TypeId(7, new BaseTypeIdImpl(19));
    public static final TypeId CHAR_ID = new TypeId(5, new BaseTypeIdImpl(17));
    private static TypeId TINYINT_ID;
    private static TypeId SMALLINT_ID;
    private static TypeId LONGINT_ID;
    private static TypeId REAL_ID;
    private static TypeId DOUBLE_ID;
    private static TypeId DECIMAL_ID;
    private static TypeId NUMERIC_ID;
    private static TypeId VARCHAR_ID;
    private static TypeId NATIONAL_CHAR_ID;
    private static TypeId NATIONAL_LONGVARCHAR_ID;
    private static TypeId NATIONAL_VARCHAR_ID;
    private static TypeId DATE_ID;
    private static TypeId TIME_ID;
    private static TypeId TIMESTAMP_ID;
    private static TypeId BIT_ID;
    private static TypeId VARBIT_ID;
    private static TypeId REF_ID;
    private static TypeId LONGVARCHAR_ID;
    private static TypeId LONGVARBIT_ID;
    private static TypeId BLOB_ID;
    private static TypeId CLOB_ID;
    private static TypeId NCLOB_ID;
    private static TypeId XML_ID;
    static DataValueDescriptor decimalImplementation;
    private BaseTypeIdImpl baseTypeId;
    private int formatId;
    private boolean classNameWasDelimitedIdentifier;
    private boolean isBitTypeId;
    private boolean isLOBTypeId;
    private boolean isBooleanTypeId;
    private boolean isConcatableTypeId;
    private boolean isDecimalTypeId;
    private boolean isLongConcatableTypeId;
    private boolean isNumericTypeId;
    private boolean isRefTypeId;
    private boolean isStringTypeId;
    private boolean isFloatingPointTypeId;
    private boolean isRealTypeId;
    private boolean isDateTimeTimeStampTypeId;
    private boolean isUserDefinedTypeId;
    private int maxPrecision;
    private int maxScale;
    private int typePrecedence;
    private String javaTypeName;
    private int maxMaxWidth;

    public static TypeId getBuiltInTypeId(int JDBCTypeId) {
        TypeId ret = null;
        switch (JDBCTypeId) {
            case -6: {
                ret = TINYINT_ID;
                if (ret != null) break;
                ret = TINYINT_ID = new TypeId(195, new BaseTypeIdImpl(196));
                break;
            }
            case 5: {
                ret = SMALLINT_ID;
                if (ret != null) break;
                ret = SMALLINT_ID = new TypeId(10, new BaseTypeIdImpl(22));
                break;
            }
            case 4: {
                return INTEGER_ID;
            }
            case -5: {
                ret = LONGINT_ID;
                if (ret != null) break;
                ret = LONGINT_ID = new TypeId(11, new BaseTypeIdImpl(23));
                break;
            }
            case 7: {
                ret = REAL_ID;
                if (ret != null) break;
                ret = REAL_ID = new TypeId(8, new BaseTypeIdImpl(20));
                break;
            }
            case 6: 
            case 8: {
                ret = DOUBLE_ID;
                if (ret != null) break;
                ret = DOUBLE_ID = new TypeId(6, new BaseTypeIdImpl(18));
                break;
            }
            case 3: {
                ret = DECIMAL_ID;
                if (ret != null) break;
                ret = DECIMAL_ID = new TypeId(197, new DecimalTypeIdImpl());
                break;
            }
            case 2: {
                ret = NUMERIC_ID;
                if (ret != null) break;
                DecimalTypeIdImpl numericTypeIdImpl = new DecimalTypeIdImpl();
                numericTypeIdImpl.setNumericType();
                ret = NUMERIC_ID = new TypeId(197, numericTypeIdImpl);
                break;
            }
            case 1: {
                return CHAR_ID;
            }
            case 12: {
                ret = VARCHAR_ID;
                if (ret != null) break;
                ret = VARCHAR_ID = new TypeId(13, new BaseTypeIdImpl(25));
                break;
            }
            case 91: {
                ret = DATE_ID;
                if (ret != null) break;
                ret = DATE_ID = new TypeId(40, new BaseTypeIdImpl(32));
                break;
            }
            case 92: {
                ret = TIME_ID;
                if (ret != null) break;
                ret = TIME_ID = new TypeId(35, new BaseTypeIdImpl(33));
                break;
            }
            case 93: {
                ret = TIMESTAMP_ID;
                if (ret != null) break;
                ret = TIMESTAMP_ID = new TypeId(36, new BaseTypeIdImpl(34));
                break;
            }
            case -7: 
            case 16: {
                return BOOLEAN_ID;
            }
            case -2: {
                ret = BIT_ID;
                if (ret != null) break;
                ret = BIT_ID = new TypeId(27, new BaseTypeIdImpl(28));
                break;
            }
            case -3: {
                ret = VARBIT_ID;
                if (ret != null) break;
                ret = VARBIT_ID = new TypeId(29, new BaseTypeIdImpl(30));
                break;
            }
            case -4: {
                ret = LONGVARBIT_ID;
                if (ret != null) break;
                ret = LONGVARBIT_ID = new TypeId(232, new BaseTypeIdImpl(233));
                break;
            }
            case -1: {
                ret = LONGVARCHAR_ID;
                if (ret != null) break;
                ret = LONGVARCHAR_ID = new TypeId(230, new BaseTypeIdImpl(231));
                break;
            }
            case 2004: {
                ret = BLOB_ID;
                if (ret != null) break;
                ret = BLOB_ID = new TypeId(440, new BaseTypeIdImpl(442));
                break;
            }
            case 2005: {
                ret = CLOB_ID;
                if (ret != null) break;
                ret = CLOB_ID = new TypeId(444, new BaseTypeIdImpl(446));
                break;
            }
            case 456: {
                ret = XML_ID;
                if (ret != null) break;
                ret = XML_ID = new TypeId(456, new BaseTypeIdImpl(457));
            }
        }
        return ret;
    }

    public static TypeId getUserDefinedTypeId(String className, boolean delimitedIdentifier) {
        return new TypeId(267, new UserDefinedTypeIdImpl(className), delimitedIdentifier);
    }

    public static TypeId getSQLTypeForJavaType(String javaTypeName) {
        if (javaTypeName.equals("java.lang.Boolean") || javaTypeName.equals("boolean")) {
            return BOOLEAN_ID;
        }
        if (javaTypeName.equals("byte[]")) {
            return TypeId.getBuiltInTypeId(-3);
        }
        if (javaTypeName.equals("java.lang.String")) {
            return TypeId.getBuiltInTypeId(12);
        }
        if (javaTypeName.equals("java.lang.Integer") || javaTypeName.equals("int")) {
            return INTEGER_ID;
        }
        if (javaTypeName.equals("byte")) {
            return TypeId.getBuiltInTypeId(-6);
        }
        if (javaTypeName.equals("short")) {
            return TypeId.getBuiltInTypeId(5);
        }
        if (javaTypeName.equals("java.lang.Long") || javaTypeName.equals("long")) {
            return TypeId.getBuiltInTypeId(-5);
        }
        if (javaTypeName.equals("java.lang.Float") || javaTypeName.equals("float")) {
            return TypeId.getBuiltInTypeId(7);
        }
        if (javaTypeName.equals("java.lang.Double") || javaTypeName.equals("double")) {
            return TypeId.getBuiltInTypeId(8);
        }
        if (javaTypeName.equals("java.math.BigDecimal")) {
            return TypeId.getBuiltInTypeId(3);
        }
        if (javaTypeName.equals("java.sql.Date")) {
            return TypeId.getBuiltInTypeId(91);
        }
        if (javaTypeName.equals("java.sql.Time")) {
            return TypeId.getBuiltInTypeId(92);
        }
        if (javaTypeName.equals("java.sql.Timestamp")) {
            return TypeId.getBuiltInTypeId(93);
        }
        if (javaTypeName.equals("java.sql.Blob")) {
            return TypeId.getBuiltInTypeId(2004);
        }
        if (javaTypeName.equals("java.sql.Clob")) {
            return TypeId.getBuiltInTypeId(2005);
        }
        if (javaTypeName.equals("org.apache.derby.iapi.types.XML")) {
            return TypeId.getBuiltInTypeId(456);
        }
        if (javaTypeName.equals("char")) {
            return null;
        }
        return TypeId.getUserDefinedTypeId(javaTypeName, false);
    }

    public static TypeId getBuiltInTypeId(String SQLTypeName) {
        if (SQLTypeName.equals(BOOLEAN_NAME)) {
            return BOOLEAN_ID;
        }
        if (SQLTypeName.equals(CHAR_NAME)) {
            return CHAR_ID;
        }
        if (SQLTypeName.equals(DATE_NAME)) {
            return TypeId.getBuiltInTypeId(91);
        }
        if (SQLTypeName.equals(DOUBLE_NAME)) {
            return TypeId.getBuiltInTypeId(8);
        }
        if (SQLTypeName.equals(FLOAT_NAME)) {
            return TypeId.getBuiltInTypeId(8);
        }
        if (SQLTypeName.equals(INTEGER_NAME)) {
            return INTEGER_ID;
        }
        if (SQLTypeName.equals(LONGINT_NAME)) {
            return TypeId.getBuiltInTypeId(-5);
        }
        if (SQLTypeName.equals(REAL_NAME)) {
            return TypeId.getBuiltInTypeId(7);
        }
        if (SQLTypeName.equals(SMALLINT_NAME)) {
            return TypeId.getBuiltInTypeId(5);
        }
        if (SQLTypeName.equals(TIME_NAME)) {
            return TypeId.getBuiltInTypeId(92);
        }
        if (SQLTypeName.equals(TIMESTAMP_NAME)) {
            return TypeId.getBuiltInTypeId(93);
        }
        if (SQLTypeName.equals(VARCHAR_NAME)) {
            return TypeId.getBuiltInTypeId(12);
        }
        if (SQLTypeName.equals(BIT_NAME)) {
            return TypeId.getBuiltInTypeId(-2);
        }
        if (SQLTypeName.equals(VARBIT_NAME)) {
            return TypeId.getBuiltInTypeId(-3);
        }
        if (SQLTypeName.equals(TINYINT_NAME)) {
            return TypeId.getBuiltInTypeId(-6);
        }
        if (SQLTypeName.equals(DECIMAL_NAME)) {
            return TypeId.getBuiltInTypeId(3);
        }
        if (SQLTypeName.equals(NUMERIC_NAME)) {
            return TypeId.getBuiltInTypeId(2);
        }
        if (SQLTypeName.equals(LONGVARCHAR_NAME)) {
            return TypeId.getBuiltInTypeId(-1);
        }
        if (SQLTypeName.equals(LONGVARBIT_NAME)) {
            return TypeId.getBuiltInTypeId(-4);
        }
        if (SQLTypeName.equals(BLOB_NAME)) {
            return TypeId.getBuiltInTypeId(2004);
        }
        if (SQLTypeName.equals(CLOB_NAME)) {
            return TypeId.getBuiltInTypeId(2005);
        }
        if (SQLTypeName.equals(XML_NAME)) {
            return TypeId.getBuiltInTypeId(456);
        }
        TypeId ret = null;
        if (SQLTypeName.equals(NCLOB_NAME)) {
            ret = NCLOB_ID;
            if (ret == null) {
                ret = NCLOB_ID = new TypeId(448, new BaseTypeIdImpl(449));
            }
        } else if (SQLTypeName.equals(NATIONAL_CHAR_NAME)) {
            ret = NATIONAL_CHAR_ID;
            if (ret == null) {
                ret = NATIONAL_CHAR_ID = new TypeId(370, new BaseTypeIdImpl(366));
            }
        } else if (SQLTypeName.equals(NATIONAL_LONGVARCHAR_NAME)) {
            ret = NATIONAL_LONGVARCHAR_ID;
            if (ret == null) {
                ret = NATIONAL_LONGVARCHAR_ID = new TypeId(362, new BaseTypeIdImpl(368));
            }
        } else if (SQLTypeName.equals(NATIONAL_VARCHAR_NAME)) {
            ret = NATIONAL_VARCHAR_ID;
            if (ret == null) {
                ret = NATIONAL_VARCHAR_ID = new TypeId(369, new BaseTypeIdImpl(367));
            }
        } else if (SQLTypeName.equals(REF_NAME) && (ret = REF_ID) == null) {
            ret = REF_ID = new TypeId(9, new BaseTypeIdImpl(21));
        }
        return ret;
    }

    public TypeId(int formatId) {
        this.formatId = formatId;
        this.setTypeIdSpecificInstanceVariables();
    }

    public TypeId(int formatId, BaseTypeIdImpl baseTypeId) {
        this.formatId = formatId;
        this.baseTypeId = baseTypeId;
        this.setTypeIdSpecificInstanceVariables();
    }

    public TypeId(int formatId, BaseTypeIdImpl baseTypeId, boolean classNameWasDelimitedIdentifier) {
        this.formatId = formatId;
        this.baseTypeId = baseTypeId;
        this.classNameWasDelimitedIdentifier = classNameWasDelimitedIdentifier;
        this.setTypeIdSpecificInstanceVariables();
    }

    public boolean equals(Object that) {
        if (that instanceof TypeId) {
            return this.getSQLTypeName().equals(((TypeId)that).getSQLTypeName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSQLTypeName().hashCode();
    }

    private void setTypeIdSpecificInstanceVariables() {
        switch (this.formatId) {
            case 27: {
                this.typePrecedence = 140;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 254;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 4: {
                this.typePrecedence = 130;
                this.javaTypeName = "java.lang.Boolean";
                this.maxMaxWidth = 1;
                this.isBooleanTypeId = true;
                break;
            }
            case 5: {
                this.typePrecedence = 0;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 254;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 40: {
                this.typePrecedence = 100;
                this.javaTypeName = "java.sql.Date";
                this.maxMaxWidth = 10;
                this.maxPrecision = 10;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 197: {
                this.maxPrecision = 31;
                this.maxScale = 31;
                this.typePrecedence = 70;
                this.javaTypeName = "java.math.BigDecimal";
                this.maxMaxWidth = 31;
                this.isDecimalTypeId = true;
                this.isNumericTypeId = true;
                break;
            }
            case 6: {
                this.maxPrecision = 52;
                this.maxScale = 0;
                this.typePrecedence = 90;
                this.javaTypeName = "java.lang.Double";
                this.maxMaxWidth = 8;
                this.isNumericTypeId = true;
                this.isFloatingPointTypeId = true;
                break;
            }
            case 7: {
                this.maxPrecision = 10;
                this.maxScale = 0;
                this.typePrecedence = 50;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                break;
            }
            case 11: {
                this.maxPrecision = 19;
                this.maxScale = 0;
                this.typePrecedence = 60;
                this.javaTypeName = "java.lang.Long";
                this.maxMaxWidth = 8;
                this.isNumericTypeId = true;
                break;
            }
            case 232: {
                this.typePrecedence = 160;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32700;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 230: {
                this.typePrecedence = 12;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32700;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 370: {
                this.typePrecedence = 16;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 362: {
                this.typePrecedence = 18;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32700;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                break;
            }
            case 369: {
                this.typePrecedence = 17;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 8: {
                this.maxPrecision = 23;
                this.maxScale = 0;
                this.typePrecedence = 80;
                this.javaTypeName = "java.lang.Float";
                this.maxMaxWidth = 4;
                this.isNumericTypeId = true;
                this.isRealTypeId = true;
                this.isFloatingPointTypeId = true;
                break;
            }
            case 9: {
                this.typePrecedence = 25;
                this.isRefTypeId = true;
                break;
            }
            case 10: {
                this.maxPrecision = 5;
                this.maxScale = 0;
                this.typePrecedence = 40;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 2;
                this.isNumericTypeId = true;
                break;
            }
            case 35: {
                this.typePrecedence = 120;
                this.javaTypeName = "java.sql.Time";
                this.maxScale = 0;
                this.maxMaxWidth = 8;
                this.maxPrecision = 8;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 36: {
                this.typePrecedence = 110;
                this.javaTypeName = "java.sql.Timestamp";
                this.maxScale = 6;
                this.maxMaxWidth = 26;
                this.maxPrecision = 26;
                this.isDateTimeTimeStampTypeId = true;
                break;
            }
            case 195: {
                this.maxPrecision = 3;
                this.maxScale = 0;
                this.typePrecedence = 30;
                this.javaTypeName = "java.lang.Integer";
                this.maxMaxWidth = 1;
                this.isNumericTypeId = true;
                break;
            }
            case 267: {
                if (this.baseTypeId != null) {
                    this.setUserTypeIdInfo();
                } else {
                    this.typePrecedence = 1000;
                }
                this.maxMaxWidth = -1;
                this.isUserDefinedTypeId = true;
                break;
            }
            case 29: {
                this.typePrecedence = 150;
                this.javaTypeName = "byte[]";
                this.maxMaxWidth = 32672;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 440: {
                this.typePrecedence = 170;
                this.javaTypeName = "java.sql.Blob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isBitTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                break;
            }
            case 13: {
                this.typePrecedence = 10;
                this.javaTypeName = "java.lang.String";
                this.maxMaxWidth = 32672;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                break;
            }
            case 444: {
                this.typePrecedence = 14;
                this.javaTypeName = "java.sql.Clob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                break;
            }
            case 448: {
                this.typePrecedence = 13;
                this.javaTypeName = "java.sql.Clob";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isStringTypeId = true;
                this.isConcatableTypeId = true;
                this.isLongConcatableTypeId = true;
                this.isLOBTypeId = true;
                break;
            }
            case 456: {
                this.typePrecedence = 180;
                this.javaTypeName = "org.apache.derby.iapi.types.XML";
                this.maxMaxWidth = Integer.MAX_VALUE;
                this.isLongConcatableTypeId = true;
            }
        }
    }

    public final int getJDBCTypeId() {
        return this.baseTypeId.getJDBCTypeId();
    }

    public String getSQLTypeName() {
        return this.baseTypeId.getSQLTypeName();
    }

    public final boolean userType() {
        return this.baseTypeId.userType();
    }

    public int getMaximumPrecision() {
        return this.maxPrecision;
    }

    public int getMaximumScale() {
        return this.maxScale;
    }

    public void setNestedTypeId(BaseTypeIdImpl typeId) {
        this.baseTypeId = typeId;
        switch (this.formatId) {
            case 267: {
                this.setUserTypeIdInfo();
            }
        }
    }

    private void setUserTypeIdInfo() {
        UserDefinedTypeIdImpl baseUserTypeId = (UserDefinedTypeIdImpl)this.baseTypeId;
        this.typePrecedence = 1000;
        this.javaTypeName = baseUserTypeId.getClassName();
    }

    public boolean getClassNameWasDelimitedIdentifier() {
        return this.classNameWasDelimitedIdentifier;
    }

    public boolean isStringTypeId() {
        return this.isStringTypeId;
    }

    public boolean isDateTimeTimeStampTypeId() {
        return this.isDateTimeTimeStampTypeId;
    }

    public boolean isRealTypeId() {
        return this.isRealTypeId;
    }

    public boolean isFloatingPointTypeId() {
        return this.isFloatingPointTypeId;
    }

    public boolean isDoubleTypeId() {
        return this.isFloatingPointTypeId && !this.isRealTypeId;
    }

    public boolean isFixedStringTypeId() {
        return this.formatId == 5 || this.formatId == 370;
    }

    public boolean isClobTypeId() {
        return this.formatId == 444 || this.formatId == 448;
    }

    public boolean isBlobTypeId() {
        return this.formatId == 440;
    }

    public boolean isLongVarcharTypeId() {
        return this.formatId == 230 || this.formatId == 362;
    }

    public boolean isDateTimeTimeStampTypeID() {
        return this.formatId == 40 || this.formatId == 35 || this.formatId == 36;
    }

    public boolean isNationalStringTypeId() {
        switch (this.formatId) {
            default: {
                return false;
            }
            case 362: 
            case 369: 
            case 370: 
            case 448: 
        }
        return true;
    }

    public boolean isXMLTypeId() {
        return this.formatId == 456;
    }

    public boolean orderable(ClassFactory cf) {
        boolean orderable;
        switch (this.formatId) {
            case 230: 
            case 232: 
            case 362: 
            case 440: 
            case 444: 
            case 448: 
            case 456: {
                return false;
            }
            case 267: {
                UserDefinedTypeIdImpl baseUserTypeId = (UserDefinedTypeIdImpl)this.baseTypeId;
                String className = baseUserTypeId.getClassName();
                try {
                    Class c = cf.getClassInspector().getClass(className);
                    orderable = Comparable.class.isAssignableFrom(c);
                }
                catch (ClassNotFoundException cnfe) {
                    orderable = false;
                }
                break;
            }
            default: {
                orderable = true;
            }
        }
        return orderable;
    }

    public int typePrecedence() {
        return this.typePrecedence;
    }

    public String getCorrespondingJavaTypeName() {
        if (this.formatId == 9) {
            SanityManager.THROWASSERT("getCorrespondingJavaTypeName not implemented for StoredFormatIds.REF_TYPE_ID");
        }
        SanityManager.ASSERT(this.javaTypeName != null, "javaTypeName expected to be non-null");
        return this.javaTypeName;
    }

    public String getResultSetMetaDataTypeName() {
        if (BLOB_ID != null && BLOB_ID.equals(this)) {
            return "java.sql.Blob";
        }
        if (CLOB_ID != null && CLOB_ID.equals(this)) {
            return "java.sql.Clob";
        }
        if (NCLOB_ID != null && NCLOB_ID.equals(this)) {
            return "java.sql.Clob";
        }
        return this.getCorrespondingJavaTypeName();
    }

    public int getMaximumMaximumWidth() {
        return this.maxMaxWidth;
    }

    public String toParsableString(DataTypeDescriptor dts) {
        return this.baseTypeId.toParsableString(dts);
    }

    public boolean isNumericTypeId() {
        return this.isNumericTypeId;
    }

    public boolean isDecimalTypeId() {
        return this.isDecimalTypeId;
    }

    public boolean isBooleanTypeId() {
        return this.isBooleanTypeId;
    }

    public boolean isRefTypeId() {
        return this.isRefTypeId;
    }

    public boolean isConcatableTypeId() {
        return this.isConcatableTypeId;
    }

    public boolean isBitTypeId() {
        return this.isBitTypeId;
    }

    public boolean isLOBTypeId() {
        return this.isLOBTypeId;
    }

    public boolean isLongConcatableTypeId() {
        return this.isLongConcatableTypeId;
    }

    public boolean isUserDefinedTypeId() {
        return this.isUserDefinedTypeId;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.baseTypeId = (BaseTypeIdImpl)in.readObject();
        switch (this.formatId) {
            case 267: {
                this.setTypeIdSpecificInstanceVariables();
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.baseTypeId);
    }

    public int getTypeFormatId() {
        return this.formatId;
    }

    public DataValueDescriptor getNull() {
        switch (this.formatId) {
            case 27: {
                return new SQLBit();
            }
            case 4: {
                return new SQLBoolean();
            }
            case 5: {
                return new SQLChar();
            }
            case 197: {
                return decimalImplementation.getNewNull();
            }
            case 6: {
                return new SQLDouble();
            }
            case 7: {
                return new SQLInteger();
            }
            case 11: {
                return new SQLLongint();
            }
            case 232: {
                return new SQLLongVarbit();
            }
            case 440: {
                return new SQLBlob();
            }
            case 444: {
                return new SQLClob();
            }
            case 448: {
                return new SQLNClob();
            }
            case 230: {
                return new SQLLongvarchar();
            }
            case 370: {
                return new SQLNationalChar();
            }
            case 369: {
                return new SQLNationalVarchar();
            }
            case 362: {
                return new SQLNationalLongvarchar();
            }
            case 8: {
                return new SQLReal();
            }
            case 9: {
                return new SQLRef();
            }
            case 10: {
                return new SQLSmallint();
            }
            case 195: {
                return new SQLTinyint();
            }
            case 40: {
                return new SQLDate();
            }
            case 35: {
                return new SQLTime();
            }
            case 36: {
                return new SQLTimestamp();
            }
            case 267: {
                return new UserType();
            }
            case 29: {
                return new SQLVarbit();
            }
            case 13: {
                return new SQLVarchar();
            }
            case 456: {
                return new XML();
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in getNull() - " + this.formatId);
        return null;
    }

    public boolean streamStorable() {
        return this.isStringTypeId() || this.isBitTypeId();
    }

    public int getApproximateLengthInBytes(DataTypeDescriptor dts) {
        switch (this.formatId) {
            case 27: {
                return (int)Math.ceil((double)dts.getMaximumWidth() / 8.0);
            }
            case 5: 
            case 370: {
                return 2 * dts.getMaximumWidth() + 2;
            }
            case 197: {
                if (dts.getPrecision() == Integer.MAX_VALUE) {
                    return 200;
                }
                return 8 + (int)Math.ceil((double)dts.getPrecision() / 2.0);
            }
            case 232: 
            case 440: 
            case 444: 
            case 448: 
            case 456: {
                return 10240;
            }
            case 9: {
                return 16;
            }
            case 267: {
                return 200;
            }
            case 29: {
                if (dts.getMaximumWidth() == Integer.MAX_VALUE) {
                    return 200;
                }
                return (int)Math.ceil((double)dts.getMaximumWidth() / 8.0);
            }
            case 13: 
            case 230: 
            case 362: 
            case 369: {
                if (dts.getMaximumWidth() == Integer.MAX_VALUE) {
                    return 200;
                }
                return dts.getMaximumWidth() * 2 + 2;
            }
            case 40: {
                return 18;
            }
            case 35: {
                return 16;
            }
            case 36: {
                return 29;
            }
        }
        return dts.getMaximumWidth();
    }

    public BaseTypeIdImpl getBaseTypeId() {
        return this.baseTypeId;
    }

    public int getPrecision(DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.formatId != 197) {
            SanityManager.THROWASSERT("getPrecision() not expected to be called for formatId - " + this.formatId);
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        long val = (long)this.getScale(leftType, rightType) + Math.max(lprec - lscale, rprec - rscale);
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        return (int)val;
    }

    public int getScale(DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.formatId != 197) {
            SanityManager.THROWASSERT("getPrecision() not expected to be called for formatId - " + this.formatId);
        }
        return Math.max(leftType.getScale(), rightType.getScale());
    }

    public boolean variableLength() {
        switch (this.formatId) {
            case 5: 
            case 13: 
            case 27: 
            case 29: 
            case 197: 
            case 369: 
            case 370: 
            case 440: 
            case 444: {
                return true;
            }
        }
        return false;
    }
}

