/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLVarchar
extends SQLChar {
    public String getTypeName() {
        return "VARCHAR";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLVarchar(this.getString());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLVarchar();
    }

    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLVarchar s = new CollatorSQLVarchar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    public int getTypeFormatId() {
        return 85;
    }

    public SQLVarchar() {
    }

    public SQLVarchar(String val) {
        super(val);
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, source.getString());
    }

    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        int sourceWidth = sourceValue.length();
        if (sourceWidth > desiredWidth) {
            this.hasNonBlankChars(sourceValue, desiredWidth, sourceWidth);
            sourceValue = sourceValue.substring(0, desiredWidth);
        }
        this.setValue(sourceValue);
    }

    public int typePrecedence() {
        return 10;
    }

    protected final int growBy() {
        return 4096;
    }
}

