/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.util.StringUtil;

public class SQLVarbit
extends SQLBit {
    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    int getMaxMemoryUsage() {
        return 32672;
    }

    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    public int getTypeFormatId() {
        return 88;
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        byte[] sourceData = source.getBytes();
        this.setValue(sourceData);
        if (sourceData.length > desiredWidth) {
            this.setWidth(desiredWidth, 0, true);
        }
    }

    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int sourceWidth = this.dataValue.length;
        if (sourceWidth > desiredWidth) {
            if (errorOnTrunc) {
                for (int i = desiredWidth; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(this.toString()), (Object)String.valueOf(desiredWidth));
                }
            }
            byte[] shrunkData = new byte[desiredWidth];
            System.arraycopy(this.dataValue, 0, shrunkData, 0, desiredWidth);
            this.dataValue = shrunkData;
        }
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] val) {
        super(val);
    }

    public int typePrecedence() {
        return 150;
    }
}

