/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLTinyint
extends NumberDataType {
    static final int TINYINT_LENGTH = 1;
    private byte value;
    private boolean isnull;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTinyint.class);

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public SQLTinyint() {
        this.isnull = true;
    }

    public SQLTinyint(byte val) {
        this.value = val;
    }

    public SQLTinyint(byte val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    public int getInt() {
        return this.value;
    }

    public byte getByte() {
        return this.value;
    }

    public short getShort() {
        return this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.value != 0;
    }

    public String getString() {
        return this.isNull() ? null : Byte.toString(this.value);
    }

    public int getLength() {
        return 1;
    }

    public Object getObject() {
        return this.isNull() ? null : new Integer(this.value);
    }

    public String getTypeName() {
        return "TINYINT";
    }

    public int getTypeFormatId() {
        return 199;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeByte(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readByte();
        this.isnull = false;
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readByte();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        int otherValue;
        int thisValue = this.getInt();
        if (thisValue == (otherValue = arg.getInt())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor getClone() {
        return new SQLTinyint(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLTinyint();
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getByte(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
    }

    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -6);
            return;
        }
        ps.setByte(position, this.value);
    }

    public final void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateByte(position, this.value);
    }

    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Byte.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    public void setValue(byte theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    public void setValue(short theValue) throws StandardException {
        if (theValue > 127 || theValue < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)theValue;
        this.isnull = false;
    }

    public void setValue(int theValue) throws StandardException {
        if (theValue > 127 || theValue < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)theValue;
        this.isnull = false;
    }

    public void setValue(long theValue) throws StandardException {
        if (theValue > 127L || theValue < -128L) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)theValue;
        this.isnull = false;
    }

    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 127.0f || theValue < -128.0f) {
            throw StandardException.newException("22003", "TINYINT");
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (byte)floorValue;
        this.isnull = false;
    }

    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 127.0 || theValue < -128.0) {
            throw this.outOfRange();
        }
        double floorValue = Math.floor(theValue);
        this.value = (byte)floorValue;
        this.isnull = false;
    }

    public void setValue(boolean theValue) {
        this.value = theValue ? (byte)1 : 0;
        this.isnull = false;
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getByte());
    }

    public int typePrecedence() {
        return 30;
    }

    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() == right.getByte());
    }

    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() != right.getByte());
    }

    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() < right.getByte());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() > right.getByte());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() <= right.getByte());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getByte() >= right.getByte());
    }

    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLTinyint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        int product = left.getByte() * right.getByte();
        result.setValue(product);
        return result;
    }

    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLTinyint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        byte byteDivisor = divisor.getByte();
        if (byteDivisor == 0) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getByte() % byteDivisor);
        return result;
    }

    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLTinyint();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        byte operandValue = this.getByte();
        result.setValue((int)(-operandValue));
        return result;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Byte.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }
}

