/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;

public class SQLRef
extends DataType
implements RefDataValue {
    protected RowLocation value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLRef.class);

    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.value) {
            sz += this.value.estimateMemoryUsage();
        }
        return sz;
    }

    public String getString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public Object getObject() {
        return this.value;
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue.isNull()) {
            this.setToNull();
        } else {
            this.value = (RowLocation)theValue.getObject();
        }
    }

    public int getLength() {
        return -1;
    }

    public String getTypeName() {
        return "REF";
    }

    public int getTypeFormatId() {
        return 82;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(this.value != null, "writeExternal() is not supposed to be called for null values.");
        out.writeObject(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)in.readObject();
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.value = (RowLocation)in.readObject();
    }

    public void restoreToNull() {
        this.value = null;
    }

    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        return this.value.compare(op, ((SQLRef)other).value, orderedNulls, unknownRV);
    }

    public int compare(DataValueDescriptor other) throws StandardException {
        return this.value.compare(((SQLRef)other).value);
    }

    public DataValueDescriptor getClone() {
        if (this.value == null) {
            return new SQLRef();
        }
        return new SQLRef((RowLocation)this.value.cloneObject());
    }

    public DataValueDescriptor getNewNull() {
        return new SQLRef();
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) {
        SanityManager.THROWASSERT("setValueFromResultSet() is not supposed to be called for SQLRef.");
    }

    public void setInto(PreparedStatement ps, int position) {
        SanityManager.THROWASSERT("setValueInto(PreparedStatement) is not supposed to be called for SQLRef.");
    }

    public SQLRef() {
    }

    public SQLRef(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public void setValue(RowLocation rowLocation) {
        this.value = rowLocation;
    }

    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value.toString();
    }
}

