/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLNationalVarchar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLNationalLongvarchar
extends SQLLongvarchar {
    public String getTypeName() {
        return "LONG NVARCHAR";
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLNationalLongvarchar(this.getString(), this.getLocaleFinder());
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("Unexpected exception", se);
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        SQLNationalLongvarchar result = new SQLNationalLongvarchar();
        result.setLocaleFinder(this.getLocaleFinder());
        return result;
    }

    public int getTypeFormatId() {
        return 365;
    }

    public SQLNationalLongvarchar() {
    }

    public SQLNationalLongvarchar(String val, LocaleFinder localeFinder) {
        super(val);
        this.setLocaleFinder(localeFinder);
    }

    public Date getDate(Calendar cal) throws StandardException {
        return this.nationalGetDate(cal);
    }

    public Time getTime(Calendar cal) throws StandardException {
        return this.nationalGetTime(cal);
    }

    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        return this.nationalGetTimestamp(cal);
    }

    public int typePrecedence() {
        return 18;
    }

    protected int stringCompare(SQLChar char1, SQLChar char2) throws StandardException {
        return char1.stringCollatorCompare(char2);
    }

    protected StringDataValue getNewVarchar() {
        return new SQLNationalVarchar();
    }

    protected boolean isNationalString() {
        return true;
    }

    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.setValue(this.getDateFormat(cal).format(theValue));
    }

    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.setValue(this.getTimeFormat(cal).format(theValue));
    }

    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.setValue(this.getTimestampFormat(cal).format(theValue));
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(((DataType)theValue).getNationalString(this.getLocaleFinder()));
    }

    public int hashCode() {
        return this.nationalHashCode();
    }

    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, ((DataType)source).getNationalString(this.getLocaleFinder()));
    }
}

